/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LittleEndian {
    private LittleEndian() {
    }

    public static final int readShort(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    public static final int readInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    public static final long readLong(byte[] byArray, int n) {
        return (long)LittleEndian.readInt(byArray, n) & 0xFFFFFFFFL | (long)LittleEndian.readInt(byArray, n + 4) << 32;
    }

    public static final int readShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (0 <= n && 0 <= n2) {
            return n & 0xFF | (n2 & 0xFF) << 8;
        }
        throw new EOFException();
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (0 <= n && 0 <= n2 && 0 <= n3 && 0 <= n4) {
            return n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16 | n4 << 24;
        }
        throw new EOFException();
    }

    public static final long readLong(InputStream inputStream) throws IOException {
        return (long)LittleEndian.readInt(inputStream) & 0xFFFFFFFFL | (long)LittleEndian.readInt(inputStream) << 32;
    }

    public static final void writeShort(byte[] byArray, int n, int n2) {
        if (0 > n || n + 1 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
    }

    public static final void writeInt(byte[] byArray, int n, int n2) {
        if (0 > n || n + 3 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)(n2 >> 16);
        byArray[n + 3] = (byte)(n2 >> 24);
    }

    public static final void writeLong(byte[] byArray, int n, long l) {
        if (0 > n || n + 7 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        LittleEndian.writeInt(byArray, n, (int)l);
        LittleEndian.writeInt(byArray, n + 4, (int)(l >> 32));
    }

    public static final void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
    }

    public static final void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
    }

    public static final void writeLong(OutputStream outputStream, long l) throws IOException {
        int n = (int)l;
        int n2 = (int)(l >> 32);
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
        outputStream.write(n2 & 0xFF);
        outputStream.write(n2 >> 8 & 0xFF);
        outputStream.write(n2 >> 16 & 0xFF);
        outputStream.write(n2 >>> 24);
    }
}

