/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.analysis.util.CharArrayMap;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class StemmerOverrideFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArrayMap<String> dictionary = null;
    private boolean ignoreCase;

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String dictionaryFiles = (String)this.args.get("dictionary");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (dictionaryFiles != null) {
            this.assureMatchVersion();
            List<String> files = this.splitFileNames(dictionaryFiles);
            if (files.size() > 0) {
                this.dictionary = new CharArrayMap(this.luceneMatchVersion, files.size() * 10, this.ignoreCase);
                for (String file : files) {
                    List<String> list = this.getLines(loader, file.trim());
                    for (String line : list) {
                        String[] mapping = line.split("\t", 2);
                        this.dictionary.put(mapping[0], mapping[1]);
                    }
                }
            }
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.dictionary == null ? input : new StemmerOverrideFilter(input, this.dictionary);
    }
}

