/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.entity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RobotsTxt {
    protected static final String ALL_BOTS = "*";
    protected final Map<String, Directives> agentsToDirectives = new LinkedHashMap<String, Directives>();

    public RobotsTxt() {
        Directives defaultDirectives = new Directives();
        defaultDirectives.crawlDelay = 0;
        this.agentsToDirectives.put(ALL_BOTS, defaultDirectives);
    }

    public boolean allows(String path, String userAgent) {
        Directives directives = this.getDirectives(userAgent.toLowerCase(Locale.ENGLISH));
        if (directives == null) {
            return true;
        }
        return directives.allows(path);
    }

    public int getCrawlDelay(String userAgent) {
        Directives directives = this.getDirectives(userAgent.toLowerCase(Locale.ENGLISH));
        if (directives == null) {
            return 0;
        }
        return directives.getCrawlDelay();
    }

    public Directives getDirectives(String userAgent) {
        return this.getDirectives(userAgent, ALL_BOTS);
    }

    public Directives getDirectives(String userAgent, String defaultUserAgent) {
        Directives directives = this.agentsToDirectives.get(userAgent);
        if (directives == null && defaultUserAgent != null) {
            directives = this.agentsToDirectives.get(defaultUserAgent);
        }
        return directives;
    }

    public void addDirectives(String userAgent, Directives directives) {
        this.agentsToDirectives.put(userAgent, directives);
    }

    public String[] getUserAgents() {
        Set<String> userAgentSet = this.agentsToDirectives.keySet();
        return userAgentSet.toArray(new String[userAgentSet.size()]);
    }

    public static class Directives {
        private int crawlDelay;
        private final List<String> allowedPaths = new ArrayList<String>();
        private final List<String> disallowedPaths = new ArrayList<String>();

        public void setCrawlDelay(int crawlDelay) {
            this.crawlDelay = crawlDelay;
        }

        public int getCrawlDelay() {
            return this.crawlDelay;
        }

        public boolean allows(String path) {
            for (String allowedPath : this.allowedPaths) {
                if (!path.startsWith(allowedPath)) continue;
                return true;
            }
            for (String disallowedPath : this.disallowedPaths) {
                if (!path.startsWith(disallowedPath)) continue;
                return false;
            }
            return true;
        }

        public void addAllow(String path) {
            this.allowedPaths.add(path);
        }

        public void addDisallow(String path) {
            this.disallowedPaths.add(path);
        }

        public String[] getAllows() {
            return this.allowedPaths.toArray(new String[this.allowedPaths.size()]);
        }

        public String[] getDisallows() {
            return this.disallowedPaths.toArray(new String[this.disallowedPaths.size()]);
        }
    }
}

