/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.base.Charsets;
import java.util.Random;
import org.apache.mahout.common.FastRandomSeedGenerator;
import org.apache.mahout.common.RandomUtils;
import org.uncommons.maths.random.MersenneTwisterRNG;
import org.uncommons.maths.random.RepeatableRNG;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public final class RandomWrapper
extends Random {
    private static final byte[] STANDARD_SEED = "Mahout=Hadoop+ML".getBytes(Charsets.US_ASCII);
    private static final SeedGenerator SEED_GENERATOR = new FastRandomSeedGenerator();
    private static boolean testSeed;
    private Random random;
    private final Long fixedSeed;

    RandomWrapper() {
        this.fixedSeed = null;
        this.random = this.buildRandom();
    }

    RandomWrapper(long fixedSeed) {
        this.fixedSeed = fixedSeed;
        this.random = this.buildRandom();
    }

    static void useTestSeed() {
        testSeed = true;
    }

    private Random buildRandom() {
        if (this.fixedSeed == null) {
            if (testSeed) {
                return new MersenneTwisterRNG(STANDARD_SEED);
            }
            try {
                return new MersenneTwisterRNG(SEED_GENERATOR);
            }
            catch (SeedException se) {
                throw new IllegalStateException(se);
            }
        }
        return new MersenneTwisterRNG(RandomUtils.longSeedtoBytes(this.fixedSeed));
    }

    public Random getRandom() {
        return this.random;
    }

    void reset() {
        this.random = this.buildRandom();
    }

    public long getSeed() {
        return RandomUtils.seedBytesToLong(((RepeatableRNG)this.random).getSeed());
    }

    @Override
    public void setSeed(long seed) {
        this.random = new MersenneTwisterRNG(RandomUtils.longSeedtoBytes(seed));
    }

    @Override
    protected int next(int bits) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    @Override
    public int nextInt() {
        return this.random.nextInt();
    }

    @Override
    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    @Override
    public long nextLong() {
        return this.random.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.random.nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.random.nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.random.nextGaussian();
    }
}

