/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayConverter
implements Converter {
    public static final ArrayConverter INSTANCE = new ArrayConverter();

    ArrayConverter() {
    }

    @Override
    public Object convert(JSON.Context context, Object collection, Class<?> clazz, Type type) throws Exception {
        Object object;
        if (collection instanceof Map) {
            object = (Map)((Object)collection);
            if (!(object instanceof SortedMap)) {
                object = new TreeMap(object);
            }
            collection = object.values();
        }
        if (collection instanceof Collection) {
            object = collection;
            Object object2 = Array.newInstance(clazz.getComponentType(), object.size());
            Class<?> clazz2 = clazz.getComponentType();
            Class<?> clazz3 = type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : clazz2;
            Iterator iterator = object.iterator();
            JSONHint jSONHint = context.getHint();
            int n = 0;
            while (iterator.hasNext()) {
                context.enter(n, jSONHint);
                Array.set(object2, n, context.postparseInternal(iterator.next(), clazz2, clazz3));
                context.exit();
                ++n;
            }
            return object2;
        }
        object = clazz.getComponentType();
        if (collection instanceof String) {
            if (Byte.TYPE.equals(object)) {
                return Base64.decode((String)((Object)collection));
            }
            if (Character.TYPE.equals(object)) {
                return ((String)((Object)collection)).toCharArray();
            }
        }
        Object object3 = Array.newInstance(object, 1);
        Serializable serializable = object;
        Serializable serializable2 = type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : serializable;
        context.enter(0, context.getHint());
        Array.set(object3, 0, context.postparseInternal(collection, serializable, (Type)((Object)serializable2)));
        context.exit();
        return object3;
    }
}

