/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.Statement;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.SqlUpdate;
import org.seasar.extension.jdbc.exception.IllegalParamSizeRuntimeException;
import org.seasar.extension.jdbc.exception.SEntityExistsException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUpdateImpl
extends AbstractQuery<SqlUpdate>
implements SqlUpdate {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    protected Class<?>[] paramClasses;
    protected Object[] params = EMPTY_PARAMS;

    public SqlUpdateImpl(JdbcManagerImplementor jdbcManager, String sql, Class<?> ... paramClasses) {
        super(jdbcManager);
        if (sql == null) {
            throw new NullPointerException("sql");
        }
        this.executedSql = sql;
        if (paramClasses == null) {
            throw new NullPointerException("paramClasses");
        }
        this.paramClasses = paramClasses;
    }

    @Override
    public SqlUpdate params(Object ... params) {
        this.params = params;
        return this;
    }

    @Override
    public int execute() {
        this.prepare("execute");
        try {
            int n = this.executeInternal();
            return n;
        }
        catch (RuntimeException e) {
            if (this.getJdbcManager().getDialect().isUniqueConstraintViolation(e)) {
                throw new SEntityExistsException(this.executedSql, e);
            }
            throw e;
        }
        finally {
            this.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeInternal() {
        if (this.params.length != this.paramClasses.length) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new IllegalParamSizeRuntimeException(this.params.length, this.paramClasses.length);
        }
        for (int j = 0; j < this.params.length; ++j) {
            this.addParam(this.params[j], this.paramClasses[j]);
        }
        this.logSql();
        int ret = 0;
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            PreparedStatement ps = this.getPreparedStatement(jdbcContext);
            ret = PreparedStatementUtil.executeUpdate((PreparedStatement)ps);
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
        return ret;
    }

    protected PreparedStatement getPreparedStatement(JdbcContext jdbcContext) {
        PreparedStatement ps = jdbcContext.getPreparedStatement(this.executedSql);
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
        this.prepareInParams(ps);
        return ps;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
    }
}

