/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.exception.IllegalAccessRuntimeException;
import org.seasar.util.exception.SIllegalArgumentException;
import org.seasar.util.lang.GenericsUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class FieldUtil {
    public static <T> T get(Field field) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        return FieldUtil.get(field, null);
    }

    public static <T> T get(Field field, Object target) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        try {
            return (T)field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static int getInt(Field field) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        return FieldUtil.getInt(field, null);
    }

    public static int getInt(Field field, Object target) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        try {
            return field.getInt(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static String getString(Field field) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        return FieldUtil.getString(field, null);
    }

    public static String getString(Field field, Object target) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        try {
            return (String)field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), ex);
        }
    }

    public static void set(Field field, Object value) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        FieldUtil.set(field, null, value);
    }

    public static void set(Field field, Object target, Object value) throws IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("field", field);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), e);
        }
        catch (IllegalArgumentException e) {
            Class<?> clazz = field.getDeclaringClass();
            Class<?> fieldClass = field.getType();
            Class<?> valueClass = value == null ? null : value.getClass();
            Class<?> targetClass = target == null ? field.getDeclaringClass() : target.getClass();
            throw new SIllegalArgumentException("field", "EUTL0094", ArrayUtil.asArray(clazz.getName(), clazz.getClassLoader(), fieldClass.getName(), fieldClass.getClassLoader(), field.getName(), valueClass == null ? null : valueClass.getName(), valueClass == null ? null : valueClass.getClassLoader(), value, targetClass == null ? null : targetClass.getName(), targetClass == null ? null : targetClass.getClassLoader()), e);
        }
    }

    public static boolean isInstanceField(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        return !Modifier.isStatic(field.getModifiers());
    }

    public static boolean isPublicField(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        return Modifier.isPublic(field.getModifiers());
    }

    public static boolean isFinalField(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        return Modifier.isFinal(field.getModifiers());
    }

    public static Class<?> getElementTypeOfCollection(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        Type type = field.getGenericType();
        return GenericsUtil.getRawClass(GenericsUtil.getElementTypeOfCollection(type));
    }

    public static Class<?> getKeyTypeOfMap(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        Type type = field.getGenericType();
        return GenericsUtil.getRawClass(GenericsUtil.getKeyTypeOfMap(type));
    }

    public static Class<?> getValueTypeOfMap(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        Type type = field.getGenericType();
        return GenericsUtil.getRawClass(GenericsUtil.getValueTypeOfMap(type));
    }
}

