/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class VariableGapTermsIndexReader
extends TermsIndexReaderBase {
    private final PositiveIntOutputs fstOutputs = PositiveIntOutputs.getSingleton((boolean)true);
    private int indexDivisor;
    private IndexInput in;
    private volatile boolean indexLoaded;
    final HashMap<FieldInfo, FieldIndexData> fields = new HashMap();
    private long dirOffset;
    private final int version;
    final String segment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableGapTermsIndexReader(Directory dir, FieldInfos fieldInfos, String segment, int indexDivisor, String segmentSuffix, IOContext context) throws IOException {
        this.in = dir.openInput(IndexFileNames.segmentFileName((String)segment, (String)segmentSuffix, (String)"tiv"), new IOContext(context, true));
        this.segment = segment;
        boolean success = false;
        assert (indexDivisor == -1 || indexDivisor > 0);
        try {
            this.version = this.readHeader(this.in);
            this.indexDivisor = indexDivisor;
            this.seekDir(this.in, this.dirOffset);
            int numFields = this.in.readVInt();
            if (numFields < 0) {
                throw new CorruptIndexException("invalid numFields: " + numFields + " (resource=" + this.in + ")");
            }
            for (int i = 0; i < numFields; ++i) {
                int field = this.in.readVInt();
                long indexStart = this.in.readVLong();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                FieldIndexData previous = this.fields.put(fieldInfo, new FieldIndexData(fieldInfo, indexStart));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name + " (resource=" + this.in + ")");
            }
            success = true;
        }
        finally {
            if (indexDivisor > 0) {
                this.in.close();
                this.in = null;
                if (success) {
                    this.indexLoaded = true;
                }
            }
        }
    }

    @Override
    public int getDivisor() {
        return this.indexDivisor;
    }

    private int readHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)input, (String)"VARIABLE_GAP_TERMS_INDEX", (int)0, (int)1);
        if (version < 1) {
            this.dirOffset = input.readLong();
        }
        return version;
    }

    @Override
    public boolean supportsOrd() {
        return false;
    }

    @Override
    public TermsIndexReaderBase.FieldIndexEnum getFieldEnum(FieldInfo fieldInfo) {
        FieldIndexData fieldData = this.fields.get(fieldInfo);
        if (fieldData.fst == null) {
            return null;
        }
        return new IndexEnum((FST<Long>)fieldData.fst);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null && !this.indexLoaded) {
            this.in.close();
        }
    }

    private void seekDir(IndexInput input, long dirOffset) throws IOException {
        if (this.version >= 1) {
            input.seek(input.length() - 8L);
            dirOffset = input.readLong();
        }
        input.seek(dirOffset);
    }

    private final class FieldIndexData {
        private final long indexStart;
        private volatile FST<Long> fst;

        public FieldIndexData(FieldInfo fieldInfo, long indexStart) throws IOException {
            this.indexStart = indexStart;
            if (VariableGapTermsIndexReader.this.indexDivisor > 0) {
                this.loadTermsIndex();
            }
        }

        private void loadTermsIndex() throws IOException {
            if (this.fst == null) {
                IndexInput clone = VariableGapTermsIndexReader.this.in.clone();
                clone.seek(this.indexStart);
                this.fst = new FST((DataInput)clone, (Outputs)VariableGapTermsIndexReader.this.fstOutputs);
                clone.close();
                if (VariableGapTermsIndexReader.this.indexDivisor > 1) {
                    BytesRefFSTEnum.InputOutput result;
                    IntsRef scratchIntsRef = new IntsRef();
                    PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton((boolean)true);
                    Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
                    BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(this.fst);
                    int count = VariableGapTermsIndexReader.this.indexDivisor;
                    while ((result = fstEnum.next()) != null) {
                        if (count == VariableGapTermsIndexReader.this.indexDivisor) {
                            builder.add(Util.toIntsRef((BytesRef)result.input, (IntsRef)scratchIntsRef), result.output);
                            count = 0;
                        }
                        ++count;
                    }
                    this.fst = builder.finish();
                }
            }
        }
    }

    private static class IndexEnum
    extends TermsIndexReaderBase.FieldIndexEnum {
        private final BytesRefFSTEnum<Long> fstEnum;
        private BytesRefFSTEnum.InputOutput<Long> current;

        public IndexEnum(FST<Long> fst) {
            this.fstEnum = new BytesRefFSTEnum(fst);
        }

        @Override
        public BytesRef term() {
            if (this.current == null) {
                return null;
            }
            return this.current.input;
        }

        @Override
        public long seek(BytesRef target) throws IOException {
            this.current = this.fstEnum.seekFloor(target);
            return (Long)this.current.output;
        }

        @Override
        public long next() throws IOException {
            this.current = this.fstEnum.next();
            if (this.current == null) {
                return -1L;
            }
            return (Long)this.current.output;
        }

        @Override
        public long ord() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long seek(long ord) {
            throw new UnsupportedOperationException();
        }
    }
}

