/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.spatial.prefix.tree.Node;

public abstract class SpatialPrefixTree {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final int maxLevels;
    protected final SpatialContext ctx;
    private transient Node worldNode;

    public SpatialPrefixTree(SpatialContext ctx, int maxLevels) {
        assert (maxLevels > 0);
        this.ctx = ctx;
        this.maxLevels = maxLevels;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(maxLevels:" + this.maxLevels + ",ctx:" + this.ctx + ")";
    }

    public abstract int getLevelForDistance(double var1);

    public Node getWorldNode() {
        if (this.worldNode == null) {
            this.worldNode = this.getNode("");
        }
        return this.worldNode;
    }

    public abstract Node getNode(String var1);

    public abstract Node getNode(byte[] var1, int var2, int var3);

    public final Node getNode(byte[] bytes, int offset, int len, Node target) {
        if (target == null) {
            return this.getNode(bytes, offset, len);
        }
        target.reset(bytes, offset, len);
        return target;
    }

    protected Node getNode(Point p, int level) {
        return this.getNodes(p, level, false).get(0);
    }

    public List<Node> getNodes(Shape shape, int detailLevel, boolean inclParents, boolean simplify) {
        if (detailLevel > this.maxLevels) {
            throw new IllegalArgumentException("detailLevel > maxLevels");
        }
        if (shape instanceof Point) {
            return this.getNodes((Point)shape, detailLevel, inclParents);
        }
        ArrayList<Node> cells = new ArrayList<Node>(inclParents ? 4096 : 2048);
        this.recursiveGetNodes(this.getWorldNode(), shape, detailLevel, inclParents, simplify, cells);
        return cells;
    }

    private boolean recursiveGetNodes(Node node, Shape shape, int detailLevel, boolean inclParents, boolean simplify, List<Node> result) {
        if (node.getLevel() == detailLevel) {
            node.setLeaf();
        }
        if (node.isLeaf()) {
            result.add(node);
            return true;
        }
        if (inclParents && node.getLevel() != 0) {
            result.add(node);
        }
        Collection<Node> subCells = node.getSubCells(shape);
        int leaves = 0;
        for (Node subCell : subCells) {
            if (!this.recursiveGetNodes(subCell, shape, detailLevel, inclParents, simplify, result)) continue;
            ++leaves;
        }
        if (simplify && leaves == node.getSubCellsSize() && node.getLevel() != 0) {
            do {
                result.remove(result.size() - 1);
            } while (--leaves > 0);
            node.setLeaf();
            if (!inclParents) {
                result.add(node);
            }
            return true;
        }
        return false;
    }

    public List<Node> getNodes(Point p, int detailLevel, boolean inclParents) {
        Node cell = this.getNode(p, detailLevel);
        if (!inclParents) {
            return Collections.singletonList(cell);
        }
        String endToken = cell.getTokenString();
        assert (endToken.length() == detailLevel);
        ArrayList<Node> cells = new ArrayList<Node>(detailLevel);
        for (int i = 1; i < detailLevel; ++i) {
            cells.add(this.getNode(endToken.substring(0, i)));
        }
        cells.add(cell);
        return cells;
    }

    public static List<String> nodesToTokenStrings(Collection<Node> nodes) {
        ArrayList<String> tokens = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            String token = node.getTokenString();
            if (node.isLeaf()) {
                tokens.add(token + '+');
                continue;
            }
            tokens.add(token);
        }
        return tokens;
    }
}

