/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.solr.lib.policy.impl;

import java.util.Set;
import org.codelibs.core.util.DynamicProperties;
import org.codelibs.solr.lib.policy.QueryType;
import org.codelibs.solr.lib.policy.StatusPolicy;

public class StatusPolicyImpl
implements StatusPolicy {
    public static final String STATUS_PREFIX = "status.";
    public static final String INDEX_PREFIX = "index.";
    public static final String ACTIVE = "active";
    public static final String INACTIVE = "inactive";
    public static final String COMPLETED = "completed";
    public static final String UNFINISHED = "unfinished";
    public static final String READY = "ready";
    protected DynamicProperties solrGroupProperties;
    protected int minSelectServer = 1;
    protected int minUpdateServer = 1;
    protected long retrySelectQueryInterval = 500L;
    protected long retryUpdateQueryInterval = 500L;
    protected int maxErrorCount = 3;
    protected int maxRetryUpdateQueryCount = 3;
    protected int maxRetrySelectQueryCount = 3;

    @Override
    public void activate(QueryType queryType, String serverName) {
        switch (queryType) {
            case COMMIT: 
            case OPTIMIZE: 
            case ROLLBACK: {
                this.solrGroupProperties.setProperty(this.getIndexKey(serverName), COMPLETED);
                this.solrGroupProperties.setProperty(this.getStatusKey(serverName), ACTIVE);
                this.solrGroupProperties.store();
                break;
            }
            case ADD: 
            case DELETE: {
                this.solrGroupProperties.setProperty(this.getIndexKey(serverName), READY);
                this.solrGroupProperties.setProperty(this.getStatusKey(serverName), ACTIVE);
                this.solrGroupProperties.store();
                break;
            }
            default: {
                this.solrGroupProperties.setProperty(this.getStatusKey(serverName), ACTIVE);
                this.solrGroupProperties.store();
            }
        }
    }

    @Override
    public void deactivate(QueryType queryType, String serverName) {
        switch (queryType) {
            case COMMIT: 
            case OPTIMIZE: 
            case ROLLBACK: 
            case ADD: 
            case DELETE: {
                this.solrGroupProperties.setProperty(this.getIndexKey(serverName), UNFINISHED);
            }
            case PING: 
            case QUERY: 
            case REQUEST: {
                this.solrGroupProperties.setProperty(this.getStatusKey(serverName), INACTIVE);
                this.solrGroupProperties.store();
            }
        }
    }

    @Override
    public boolean isActive(QueryType queryType, Set<String> serverNameSet) {
        int numOfActive = 0;
        for (String serverName : serverNameSet) {
            if (!this.isActive(queryType, serverName)) continue;
            ++numOfActive;
        }
        switch (queryType) {
            case PING: 
            case QUERY: 
            case REQUEST: {
                if (numOfActive < this.minSelectServer) break;
                return true;
            }
            case COMMIT: 
            case OPTIMIZE: 
            case ROLLBACK: 
            case ADD: 
            case DELETE: {
                if (numOfActive < this.minUpdateServer) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isActive(QueryType queryType, String serverName) {
        String serverStatus = this.solrGroupProperties.getProperty(this.getStatusKey(serverName), ACTIVE);
        switch (queryType) {
            case PING: 
            case QUERY: 
            case REQUEST: {
                if (!ACTIVE.equals(serverStatus)) break;
                return true;
            }
            case COMMIT: 
            case OPTIMIZE: 
            case ROLLBACK: 
            case ADD: 
            case DELETE: {
                if (!ACTIVE.equals(serverStatus)) break;
                String serverIndex = this.solrGroupProperties.getProperty(this.getIndexKey(serverName), COMPLETED);
                return COMPLETED.equals(serverIndex) || READY.equals(serverIndex);
            }
        }
        return false;
    }

    @Override
    public void sleep(QueryType queryType) {
        try {
            switch (queryType) {
                case PING: 
                case QUERY: 
                case REQUEST: {
                    Thread.sleep(this.retrySelectQueryInterval);
                    break;
                }
                case COMMIT: 
                case OPTIMIZE: 
                case ROLLBACK: 
                case ADD: 
                case DELETE: {
                    Thread.sleep(this.retryUpdateQueryInterval);
                    break;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public int getMaxRetryCount(QueryType queryType) {
        switch (queryType) {
            case PING: 
            case QUERY: 
            case REQUEST: {
                return this.maxRetrySelectQueryCount;
            }
            case COMMIT: 
            case OPTIMIZE: 
            case ROLLBACK: 
            case ADD: 
            case DELETE: {
                return this.maxRetryUpdateQueryCount;
            }
        }
        return 0;
    }

    @Override
    public int getMaxErrorCount(QueryType queryType) {
        return this.maxErrorCount;
    }

    protected String getStatusKey(String serverName) {
        return STATUS_PREFIX + serverName;
    }

    protected String getIndexKey(String serverName) {
        return INDEX_PREFIX + serverName;
    }

    public DynamicProperties getSolrGroupProperties() {
        return this.solrGroupProperties;
    }

    public void setSolrGroupProperties(DynamicProperties solrGroupProperties) {
        this.solrGroupProperties = solrGroupProperties;
    }

    public int getMinSelectServer() {
        return this.minSelectServer;
    }

    public void setMinSelectServer(int minSelectServer) {
        this.minSelectServer = minSelectServer;
    }

    public int getMinUpdateServer() {
        return this.minUpdateServer;
    }

    public void setMinUpdateServer(int minUpdateServer) {
        this.minUpdateServer = minUpdateServer;
    }

    public long getRetrySelectQueryInterval() {
        return this.retrySelectQueryInterval;
    }

    public void setRetrySelectQueryInterval(long retrySelectQueryInterval) {
        this.retrySelectQueryInterval = retrySelectQueryInterval;
    }

    public long getRetryUpdateQueryInterval() {
        return this.retryUpdateQueryInterval;
    }

    public void setRetryUpdateQueryInterval(long retryUpdateQueryInterval) {
        this.retryUpdateQueryInterval = retryUpdateQueryInterval;
    }

    public int getMaxErrorCount() {
        return this.maxErrorCount;
    }

    public void setMaxErrorCount(int maxErrorCount) {
        this.maxErrorCount = maxErrorCount;
    }

    public int getMaxRetryUpdateQueryCount() {
        return this.maxRetryUpdateQueryCount;
    }

    public void setMaxRetryUpdateQueryCount(int maxRetryUpdateQueryCount) {
        this.maxRetryUpdateQueryCount = maxRetryUpdateQueryCount;
    }

    public int getMaxRetrySelectQueryCount() {
        return this.maxRetrySelectQueryCount;
    }

    public void setMaxRetrySelectQueryCount(int maxRetrySelectQueryCount) {
        this.maxRetrySelectQueryCount = maxRetrySelectQueryCount;
    }
}

