/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.solr.lib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.solr.client.solrj.SolrServer;
import org.codelibs.core.util.DynamicProperties;
import org.codelibs.solr.lib.SolrGroup;
import org.codelibs.solr.lib.exception.SolrLibException;
import org.codelibs.solr.lib.policy.QueryType;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.log.Logger;

public class SolrGroupManager {
    private static final Logger logger = Logger.getLogger(SolrGroupManager.class);
    protected Map<String, SolrGroup> solrGroupMap = new LinkedHashMap<String, SolrGroup>();
    protected Timer monitorTimer;
    protected String selectGroupName;
    protected String updateGroupName;
    protected DynamicProperties solrProperties;
    protected long monitoringInterval = 60000L;

    public long getMonitoringInterval() {
        return this.monitoringInterval;
    }

    public void setMonitoringInterval(long monitoringInterval) {
        this.monitoringInterval = monitoringInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.solrProperties == null) {
            throw new SolrLibException("ESL0010");
        }
        this.selectGroupName = this.solrProperties.getProperty("select.group", "");
        this.updateGroupName = this.solrProperties.getProperty("update.group", "");
        if (this.solrGroupMap.get(this.selectGroupName) == null) {
            this.selectGroupName = null;
            this.updateGroupName = null;
        }
        if (this.selectGroupName == null) {
            DynamicProperties dynamicProperties = this.solrProperties;
            synchronized (dynamicProperties) {
                if (this.selectGroupName != null) {
                    return;
                }
                int numOfGroup = this.solrGroupMap.size();
                if (numOfGroup <= 0) {
                    throw new SolrLibException("ESL0009");
                }
                Set<String> nameSet = this.solrGroupMap.keySet();
                if (nameSet.size() == 1) {
                    Iterator<String> itr = nameSet.iterator();
                    this.updateGroupName = this.selectGroupName = itr.next();
                } else {
                    Iterator<String> itr = nameSet.iterator();
                    this.selectGroupName = itr.next();
                    this.updateGroupName = itr.next();
                }
                this.solrProperties.setProperty("select.group", this.selectGroupName);
                this.solrProperties.setProperty("update.group", this.updateGroupName);
                this.solrProperties.store();
            }
        }
        if (this.monitorTimer != null) {
            this.monitorTimer.cancel();
        }
        this.monitorTimer = new Timer("SolrGroupMonitor");
        this.monitorTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (Map.Entry<String, SolrGroup> entry : SolrGroupManager.this.solrGroupMap.entrySet()) {
                    try {
                        entry.getValue().updateStatus();
                    }
                    catch (Exception e) {
                        logger.log(Logger.format((String)"ISL0001", (Object[])new Object[]{entry.getKey()}), (Throwable)e);
                    }
                }
            }
        }, this.monitoringInterval, this.monitoringInterval);
    }

    public void destory() {
        this.monitorTimer.cancel();
    }

    public SolrGroup getSolrGroup(QueryType queryType) {
        switch (queryType) {
            case ADD: 
            case COMMIT: 
            case DELETE: 
            case OPTIMIZE: 
            case ROLLBACK: {
                return this.getSolrGroup(this.updateGroupName);
            }
            case QUERY: 
            case REQUEST: {
                return this.getSolrGroup(this.selectGroupName);
            }
        }
        throw new SolrLibException("ESL0009");
    }

    public SolrGroup getSolrGroup(String solrServerGroupName) {
        SolrGroup solrGroup = this.solrGroupMap.get(solrServerGroupName);
        if (solrGroup == null) {
            throw new SolrLibException("ESL0008", new Object[]{solrServerGroupName});
        }
        return solrGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNewSolrGroup() {
        DynamicProperties dynamicProperties = this.solrProperties;
        synchronized (dynamicProperties) {
            int num;
            this.selectGroupName = this.updateGroupName;
            Set<String> nameSet = this.solrGroupMap.keySet();
            String[] names = nameSet.toArray(new String[nameSet.size()]);
            for (num = 0; num < names.length && !names[num].equals(this.selectGroupName); ++num) {
            }
            if (++num >= names.length) {
                num = 0;
            }
            this.updateGroupName = names[num];
            this.solrProperties.setProperty("select.group", this.selectGroupName);
            this.solrProperties.setProperty("update.group", this.updateGroupName);
            this.solrProperties.store();
        }
    }

    public String[] getSolrGroupNames() {
        Set<String> nameSet = this.solrGroupMap.keySet();
        return nameSet.toArray(new String[nameSet.size()]);
    }

    public String[] getSolrServerNames() {
        ArrayList<String> serverNameList = new ArrayList<String>();
        for (Map.Entry<String, SolrGroup> groupEntry : this.solrGroupMap.entrySet()) {
            for (Map.Entry<String, SolrServer> serverEntry : groupEntry.getValue().solrServerMap.entrySet()) {
                serverNameList.add(groupEntry.getKey() + ":" + serverEntry.getKey());
            }
        }
        return serverNameList.toArray(new String[serverNameList.size()]);
    }

    public void addSolrGroup(SolrGroup solrGroup) {
        String name = solrGroup.getGroupName();
        if (StringUtil.isBlank((String)name)) {
            throw new SolrLibException("ESL0007");
        }
        this.solrGroupMap.put(name, solrGroup);
    }

    public DynamicProperties getSolrProperties() {
        return this.solrProperties;
    }

    public void setSolrProperties(DynamicProperties groupStatusProperties) {
        this.solrProperties = groupStatusProperties;
    }
}

