/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.converter;

import com.ibm.icu.text.Transliterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sf.fess.suggest.FessSuggestException;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadingConverter
implements SuggestConverter {
    private static final Logger logger = LoggerFactory.getLogger(ReadingConverter.class);
    private static final String USER_DICT_ENCODING = "fess.user.dict.encoding";
    private static final String USER_DICT_PATH = "fess.user.dict.path";
    protected volatile UserDictionary userDictionary;
    protected volatile boolean initialized = false;
    private final Transliterator transliterator = Transliterator.getInstance((String)"Hiragana-Katakana");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.initialized) {
            return;
        }
        ReadingConverter readingConverter = this;
        synchronized (readingConverter) {
            if (this.initialized) {
                return;
            }
            String path = System.getProperty(USER_DICT_PATH);
            if (path != null) {
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(path);
                    String encoding = System.getProperty(USER_DICT_ENCODING);
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    InputStreamReader reader = new InputStreamReader((InputStream)stream, decoder);
                    this.userDictionary = new UserDictionary((Reader)reader);
                }
                catch (Exception e) {
                    throw new FessSuggestException(e);
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convert(String query) {
        this.init();
        LinkedHashMap<String, String> termMap = new LinkedHashMap<String, String>();
        JapaneseTokenizer stream = null;
        try {
            stream = new JapaneseTokenizer((Reader)new StringReader(query), this.userDictionary, true, JapaneseTokenizer.Mode.NORMAL);
            stream.reset();
            while (stream.incrementToken()) {
                CharTermAttribute att = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
                String term = att.toString();
                ReadingAttribute rdAttr = (ReadingAttribute)stream.getAttribute(ReadingAttribute.class);
                String reading = rdAttr.getReading();
                if (StringUtils.isNotBlank((String)reading)) {
                    termMap.put(term, reading);
                    continue;
                }
                termMap.put(term, this.transliterator.transliterate(term));
            }
        }
        catch (Exception e) {
            logger.warn("JapaneseTokenizer stream error", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        StringBuilder buf = new StringBuilder();
        int pos = 0;
        for (Map.Entry entry : termMap.entrySet()) {
            String term = (String)entry.getKey();
            String reading = (String)entry.getValue();
            int index = query.indexOf(term, pos);
            if (index - pos > 0) {
                buf.append(this.transliterator.transliterate(query.substring(pos, index)));
            }
            buf.append(reading);
            pos = index + term.length();
        }
        if (pos < query.length()) {
            buf.append(query.substring(pos));
        }
        return buf.toString();
    }
}

