/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUtils {
    CASImpl cas;
    private int intListType;
    private int floatListType;
    private int stringListType;
    private int fsListType;
    private int neIntListType;
    private int neFloatListType;
    private int neStringListType;
    private int neFsListType;
    private int eIntListType;
    private int eFloatListType;
    private int eStringListType;
    private int eFsListType;
    private int intHeadFeat;
    private int intTailFeat;
    private int floatHeadFeat;
    private int floatTailFeat;
    private int stringHeadFeat;
    private int stringTailFeat;
    private int fsHeadFeat;
    private int fsTailFeat;
    private Logger logger;
    private ErrorHandler eh;

    public ListUtils(CASImpl aCASImpl, Logger aLogger, ErrorHandler aErrorHandler) {
        this.cas = aCASImpl;
        this.logger = aLogger;
        this.eh = aErrorHandler;
        TypeSystemImpl ts = aCASImpl.getTypeSystemImpl();
        this.intListType = ts.ll_getCodeForTypeName("uima.cas.IntegerList");
        this.floatListType = ts.ll_getCodeForTypeName("uima.cas.FloatList");
        this.stringListType = ts.ll_getCodeForTypeName("uima.cas.StringList");
        this.fsListType = ts.ll_getCodeForTypeName("uima.cas.FSList");
        this.neIntListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyIntegerList");
        this.neFloatListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyFloatList");
        this.neStringListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyStringList");
        this.neFsListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyFSList");
        this.eIntListType = ts.ll_getCodeForTypeName("uima.cas.EmptyIntegerList");
        this.eFloatListType = ts.ll_getCodeForTypeName("uima.cas.EmptyFloatList");
        this.eStringListType = ts.ll_getCodeForTypeName("uima.cas.EmptyStringList");
        this.eFsListType = ts.ll_getCodeForTypeName("uima.cas.EmptyFSList");
        this.intHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:head");
        this.floatHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:head");
        this.stringHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:head");
        this.fsHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:head");
        this.intTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:tail");
        this.floatTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:tail");
        this.stringTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:tail");
        this.fsTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:tail");
    }

    public boolean isIntListType(int type) {
        return type == this.intListType || type == this.neIntListType || type == this.eIntListType;
    }

    public boolean isFloatListType(int type) {
        return type == this.floatListType || type == this.neFloatListType || type == this.eFloatListType;
    }

    public boolean isStringListType(int type) {
        return type == this.stringListType || type == this.neStringListType || type == this.eStringListType;
    }

    public boolean isFsListType(int type) {
        return type == this.fsListType || type == this.neFsListType || type == this.eFsListType;
    }

    public boolean isListType(int type) {
        return this.isIntListType(type) || this.isFloatListType(type) || this.isStringListType(type) || this.isFsListType(type);
    }

    public int getLength(int type, int addr) {
        int neListType = -1;
        int tailFeat = -1;
        if (this.isIntListType(type)) {
            neListType = this.neIntListType;
            tailFeat = this.intTailFeat;
        } else if (this.isFloatListType(type)) {
            neListType = this.neFloatListType;
            tailFeat = this.floatTailFeat;
        } else if (this.isStringListType(type)) {
            neListType = this.neStringListType;
            tailFeat = this.stringTailFeat;
        } else if (this.isFsListType(type)) {
            neListType = this.neFsListType;
            tailFeat = this.fsTailFeat;
        }
        IntRedBlackTree visited = new IntRedBlackTree();
        boolean foundCycle = false;
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == neListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(tailFeat));
        }
        return length;
    }

    public String[] intListToStringArray(int addr) throws SAXException {
        IntRedBlackTree visited = new IntRedBlackTree();
        boolean foundCycle = false;
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neIntListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
        }
        String[] array = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = Integer.toString(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intHeadFeat)));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an IntegerList.  List truncated to " + Arrays.asList(array).toString());
        }
        return array;
    }

    public String[] floatListToStringArray(int addr) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neFloatListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
        }
        String[] array = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = Float.toString(CASImpl.int2float(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatHeadFeat))));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in a FloatList.  List truncated to " + Arrays.asList(array).toString() + ".");
        }
        return array;
    }

    public String[] stringListToStringArray(int addr) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neStringListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
        }
        String[] array = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = this.cas.getStringForCode(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringHeadFeat)));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in a StringList.  List truncated to " + Arrays.asList(array).toString() + ".");
        }
        return array;
    }

    public String[] fsListToXmiIdStringArray(int addr, XmiSerializationSharedData sharedData) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neFsListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        String[] strArray = new String[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            int heapVal = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsHeadFeat));
            if (heapVal == 0) {
                XmiSerializationSharedData.OotsElementData oed;
                strArray[i] = "0";
                if (sharedData != null && (oed = sharedData.getOutOfTypeSystemFeatures(curNode)) != null) {
                    assert (oed.attributes.size() == 1);
                    XmlAttribute attr = oed.attributes.get(0);
                    assert ("head".equals(attr.name));
                    strArray[i] = attr.value;
                }
            } else {
                strArray[i] = sharedData != null ? (heapVal == 0 ? null : sharedData.getXmiId(heapVal)) : Integer.toString(heapVal);
            }
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an FSList.  List truncated to " + Arrays.asList(strArray).toString() + ".");
        }
        return strArray;
    }

    public int[] fsListToAddressArray(int addr) throws SAXException {
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == this.neFsListType) {
            if (!visited.put(curNode, curNode)) {
                foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        int[] array = new int[length];
        curNode = addr;
        for (int i = 0; i < length; ++i) {
            array[i] = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsHeadFeat));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an FSList.  List truncated where cycle occurs.");
        }
        return array;
    }

    public int createIntList(List<String> stringValues) {
        int first = this.cas.ll_createFS(this.eIntListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            int value = Integer.parseInt(iter.previous());
            int node = this.cas.ll_createFS(this.neIntListType);
            this.cas.setFeatureValue(node, this.intHeadFeat, value);
            this.cas.setFeatureValue(node, this.intTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createFloatList(List<String> stringValues) {
        int first = this.cas.ll_createFS(this.eFloatListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            float value = Float.parseFloat(iter.previous());
            int node = this.cas.ll_createFS(this.neFloatListType);
            this.cas.setFeatureValue(node, this.floatHeadFeat, CASImpl.float2int(value));
            this.cas.setFeatureValue(node, this.floatTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createStringList(List<String> stringValues) {
        int first = this.cas.ll_createFS(this.eStringListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            String value = iter.previous();
            int node = this.cas.ll_createFS(this.neStringListType);
            this.cas.setFeatureValue(node, this.stringHeadFeat, this.cas.addString(value));
            this.cas.setFeatureValue(node, this.stringTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createFsList(List<String> stringValues, IntVector fsAddresses) {
        int first = this.cas.ll_createFS(this.eFsListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            int value = Integer.parseInt(iter.previous());
            int node = this.cas.ll_createFS(this.neFsListType);
            fsAddresses.add(node);
            this.cas.setFeatureValue(node, this.fsHeadFeat, value);
            this.cas.setFeatureValue(node, this.fsTailFeat, first);
            first = node;
        }
        return first;
    }

    public int updateIntList(int addr, List<String> stringValues) throws SAXException {
        int first = addr;
        int currLength = this.getLength(this.neIntListType, addr);
        int curNode = addr;
        int prevNode = 0;
        IntRedBlackTree visited = new IntRedBlackTree();
        boolean foundCycle = false;
        int i = 0;
        if (currLength < stringValues.size()) {
            while (this.cas.getHeapValue(curNode) == this.neIntListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                int value = Integer.parseInt(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.floatHeadFeat, value);
                prevNode = curNode;
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
            }
            if (i < stringValues.size()) {
                int emptyListFs = curNode;
                while (i < stringValues.size()) {
                    int newNode = this.cas.ll_createFS(this.neIntListType);
                    int value = Integer.parseInt(stringValues.get(i++));
                    this.cas.setFeatureValue(newNode, this.intHeadFeat, value);
                    this.cas.setFeatureValue(newNode, this.intTailFeat, emptyListFs);
                    this.cas.setFeatureValue(prevNode, this.intTailFeat, newNode);
                    prevNode = newNode;
                }
            }
        } else if (currLength > stringValues.size()) {
            while (this.cas.getHeapValue(curNode) == this.neIntListType && i < stringValues.size()) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                float value = Integer.parseInt(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.intHeadFeat, value);
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
            }
            int finalNode = curNode;
            while (this.cas.getHeapValue(curNode) == this.neIntListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
            }
            this.cas.setFeatureValue(finalNode, this.intTailFeat, curNode);
        } else {
            while (this.cas.getHeapValue(curNode) == this.neIntListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                int value = Integer.parseInt(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.intHeadFeat, value);
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.intTailFeat));
            }
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an IntegerList.  List truncated to " + i);
        }
        return first;
    }

    public int updateFloatList(int addr, List<String> stringValues) throws SAXException {
        int first = addr;
        int currLength = this.getLength(this.neFloatListType, addr);
        int curNode = addr;
        int prevNode = 0;
        IntRedBlackTree visited = new IntRedBlackTree();
        boolean foundCycle = false;
        int i = 0;
        if (currLength < stringValues.size()) {
            while (this.cas.getHeapValue(curNode) == this.neFloatListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                float value = Float.parseFloat(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.floatHeadFeat, value);
                prevNode = curNode;
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
            }
            if (i < stringValues.size()) {
                int emptyListFs = curNode;
                while (i < stringValues.size()) {
                    int newNode = this.cas.ll_createFS(this.neFloatListType);
                    float value = Float.parseFloat(stringValues.get(i++));
                    this.cas.setFeatureValue(newNode, this.floatHeadFeat, value);
                    this.cas.setFeatureValue(newNode, this.floatTailFeat, emptyListFs);
                    this.cas.setFeatureValue(prevNode, this.floatTailFeat, newNode);
                    prevNode = newNode;
                }
            }
        } else if (currLength > stringValues.size()) {
            while (this.cas.getHeapValue(curNode) == this.neFloatListType && i < stringValues.size()) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                float value = Float.parseFloat(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.floatHeadFeat, value);
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
            }
            int finalNode = curNode;
            while (this.cas.getHeapValue(curNode) == this.neFloatListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
            }
            this.cas.setFeatureValue(finalNode, this.floatTailFeat, curNode);
        } else {
            while (this.cas.getHeapValue(curNode) == this.neFloatListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                float value = Float.parseFloat(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.floatHeadFeat, CASImpl.float2int(value));
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.floatTailFeat));
            }
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an IntegerList.  List truncated to " + i);
        }
        return first;
    }

    public int updateFsList(int addr, List<String> stringValues, IntVector fsAddresses) throws SAXException {
        int first = addr;
        int currLength = this.getLength(this.neFsListType, addr);
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int curNode = addr;
        int prevNode = 0;
        int i = 0;
        if (currLength < stringValues.size()) {
            while (this.cas.getHeapValue(curNode) == this.neFsListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                int value = Integer.parseInt(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.fsHeadFeat, value);
                fsAddresses.add(curNode);
                prevNode = curNode;
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
            }
            if (i < stringValues.size()) {
                int emptyListFs = curNode;
                while (i < stringValues.size()) {
                    int newNode = this.cas.ll_createFS(this.neFsListType);
                    int value = Integer.parseInt(stringValues.get(i++));
                    this.cas.setFeatureValue(newNode, this.fsHeadFeat, value);
                    fsAddresses.add(newNode);
                    this.cas.setFeatureValue(newNode, this.fsTailFeat, emptyListFs);
                    this.cas.setFeatureValue(prevNode, this.fsTailFeat, newNode);
                    prevNode = newNode;
                }
            }
        } else if (currLength > stringValues.size()) {
            while (this.cas.getHeapValue(curNode) == this.neFsListType && i < stringValues.size()) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                int value = Integer.parseInt(stringValues.get(i++));
                fsAddresses.add(curNode);
                this.cas.setFeatureValue(curNode, this.fsHeadFeat, value);
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
            }
            int finalNode = curNode;
            while (this.cas.getHeapValue(curNode) == this.neFsListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
            }
            this.cas.setFeatureValue(finalNode, this.fsTailFeat, curNode);
        } else {
            while (this.cas.getHeapValue(curNode) == this.neFsListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                int value = Integer.parseInt(stringValues.get(i++));
                this.cas.setFeatureValue(curNode, this.fsHeadFeat, value);
                fsAddresses.add(curNode);
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
            }
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an IntegerList.  List truncated to " + i);
        }
        return first;
    }

    public int updateStringList(int addr, List<String> stringValues) throws SAXException {
        int first = addr;
        boolean foundCycle = false;
        IntRedBlackTree visited = new IntRedBlackTree();
        int curNode = addr;
        int prevNode = 0;
        int currLength = this.getLength(this.neStringListType, addr);
        if (currLength < stringValues.size()) {
            int i = 0;
            while (this.cas.getHeapValue(curNode) == this.neStringListType) {
                String newValue;
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                String curValue = this.cas.getStringForCode(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringHeadFeat)));
                if (!curValue.equals(newValue = stringValues.get(i++))) {
                    this.cas.setFeatureValue(curNode, this.stringHeadFeat, this.cas.addString(newValue));
                }
                prevNode = curNode;
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
            }
            if (i < stringValues.size()) {
                int emptyListFs = curNode;
                while (i < stringValues.size()) {
                    int newNode = this.cas.ll_createFS(this.neStringListType);
                    String value = stringValues.get(i++);
                    this.cas.setFeatureValue(newNode, this.stringHeadFeat, this.cas.addString(value));
                    this.cas.setFeatureValue(newNode, this.stringTailFeat, emptyListFs);
                    this.cas.setFeatureValue(prevNode, this.stringTailFeat, newNode);
                    prevNode = newNode;
                }
            }
        } else if (currLength > stringValues.size()) {
            int i = 0;
            while (this.cas.getHeapValue(curNode) == this.neStringListType && i < stringValues.size()) {
                String newValue;
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                String curValue = this.cas.getStringForCode(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringHeadFeat)));
                if (!curValue.equals(newValue = stringValues.get(i++))) {
                    this.cas.setFeatureValue(curNode, this.stringHeadFeat, this.cas.addString(newValue));
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
            }
            int finalNode = curNode;
            while (this.cas.getHeapValue(curNode) == this.neStringListType) {
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
            }
            this.cas.setFeatureValue(finalNode, this.stringTailFeat, curNode);
        } else {
            int i = 0;
            while (this.cas.getHeapValue(curNode) == this.neStringListType) {
                String newValue;
                if (!visited.put(curNode, curNode)) {
                    foundCycle = true;
                    break;
                }
                String curValue = this.cas.getStringForCode(this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringHeadFeat)));
                if (!curValue.equals(newValue = stringValues.get(i++))) {
                    this.cas.setFeatureValue(curNode, this.stringHeadFeat, this.cas.addString(newValue));
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.stringTailFeat));
            }
        }
        if (foundCycle) {
            this.reportWarning("Found a cycle in an IntegerList.  List truncated. ");
        }
        return first;
    }

    private void reportWarning(String message) throws SAXException {
        if (this.logger != null) {
            this.logger.log(Level.WARNING, message);
        }
        if (this.eh != null) {
            this.eh.warning(new SAXParseException(message, null));
        }
    }
}

