/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.noggit.JSONWriter;

public class HashPartitioner {
    public Range fromString(String range) {
        int middle = range.indexOf(45);
        String minS = range.substring(0, middle);
        String maxS = range.substring(middle + 1);
        long min = Long.parseLong(minS, 16);
        long max = Long.parseLong(maxS, 16);
        return new Range((int)min, (int)max);
    }

    public Range fullRange() {
        return new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public List<Range> partitionRange(int partitions, Range range) {
        return this.partitionRange(partitions, range.min, range.max);
    }

    public List<Range> partitionRange(int partitions, int min, int max) {
        long start;
        assert (max >= min);
        if (partitions == 0) {
            return Collections.EMPTY_LIST;
        }
        long range = (long)max - (long)min;
        long srange = Math.max(1L, range / (long)partitions);
        ArrayList<Range> ranges = new ArrayList<Range>(partitions);
        long end = start = (long)min;
        while (end < (long)max) {
            end = start + srange;
            if (ranges.size() == partitions - 1) {
                end = max;
            }
            ranges.add(new Range((int)start, (int)end));
            start = end + 1L;
        }
        return ranges;
    }

    public static class Range
    implements JSONWriter.Writable {
        public int min;
        public int max;

        public Range(int min, int max) {
            assert (min <= max);
            this.min = min;
            this.max = max;
        }

        public boolean includes(int hash) {
            return hash >= this.min && hash <= this.max;
        }

        public String toString() {
            return Integer.toHexString(this.min) + '-' + Integer.toHexString(this.max);
        }

        public int hashCode() {
            return (this.min >> 28) + (this.min >> 25) + (this.min >> 21) + this.min;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            return this.min == other.min && this.max == other.max;
        }

        @Override
        public void write(JSONWriter writer) {
            writer.write(this.toString());
        }
    }
}

