/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;

public abstract class BaseFragListBuilder
implements FragListBuilder {
    public static final int MARGIN_DEFAULT = 6;
    public static final int MIN_FRAG_CHAR_SIZE_FACTOR = 3;
    final int margin;
    final int minFragCharSize;

    public BaseFragListBuilder(int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("margin(" + margin + ") is too small. It must be 0 or higher.");
        }
        this.margin = margin;
        this.minFragCharSize = Math.max(1, margin * 3);
    }

    public BaseFragListBuilder() {
        this(6);
    }

    protected FieldFragList createFieldFragList(FieldPhraseList fieldPhraseList, FieldFragList fieldFragList, int fragCharSize) {
        if (fragCharSize < this.minFragCharSize) {
            throw new IllegalArgumentException("fragCharSize(" + fragCharSize + ") is too small. It must be " + this.minFragCharSize + " or higher.");
        }
        ArrayList<FieldPhraseList.WeightedPhraseInfo> wpil = new ArrayList<FieldPhraseList.WeightedPhraseInfo>();
        Iterator<FieldPhraseList.WeightedPhraseInfo> ite = fieldPhraseList.getPhraseList().iterator();
        FieldPhraseList.WeightedPhraseInfo phraseInfo = null;
        int startOffset = 0;
        boolean taken = false;
        while (true) {
            int matchLen;
            int newMargin;
            if (!taken) {
                if (!ite.hasNext()) break;
                phraseInfo = ite.next();
            }
            taken = false;
            if (phraseInfo == null) break;
            if (phraseInfo.getStartOffset() < startOffset) continue;
            wpil.clear();
            wpil.add(phraseInfo);
            int firstOffset = phraseInfo.getStartOffset();
            int st = phraseInfo.getStartOffset() - this.margin < startOffset ? startOffset : phraseInfo.getStartOffset() - this.margin;
            int en = st + fragCharSize;
            if (phraseInfo.getEndOffset() > en) {
                en = phraseInfo.getEndOffset();
            }
            int lastEndOffset = phraseInfo.getEndOffset();
            while (ite.hasNext()) {
                phraseInfo = ite.next();
                taken = true;
                if (phraseInfo == null || phraseInfo.getEndOffset() > en) break;
                wpil.add(phraseInfo);
                lastEndOffset = phraseInfo.getEndOffset();
            }
            if ((st = firstOffset - (newMargin = (fragCharSize - (matchLen = lastEndOffset - firstOffset)) / 2)) < startOffset) {
                st = startOffset;
            }
            startOffset = en = st + fragCharSize;
            fieldFragList.add(st, en, wpil);
        }
        return fieldFragList;
    }
}

