/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.valuetype.plugin;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.robot.dbflute.Entity;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.GreatWallOfOracleType;
import org.seasar.robot.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OracleStructType
extends GreatWallOfOracleType {
    public OracleStructType(String structTypeName, Class<?> entityType) {
        super(2002, structTypeName, entityType);
        if (this._mainEntityPrototype == null) {
            String msg = "The entityType should be an instance of Entity: " + entityType;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    protected String getTitleName() {
        return "Struct";
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return this.toPropertyValue(rs.getObject(index));
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return this.toPropertyValue(rs.getObject(columnName));
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toPropertyValue(cs.getObject(index));
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toPropertyValue(cs.getObject(parameterName));
    }

    protected Entity toPropertyValue(Object oracleStruct) throws SQLException {
        return this.mappingOracleStructToEntity(oracleStruct, this._mainEntityPrototype);
    }

    @Override
    protected Object toBindValue(Connection conn, Object paramExp, Object value) throws SQLException {
        this.assertStructPropertyValueNotEntity(paramExp, value);
        return this.mappingEntityToOracleStruct(conn, paramExp, (Entity)value);
    }

    protected void assertStructPropertyValueNotEntity(Object paramExp, Object value) {
        if (!(value instanceof Entity)) {
            this.throwStructPropertyValueNotEntityException(paramExp, value);
        }
    }

    protected void throwStructPropertyValueNotEntityException(Object paramExp, Object value) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The property value for struct should be entity type.");
        br.addItem("Struct");
        br.addElement(this._mainTypeName);
        br.addItem("Entity");
        br.addElement(DfTypeUtil.toClassTitle(this._mainObjectType));
        br.addItem("Parameter");
        br.addElement(paramExp);
        br.addItem("Property Value");
        if (value != null) {
            br.addElement(value.getClass());
        }
        br.addElement(value);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }
}

