/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.sqlclause.query;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.robot.dbflute.util.Srl;

public interface QueryClauseFilter {
    public static final String BIND_COMMENT_BEGIN_PART = "/*pmb";
    public static final String BIND_COMMENT_END_PART = "*/null";
    public static final String EMBEDDED_COMMENT_BEGIN_PART = "/*$pmb";
    public static final String EMBEDDED_COMMENT_END_PART = "*/null";
    public static final String EMBEDDED_COMMENT_QUOTED_END_PART = "*/'dummy'";

    public String filterClauseElement(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryClauseToEmbeddedQuotedSimpleFilter
    extends QueryClauseToEmbeddedSimpleFilter {
        private static final long serialVersionUID = 1L;

        public QueryClauseToEmbeddedQuotedSimpleFilter(ColumnInfo filterTargetColumnInfo) {
            super(filterTargetColumnInfo);
        }

        public QueryClauseToEmbeddedQuotedSimpleFilter(Set<ColumnInfo> filterTargetColumnInfoSet) {
            super(filterTargetColumnInfoSet);
        }

        @Override
        protected String toEmbedded(String clauseElement) {
            clauseElement = this.replace(clauseElement, QueryClauseFilter.BIND_COMMENT_BEGIN_PART, QueryClauseFilter.EMBEDDED_COMMENT_BEGIN_PART);
            clauseElement = this.replace(clauseElement, "*/null", QueryClauseFilter.EMBEDDED_COMMENT_QUOTED_END_PART);
            return clauseElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryClauseToEmbeddedSimpleFilter
    implements QueryClauseFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final Set<ColumnInfo> _filterTargetColumnInfoSet;

        public QueryClauseToEmbeddedSimpleFilter(ColumnInfo filterTargetColumnInfo) {
            this._filterTargetColumnInfoSet = new HashSet<ColumnInfo>();
            this._filterTargetColumnInfoSet.add(filterTargetColumnInfo);
        }

        public QueryClauseToEmbeddedSimpleFilter(Set<ColumnInfo> filterTargetColumnInfoSet) {
            this._filterTargetColumnInfoSet = filterTargetColumnInfoSet;
        }

        @Override
        public String filterClauseElement(String clauseElement) {
            if (this._filterTargetColumnInfoSet == null || this._filterTargetColumnInfoSet.isEmpty()) {
                return this.toEmbedded(clauseElement);
            }
            for (ColumnInfo columnInfo : this._filterTargetColumnInfoSet) {
                if (!this.isTargetClause(clauseElement, columnInfo.getColumnSqlName())) continue;
                return this.toEmbedded(clauseElement);
            }
            return clauseElement;
        }

        protected boolean isTargetClause(String clauseElement, ColumnSqlName columnSqlName) {
            return clauseElement.indexOf("." + columnSqlName + " ") >= 0;
        }

        protected String toEmbedded(String clauseElement) {
            clauseElement = this.replace(clauseElement, QueryClauseFilter.BIND_COMMENT_BEGIN_PART, QueryClauseFilter.EMBEDDED_COMMENT_BEGIN_PART);
            clauseElement = this.replace(clauseElement, "*/null", "*/null");
            return clauseElement;
        }

        protected final String replace(String str, String fromStr, String toStr) {
            return Srl.replace(str, fromStr, toStr);
        }
    }
}

