/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.cbean.ConditionQuery;
import org.seasar.robot.dbflute.cbean.SimpleMapPmb;
import org.seasar.robot.dbflute.cbean.chelper.HpDerivingSubQueryInfo;
import org.seasar.robot.dbflute.cbean.chelper.HpFixedConditionQueryResolver;
import org.seasar.robot.dbflute.cbean.chelper.HpInvalidQueryInfo;
import org.seasar.robot.dbflute.cbean.ckey.ConditionKey;
import org.seasar.robot.dbflute.cbean.ckey.ConditionKeyInScope;
import org.seasar.robot.dbflute.cbean.coption.ConditionOption;
import org.seasar.robot.dbflute.cbean.coption.DerivedReferrerOption;
import org.seasar.robot.dbflute.cbean.coption.FromToOption;
import org.seasar.robot.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.robot.dbflute.cbean.coption.ParameterOption;
import org.seasar.robot.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.seasar.robot.dbflute.cbean.sqlclause.join.FixedConditionResolver;
import org.seasar.robot.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.robot.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.ExistsReferrer;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.InScopeRelation;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.QueryDerivedReferrer;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.ScalarCondition;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.SpecifyDerivedReferrer;
import org.seasar.robot.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.robot.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.robot.dbflute.dbway.ExtensionOperand;
import org.seasar.robot.dbflute.dbway.WayOfMySQL;
import org.seasar.robot.dbflute.exception.ConditionInvokingFailureException;
import org.seasar.robot.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.robot.dbflute.exception.OrScopeQueryAndPartUnsupportedOperationException;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.robot.dbflute.jdbc.Classification;
import org.seasar.robot.dbflute.jdbc.ParameterUtil;
import org.seasar.robot.dbflute.util.DfCollectionUtil;
import org.seasar.robot.dbflute.util.DfReflectionUtil;
import org.seasar.robot.dbflute.util.DfSystemUtil;
import org.seasar.robot.dbflute.util.DfTypeUtil;
import org.seasar.robot.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionQuery
implements ConditionQuery {
    protected static final ConditionKey CK_EQ = ConditionKey.CK_EQUAL;
    protected static final ConditionKey CK_NES = ConditionKey.CK_NOT_EQUAL_STANDARD;
    protected static final ConditionKey CK_NET = ConditionKey.CK_NOT_EQUAL_TRADITION;
    protected static final ConditionKey CK_GT = ConditionKey.CK_GREATER_THAN;
    protected static final ConditionKey CK_LT = ConditionKey.CK_LESS_THAN;
    protected static final ConditionKey CK_GE = ConditionKey.CK_GREATER_EQUAL;
    protected static final ConditionKey CK_LE = ConditionKey.CK_LESS_EQUAL;
    protected static final ConditionKey CK_INS = ConditionKey.CK_IN_SCOPE;
    protected static final ConditionKey CK_NINS = ConditionKey.CK_NOT_IN_SCOPE;
    protected static final ConditionKey CK_LS = ConditionKey.CK_LIKE_SEARCH;
    protected static final ConditionKey CK_NLS = ConditionKey.CK_NOT_LIKE_SEARCH;
    protected static final ConditionKey CK_ISN = ConditionKey.CK_IS_NULL;
    protected static final ConditionKey CK_ISNN = ConditionKey.CK_IS_NOT_NULL;
    protected static final Object DOBJ = new Object();
    protected static final String CQ_PROPERTY = "conditionQuery";
    protected final SqlClause _sqlClause;
    protected final String _aliasName;
    protected final int _nestLevel;
    protected int _subQueryLevel;
    protected String _foreignPropertyName;
    protected String _relationPath;
    protected final ConditionQuery _referrerQuery;
    protected boolean _inline;
    protected boolean _onClause;
    protected Map<String, ParameterOption> _parameterOptionMap;
    protected SimpleMapPmb<ConditionQuery> _unionQueryMap;
    protected SimpleMapPmb<ConditionQuery> _unionAllQueryMap;

    public AbstractConditionQuery(ConditionQuery referrerQuery, SqlClause sqlClause, String aliasName, int nestLevel) {
        this._referrerQuery = referrerQuery;
        this._sqlClause = sqlClause;
        this._aliasName = aliasName;
        this._nestLevel = nestLevel;
    }

    protected abstract DBMetaProvider xgetDBMetaProvider();

    protected DBMeta findDBMeta(String tableFlexibleName) {
        return this.xgetDBMetaProvider().provideDBMetaChecked(tableFlexibleName);
    }

    @Override
    public ConditionQuery xgetReferrerQuery() {
        return this._referrerQuery;
    }

    @Override
    public SqlClause xgetSqlClause() {
        return this._sqlClause;
    }

    @Override
    public String xgetAliasName() {
        return this._aliasName;
    }

    @Override
    public int xgetNestLevel() {
        return this._nestLevel;
    }

    @Override
    public int xgetNextNestLevel() {
        return this._nestLevel + 1;
    }

    @Override
    public boolean isBaseQuery() {
        return this.xgetReferrerQuery() == null;
    }

    @Override
    public ColumnRealName toColumnRealName(String columnDbName) {
        return new ColumnRealName(this.xgetAliasName(), this.toColumnSqlName(columnDbName));
    }

    @Override
    public ColumnSqlName toColumnSqlName(String columnDbName) {
        return this.findDBMeta(this.getTableDbName()).findColumnInfo(columnDbName).getColumnSqlName();
    }

    @Override
    public String xgetForeignPropertyName() {
        return this._foreignPropertyName;
    }

    public void xsetForeignPropertyName(String foreignPropertyName) {
        this._foreignPropertyName = foreignPropertyName;
    }

    @Override
    public String xgetRelationPath() {
        return this._relationPath;
    }

    public void xsetRelationPath(String relationPath) {
        this._relationPath = relationPath;
    }

    public void xsetOnClause(boolean onClause) {
        this._onClause = onClause;
    }

    @Override
    public String xgetLocationBase() {
        StringBuilder sb = new StringBuilder();
        ConditionQuery query = this;
        while (true) {
            if (query.isBaseQuery()) break;
            String foreignPropertyName = query.xgetForeignPropertyName();
            if (foreignPropertyName == null) {
                String msg = "The foreignPropertyName of the query should not be null:";
                msg = msg + " query=" + query;
                throw new IllegalStateException(msg);
            }
            sb.insert(0, CQ_PROPERTY + this.initCap(foreignPropertyName) + ".");
            query = query.xgetReferrerQuery();
        }
        sb.insert(0, "conditionQuery.");
        return sb.toString();
    }

    protected String xgetLocation(String propertyName) {
        return this.xgetLocationBase() + propertyName;
    }

    public void doNss(NssCall callback) {
        String foreignPropertyName = callback.qf().xgetForeignPropertyName();
        String foreignTableAliasName = callback.qf().xgetAliasName();
        String localRelationPath = this.xgetRelationPath();
        String foreignRelationPath = callback.qf().xgetRelationPath();
        this.xgetSqlClause().registerSelectedRelation(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, localRelationPath, foreignRelationPath);
    }

    protected void registerOuterJoin(ConditionQuery foreignCQ, Map<String, String> joinOnResourceMap) {
        this.registerOuterJoin(foreignCQ, joinOnResourceMap, null);
    }

    protected void registerOuterJoin(ConditionQuery foreignCQ, Map<String, String> joinOnResourceMap, String fixedCondition) {
        LinkedHashMap<ColumnRealName, ColumnRealName> joinOnMap = this.newLinkedHashMap();
        Set<Map.Entry<String, String>> entrySet = joinOnResourceMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String local = entry.getKey();
            String foreign = entry.getValue();
            joinOnMap.put(this.toColumnRealName(local), foreignCQ.toColumnRealName(foreign));
        }
        String localTable = this.getTableDbName();
        String foreignTable = foreignCQ.getTableDbName();
        String foreignAlias = foreignCQ.xgetAliasName();
        FixedConditionResolver resolver = this.createFixedConditionResolver(foreignCQ, joinOnMap);
        this.xgetSqlClause().registerOuterJoin(localTable, foreignTable, foreignAlias, joinOnMap, fixedCondition, resolver);
    }

    protected FixedConditionResolver createFixedConditionResolver(ConditionQuery foreignCQ, Map<ColumnRealName, ColumnRealName> joinOnMap) {
        return new HpFixedConditionQueryResolver(this, foreignCQ, this.xgetDBMetaProvider());
    }

    public SimpleMapPmb<ConditionQuery> getInternalUnionQueryMap() {
        if (this._unionQueryMap == null) {
            this._unionQueryMap = this.xcreateUnionMapPmb();
        }
        return this._unionQueryMap;
    }

    public void xsetUnionQuery(ConditionQuery unionQuery) {
        this.xsetupUnion(unionQuery, false, this.getInternalUnionQueryMap());
    }

    public SimpleMapPmb<ConditionQuery> getInternalUnionAllQueryMap() {
        if (this._unionAllQueryMap == null) {
            this._unionAllQueryMap = this.xcreateUnionMapPmb();
        }
        return this._unionAllQueryMap;
    }

    protected SimpleMapPmb<ConditionQuery> xcreateUnionMapPmb() {
        return new SimpleMapPmb<ConditionQuery>();
    }

    public void xsetUnionAllQuery(ConditionQuery unionAllQuery) {
        this.xsetupUnion(unionAllQuery, true, this.getInternalUnionAllQueryMap());
    }

    protected void xsetupUnion(ConditionQuery unionQuery, boolean unionAll, SimpleMapPmb<ConditionQuery> unionQueryMap) {
        if (unionQuery == null) {
            String msg = "The argument[unionQuery] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.reflectRelationOnUnionQuery(this, unionQuery);
        String key = (unionAll ? "unionAllQuery" : "unionQuery") + unionQueryMap.size();
        unionQueryMap.addParameter(key, unionQuery);
        String propName = "internalUnion" + (unionAll ? "All" : "") + "QueryMap." + key;
        this.registerUnionQuery(unionQuery, unionAll, propName);
    }

    protected abstract void reflectRelationOnUnionQuery(ConditionQuery var1, ConditionQuery var2);

    public boolean hasUnionQueryOrUnionAllQuery() {
        return this._unionQueryMap != null && !this._unionQueryMap.isEmpty() || this._unionAllQueryMap != null && !this._unionAllQueryMap.isEmpty();
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName);
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, option);
    }

    protected boolean isValidQuery(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        ColumnRealName callerName = this.toColumnRealName(columnDbName);
        if (key.isValidRegistration(this.xcreateQueryModeProvider(), cvalue, value, callerName)) {
            return true;
        }
        HpInvalidQueryInfo invalidQueryInfo = this.xcreateInvalidQueryInfo(key, value, columnDbName);
        if (this.xgetSqlClause().isInvalidQueryChecked()) {
            this.throwInvalidQueryRegisteredException(invalidQueryInfo);
            return false;
        }
        this.xgetSqlClause().saveInvalidQuery(invalidQueryInfo);
        return false;
    }

    protected HpInvalidQueryInfo xcreateInvalidQueryInfo(ConditionKey key, Object value, String columnDbName) {
        String locationBase = this.xgetLocationBase();
        ColumnInfo targetColumn = this.findDBMeta(this.getTableDbName()).findColumnInfo(columnDbName);
        HpInvalidQueryInfo invalidQueryInfo = new HpInvalidQueryInfo(locationBase, targetColumn, key, value);
        if (this._inline) {
            invalidQueryInfo.inlineView();
        } else if (this._onClause) {
            invalidQueryInfo.onClause();
        }
        return invalidQueryInfo;
    }

    protected ConditionValue.QueryModeProvider xcreateQueryModeProvider() {
        return new ConditionValue.QueryModeProvider(){

            public boolean isOrScopeQuery() {
                return AbstractConditionQuery.this.xgetSqlClause().isOrScopeQueryEffective();
            }

            public boolean isInline() {
                return AbstractConditionQuery.this._inline;
            }

            public boolean isOnClause() {
                return AbstractConditionQuery.this._onClause;
            }
        };
    }

    protected void throwInvalidQueryRegisteredException(HpInvalidQueryInfo invalidQueryInfo) {
        this.createCBExThrower().throwInvalidQueryRegisteredException(invalidQueryInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regINS(ConditionKey key, List<?> value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        int inScopeLimit = this.xgetSqlClause().getInScopeLimit();
        if (inScopeLimit > 0 && value.size() > inScopeLimit) {
            boolean needsAndPart;
            boolean orScopeQuery = this.xgetSqlClause().isOrScopeQueryEffective();
            boolean orScopeQueryAndPart = this.xgetSqlClause().isOrScopeQueryAndPartEffective();
            boolean bl = needsAndPart = orScopeQuery && !orScopeQueryAndPart;
            if (AbstractConditionQuery.isConditionKeyInScope(key)) {
                this.xgetSqlClause().makeOrScopeQueryEffective();
            } else if (needsAndPart) {
                this.xgetSqlClause().beginOrScopeQueryAndPart();
            }
            try {
                List<?> objectList = value;
                List<List<?>> valueList = DfCollectionUtil.splitByLimit(objectList, inScopeLimit);
                for (int i = 0; i < valueList.size(); ++i) {
                    List<?> currentValue = valueList.get(i);
                    if (i == 0) {
                        this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName);
                        continue;
                    }
                    this.invokeQuery(columnDbName, key.getConditionKey(), currentValue);
                }
            }
            finally {
                if (AbstractConditionQuery.isConditionKeyInScope(key)) {
                    this.xgetSqlClause().closeOrScopeQuery();
                } else if (needsAndPart) {
                    this.xgetSqlClause().endOrScopeQueryAndPart();
                }
            }
        } else {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName);
        }
    }

    static boolean isConditionKeyInScope(ConditionKey key) {
        return ConditionKeyInScope.class.isAssignableFrom(key.getClass());
    }

    protected void regFTQ(Date fromDate, Date toDate, ConditionValue cvalue, String columnDbName, FromToOption option) {
        Date filteredToDate;
        ConditionKey toKey;
        Date filteredFromDate;
        ConditionKey fromKey = option.getFromDateConditionKey();
        if (this.isValidQuery(fromKey, filteredFromDate = option.filterFromDate(fromDate), cvalue, columnDbName)) {
            this.setupConditionValueAndRegisterWhereClause(fromKey, filteredFromDate, cvalue, columnDbName);
        }
        if (this.isValidQuery(toKey = option.getToDateConditionKey(), filteredToDate = option.filterToDate(toDate), cvalue, columnDbName)) {
            this.setupConditionValueAndRegisterWhereClause(toKey, filteredToDate, cvalue, columnDbName);
        }
    }

    protected void regLSQ(ConditionKey key, String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        this.registerLikeSearchQuery(key, value, cvalue, columnDbName, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerLikeSearchQuery(ConditionKey key, String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        boolean needsNewOrScope;
        if (option == null) {
            this.throwLikeSearchOptionNotFoundException(columnDbName, value);
            return;
        }
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        if (this.xsuppressEscape()) {
            option.notEscape();
        }
        if (value == null || !option.isSplit()) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, option);
            return;
        }
        String[] strArray = option.generateSplitValueArray(value);
        boolean orScopeQuery = this.xgetSqlClause().isOrScopeQueryEffective();
        boolean orScopeQueryAndPart = this.xgetSqlClause().isOrScopeQueryAndPartEffective();
        if (!option.isAsOrSplit()) {
            boolean needsAndPart;
            boolean bl = needsAndPart = orScopeQuery && !orScopeQueryAndPart;
            if (needsAndPart) {
                this.xgetSqlClause().beginOrScopeQueryAndPart();
            }
            try {
                for (int i = 0; i < strArray.length; ++i) {
                    String currentValue = strArray[i];
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName, option);
                }
            }
            finally {
                if (needsAndPart) {
                    this.xgetSqlClause().endOrScopeQueryAndPart();
                }
            }
        }
        if (orScopeQueryAndPart) {
            String msg = "The AsOrSplit in and-part is unsupported: " + this.getTableDbName();
            throw new OrScopeQueryAndPartUnsupportedOperationException(msg);
        }
        boolean bl = needsNewOrScope = !orScopeQuery;
        if (needsNewOrScope) {
            this.xgetSqlClause().makeOrScopeQueryEffective();
        }
        try {
            for (int i = 0; i < strArray.length; ++i) {
                String currentValue = strArray[i];
                if (i == 0) {
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName, option);
                    continue;
                }
                this.invokeQueryLikeSearch(columnDbName, currentValue, option);
            }
        }
        finally {
            if (needsNewOrScope) {
                this.xgetSqlClause().closeOrScopeQuery();
            }
        }
    }

    protected boolean xsuppressEscape() {
        return false;
    }

    protected void throwLikeSearchOptionNotFoundException(String columnDbName, String value) {
        DBMeta dbmeta = this.xgetDBMetaProvider().provideDBMeta(this.getTableDbName());
        this.createCBExThrower().throwLikeSearchOptionNotFoundException(columnDbName, value, dbmeta);
    }

    protected void invokeQueryLikeSearch(String columnFlexibleName, Object value, LikeSearchOption option) {
        this.invokeQuery(columnFlexibleName, "likeSearch", value, option);
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        DBMeta dbmeta = this.xgetDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        key.setupConditionValue(this.xcreateQueryModeProvider(), cvalue, value, this.xgetLocation(uncapPropName));
        ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
        if (this.isBaseQuery()) {
            this.xgetSqlClause().registerBaseTableInlineWhereClause(columnSqlName, key, cvalue);
        } else {
            String aliasName = this.xgetAliasName();
            this.xgetSqlClause().registerOuterJoinInlineWhereClause(aliasName, columnSqlName, key, cvalue, this._onClause);
        }
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        if (!this.isValidQuery(key, value, cvalue, columnDbName)) {
            return;
        }
        DBMeta dbmeta = this.xgetDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        String location = this.xgetLocation(uncapPropName);
        key.setupConditionValue(this.xcreateQueryModeProvider(), cvalue, value, location, option);
        ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
        if (this.isBaseQuery()) {
            this.xgetSqlClause().registerBaseTableInlineWhereClause(columnSqlName, key, cvalue, option);
        } else {
            String aliasName = this.xgetAliasName();
            this.xgetSqlClause().registerOuterJoinInlineWhereClause(aliasName, columnSqlName, key, cvalue, option, this._onClause);
        }
    }

    protected void registerExistsReferrer(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerExistsReferrer(subQuery, columnDbName, relatedColumnDbName, propertyName, null);
    }

    protected void registerNotExistsReferrer(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerExistsReferrer(subQuery, columnDbName, relatedColumnDbName, propertyName, "not");
    }

    protected void registerExistsReferrer(final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String existsOption) {
        this.assertSubQueryNotNull("ExistsReferrer", relatedColumnDbName, subQuery);
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        ExistsReferrer existsReferrer = new ExistsReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta);
        String clause = existsReferrer.buildExistsReferrer(columnDbName, relatedColumnDbName, existsOption);
        this.registerWhereClause(clause);
    }

    protected void registerInScopeRelation(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerInScopeRelation(subQuery, columnDbName, relatedColumnDbName, propertyName, null);
    }

    protected void registerNotInScopeRelation(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName) {
        this.registerInScopeRelation(subQuery, columnDbName, relatedColumnDbName, propertyName, "not");
    }

    protected void registerInScopeRelation(final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String inScopeOption) {
        this.assertSubQueryNotNull("InScopeRelation", columnDbName, subQuery);
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        boolean suppressLocalAliasName = this.isInScopeRelationSuppressLocalAliasName();
        InScopeRelation inScopeRelation = new InScopeRelation(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, suppressLocalAliasName);
        String clause = inScopeRelation.buildInScopeRelation(columnDbName, relatedColumnDbName, inScopeOption);
        this.registerWhereClause(clause);
    }

    protected boolean isInScopeRelationSuppressLocalAliasName() {
        return false;
    }

    protected void registerSpecifyDerivedReferrer(String function, final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String aliasName, DerivedReferrerOption option) {
        this.assertFunctionNotNull("SpecifyDerivedReferrer", columnDbName, function);
        this.assertSubQueryNotNull("SpecifyDerivedReferrer", columnDbName, subQuery);
        if (option == null) {
            option = new DerivedReferrerOption();
        }
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        SpecifyDerivedReferrer derivedReferrer = option.createSpecifyDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, aliasName);
        this.registerParameterOption(option);
        String clause = derivedReferrer.buildDerivedReferrer(function, columnDbName, relatedColumnDbName, option);
        HpDerivingSubQueryInfo subQueryInfo = new HpDerivingSubQueryInfo(aliasName, clause, derivedReferrer);
        this.xgetSqlClause().specifyDerivingSubQuery(subQueryInfo);
    }

    protected void registerQueryDerivedReferrer(String function, final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String operand, Object value, String parameterPropertyName, DerivedReferrerOption option) {
        this.assertFunctionNotNull("QueryDerivedReferrer", columnDbName, function);
        this.assertSubQueryNotNull("QueryDerivedReferrer", columnDbName, subQuery);
        if (option == null) {
            option = new DerivedReferrerOption();
        }
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        String parameterPath = this.xgetLocation(parameterPropertyName);
        QueryDerivedReferrer derivedReferrer = option.createQueryDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, operand, value, parameterPath);
        this.registerParameterOption(option);
        String clause = derivedReferrer.buildDerivedReferrer(function, columnDbName, relatedColumnDbName, option);
        this.registerWhereClause(clause);
    }

    protected void registerScalarCondition(String function, final ConditionQuery subQuery, String propertyName, String operand) {
        this.assertSubQueryNotNull("ScalarCondition", propertyName, subQuery);
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        ScalarCondition scalarCondition = new ScalarCondition(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, operand);
        String clause = scalarCondition.buildScalarCondition(function);
        this.registerWhereClause(clause);
    }

    protected void assertSubQueryNotNull(String title, String columnDbName, ConditionQuery subQuery) {
        if (subQuery == null) {
            String msg = "The condition-query for the sub-query should not be null:";
            msg = msg + " " + title + "(" + columnDbName + ")";
            throw new IllegalStateException(msg);
        }
    }

    protected void assertFunctionNotNull(String title, String columnDbName, String function) {
        if (function == null) {
            String msg = "The function for the sub-query should not be null:";
            msg = msg + " " + title + "(" + columnDbName + ")";
            throw new IllegalStateException(msg);
        }
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, null);
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        DBMeta dbmeta = this.findDBMeta(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        String location = this.xgetLocation(uncapPropName);
        key.setupConditionValue(this.xcreateQueryModeProvider(), cvalue, value, location, option);
        this.xgetSqlClause().registerWhereClause(this.toColumnRealName(columnDbName), key, cvalue, option);
    }

    protected void registerWhereClause(String whereClause) {
        this.xgetSqlClause().registerWhereClause(whereClause);
    }

    protected void registerInlineWhereClause(String whereClause) {
        if (this.isBaseQuery()) {
            this.xgetSqlClause().registerBaseTableInlineWhereClause(whereClause);
        } else {
            this.xgetSqlClause().registerOuterJoinInlineWhereClause(this.xgetAliasName(), whereClause, this._onClause);
        }
    }

    public void registerUnionQuery(ConditionQuery unionQuery, boolean unionAll, String unionQueryPropertyName) {
        String unionQueryClause = this.xgetUnionQuerySql(unionQuery, unionQueryPropertyName);
        this.xgetSqlClause().registerUnionQuery(unionQueryClause, unionAll);
    }

    protected String xgetUnionQuerySql(ConditionQuery unionQuery, String unionQueryPropertyName) {
        String unionQueryClause;
        String fromClause = unionQuery.xgetSqlClause().getFromClause();
        String whereClause = unionQuery.xgetSqlClause().getWhereClause();
        if (whereClause.trim().length() <= 0) {
            unionQueryClause = fromClause + " " + this.xgetSqlClause().getUnionWhereClauseMark();
        } else {
            int whereIndex = whereClause.indexOf("where ");
            if (whereIndex < 0) {
                String msg = "The whereClause should have 'where' string: " + whereClause;
                throw new IllegalStateException(msg);
            }
            int clauseIndex = whereIndex + "where ".length();
            String mark = this.xgetSqlClause().getUnionWhereFirstConditionMark();
            String markedClause = whereClause.substring(0, clauseIndex) + mark + whereClause.substring(clauseIndex);
            unionQueryClause = fromClause + " " + markedClause;
        }
        String oldStr = ".conditionQuery.";
        String newStr = ".conditionQuery." + unionQueryPropertyName + ".";
        return this.replaceString(unionQueryClause, ".conditionQuery.", newStr);
    }

    public void innerJoin() {
        if (this.isBaseQuery()) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The method 'innerJoin()' should be called for a relation query.");
            br.addItem("Advice");
            br.addElement("Please confirm your program.");
            br.addElement("For example:");
            br.addElement("  (x) - cb.query().innerJoin();");
            br.addElement("  (o) - cb.query().queryMemberStatus().innerJoin();");
            br.addItem("Base Table");
            br.addElement(this.getTableDbName());
            String msg = br.buildExceptionMessage();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this.xgetSqlClause().changeToInnerJoin(this.xgetAliasName());
    }

    protected void registerOrderBy(String columnDbName, boolean ascOrDesc) {
        this.xgetSqlClause().registerOrderBy(this.toColumnRealName(columnDbName).toString(), ascOrDesc);
    }

    protected void regOBA(String columnName) {
        this.assertOrderByPurpose(columnName);
        this.registerOrderBy(columnName, true);
    }

    protected void regOBD(String columnName) {
        this.assertOrderByPurpose(columnName);
        this.registerOrderBy(columnName, false);
    }

    protected void assertOrderByPurpose(String columnName) {
        if (this.xgetSqlClause().getPurpose().isNoOrderBy()) {
            this.throwOrderByIllegalPurposeException(columnName);
        }
    }

    protected void throwOrderByIllegalPurposeException(String columnName) {
        this.createCBExThrower().throwOrderByIllegalPurposeException(this.xgetSqlClause().getPurpose(), this.getTableDbName(), columnName);
    }

    public void withNullsFirst() {
        this.xgetSqlClause().addNullsFirstToPreviousOrderBy();
    }

    public void withNullsLast() {
        this.xgetSqlClause().addNullsLastToPreviousOrderBy();
    }

    public void withManualOrder(List<? extends Object> manualValueList) {
        this.assertObjectNotNull("withManualOrder(manualValueList)", manualValueList);
        OrderByClause.ManumalOrderInfo manumalOrderInfo = new OrderByClause.ManumalOrderInfo();
        manumalOrderInfo.setManualValueList(manualValueList);
        this.xgetSqlClause().addManualOrderToPreviousOrderByElement(manumalOrderInfo);
    }

    protected void registerSpecifiedDerivedOrderBy_Asc(String aliasName) {
        if (!this.xgetSqlClause().hasSpecifiedDerivingSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.xgetSqlClause().registerOrderBy(aliasName, true);
    }

    protected void registerSpecifiedDerivedOrderBy_Desc(String aliasName) {
        if (!this.xgetSqlClause().hasSpecifiedDerivingSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.xgetSqlClause().registerOrderBy(aliasName, false);
    }

    protected void throwSpecifiedDerivedOrderByAliasNameNotFoundException(String aliasName) {
        this.createCBExThrower().throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
    }

    protected String resolveJoinAliasName(String relationPath, int nestLevel) {
        return this.xgetSqlClause().resolveJoinAliasName(relationPath, nestLevel);
    }

    protected String resolveNextRelationPath(String localTableName, String foreignPropertyName) {
        int relationNo = this.xgetSqlClause().resolveRelationNo(localTableName, foreignPropertyName);
        String nextRelationPath = "_" + relationNo;
        if (this._relationPath != null) {
            nextRelationPath = this._relationPath + nextRelationPath;
        }
        return nextRelationPath;
    }

    @Override
    public ConditionValue invokeValue(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        DBMeta dbmeta = this.findDBMeta(this.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(columnFlexibleName));
        String methodName = "get" + columnCapPropName;
        Method method = this.helpGettingCQMethod(this, methodName, new Class[0]);
        if (method == null) {
            String msg = "Not found the method for getting value:";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            return (ConditionValue)this.helpInvokingCQMethod(this, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for getting value:";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object value) {
        this.doInvokeQuery(columnFlexibleName, conditionKeyName, value, null);
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object value, ConditionOption option) {
        this.assertObjectNotNull("option", option);
        this.doInvokeQuery(columnFlexibleName, conditionKeyName, value, option);
    }

    protected void doInvokeQuery(String columnFlexibleName, String conditionKeyName, Object value, ConditionOption option) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        this.assertStringNotNullAndNotTrimmedEmpty("conditionKeyName", conditionKeyName);
        if (value == null) {
            return;
        }
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String flexibleName = container.getFlexibleName();
        ConditionQuery cq = container.getConditionQuery();
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(flexibleName));
        String methodName = "set" + columnCapPropName + "_" + this.initCap(conditionKeyName);
        Class<?> type = value.getClass();
        Class[] parameterTypes = option != null ? new Class[]{type, option.getClass()} : new Class[]{type};
        Method method = this.helpGettingCQMethod(cq, methodName, parameterTypes);
        if (method == null) {
            String msg = "Not found the method for setting a condition(query):";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " conditionKeyName=" + conditionKeyName;
            msg = msg + " value=" + value;
            msg = msg + " option=" + option;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            Object[] args = option != null ? new Object[]{value, option} : new Object[]{value};
            this.helpInvokingCQMethod(cq, method, args);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for setting a condition(query):";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " conditionKeyName=" + conditionKeyName;
            msg = msg + " value=" + value;
            msg = msg + " option=" + option;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    @Override
    public void invokeQueryEqual(String columnFlexibleName, Object value) {
        this.invokeQuery(columnFlexibleName, CK_EQ.getConditionKey(), value);
    }

    @Override
    public void invokeOrderBy(String columnFlexibleName, boolean isAsc) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String flexibleName = container.getFlexibleName();
        ConditionQuery cq = container.getConditionQuery();
        String ascDesc = isAsc ? "Asc" : "Desc";
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(flexibleName));
        String methodName = "addOrderBy_" + columnCapPropName + "_" + ascDesc;
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[0]);
        if (method == null) {
            String msg = "Not found the method for adding a order-by condition:";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " isAsc=" + isAsc;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg);
        }
        this.helpInvokingCQMethod(cq, method, new Object[0]);
        try {
            this.helpInvokingCQMethod(cq, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for setting a condition(query):";
            msg = msg + " columnFlexibleName=" + columnFlexibleName;
            msg = msg + " isAsc=" + isAsc;
            msg = msg + " methodName=" + methodName;
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    @Override
    public ConditionQuery invokeForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        List<String> splitList = Srl.splitList(foreignPropertyName, ".");
        ConditionQuery foreignCQ = this;
        for (String elementName : splitList) {
            foreignCQ = this.doInvokeForeignCQ(foreignCQ, elementName);
        }
        return foreignCQ;
    }

    protected ConditionQuery doInvokeForeignCQ(ConditionQuery cq, String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "query" + this.initCap(foreignPropertyName);
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[0]);
        if (method == null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the method for getting a foreign condition query.");
            br.addItem("foreignPropertyName");
            br.addElement(foreignPropertyName);
            br.addItem("methodName");
            br.addElement(methodName);
            br.addItem("ConditionQuery");
            br.addElement(DfTypeUtil.toClassTitle(cq));
            String msg = br.buildExceptionMessage();
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            return (ConditionQuery)this.helpInvokingCQMethod(cq, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for setting a condition(query):";
            msg = msg + " foreignPropertyName=" + foreignPropertyName;
            msg = msg + " methodName=" + methodName + " table=" + this.getTableDbName();
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    @Override
    public boolean invokeHasForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        List<String> splitList = Srl.splitList(foreignPropertyName, ".");
        ConditionQuery foreignCQ = this;
        int splitLength = splitList.size();
        int index = 0;
        for (String elementName : splitList) {
            if (!this.doInvokeHasForeignCQ(foreignCQ, elementName)) {
                return false;
            }
            if (index + 1 < splitLength) {
                foreignCQ = foreignCQ.invokeForeignCQ(elementName);
            }
            ++index;
        }
        return true;
    }

    protected boolean doInvokeHasForeignCQ(ConditionQuery cq, String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "hasConditionQuery" + this.initCap(foreignPropertyName);
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[0]);
        if (method == null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the method for determining a foreign condition query.");
            br.addItem("foreignPropertyName");
            br.addElement(foreignPropertyName);
            br.addItem("methodName");
            br.addElement(methodName);
            br.addItem("ConditionQuery");
            br.addElement(DfTypeUtil.toClassTitle(cq));
            String msg = br.buildExceptionMessage();
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            return (Boolean)this.helpInvokingCQMethod(cq, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for determining a condition(query):";
            msg = msg + " foreignPropertyName=" + foreignPropertyName;
            msg = msg + " methodName=" + methodName + " table=" + this.getTableDbName();
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    private PropertyNameCQContainer helpExtractingPropertyNameCQContainer(String name) {
        String[] strings = name.split("\\.");
        int length = strings.length;
        String propertyName = null;
        ConditionQuery cq = this;
        int index = 0;
        for (String element : strings) {
            if (length == index + 1) {
                propertyName = element;
                break;
            }
            cq = cq.invokeForeignCQ(element);
            ++index;
        }
        return new PropertyNameCQContainer(propertyName, cq);
    }

    private Method helpGettingCQMethod(ConditionQuery cq, String methodName, Class<?>[] argTypes) {
        Class<?> clazz = cq.getClass();
        Method method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
        if (method == null && argTypes != null) {
            Class<?> superType;
            if (argTypes.length == 1 && Collection.class.isAssignableFrom(argTypes[0])) {
                method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{Collection.class});
            } else if (argTypes.length == 2 && ConditionOption.class.isAssignableFrom(argTypes[1])) {
                Class<?> superType2 = argTypes[1].getSuperclass();
                method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType2});
                if (method == null) {
                    superType2 = argTypes[1].getSuperclass();
                    method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType2});
                }
            } else if (argTypes.length == 3 && ConditionOption.class.isAssignableFrom(argTypes[2]) && (method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType = argTypes[2].getSuperclass()})) == null) {
                superType = argTypes[2].getSuperclass();
                method = DfReflectionUtil.getAccessibleMethod(clazz, methodName, new Class[]{superType});
            }
        }
        return method;
    }

    private Object helpInvokingCQMethod(ConditionQuery cq, Method method, Object[] args) {
        return DfReflectionUtil.invokeForcedly(method, cq, args);
    }

    protected ConditionValue nCV() {
        return this.newConditionValue();
    }

    protected ConditionValue newConditionValue() {
        return new ConditionValue();
    }

    protected String fRES(String value) {
        return this.filterRemoveEmptyString(value);
    }

    protected String filterRemoveEmptyString(String value) {
        if (this.isEmptyStringQueryAllowed()) {
            return value;
        }
        return value != null && !"".equals(value) ? value : null;
    }

    protected boolean isEmptyStringQueryAllowed() {
        return this.xgetSqlClause().isEmptyStringQueryAllowed();
    }

    protected Date fCTPD(Date date) {
        return this.filterConvertToPureDate(date);
    }

    protected Date filterConvertToPureDate(Date date) {
        return DfTypeUtil.toDate(date);
    }

    protected LikeSearchOption cLSOP() {
        return new LikeSearchOption().likePrefix();
    }

    protected <PROPERTY extends Number> PROPERTY cTNum(Object obj, Class<PROPERTY> type) {
        return (PROPERTY)DfTypeUtil.toNumber(obj, type);
    }

    protected <PROPERTY> List<PROPERTY> cTL(Collection<PROPERTY> col) {
        return this.convertToList(col);
    }

    protected List<String> cTStrL(Collection<? extends Classification> col) {
        ArrayList<String> list = new ArrayList<String>();
        for (Classification classification : col) {
            list.add(classification.code());
        }
        return list;
    }

    protected <PROPERTY extends Number> List<PROPERTY> cTNumL(Collection<? extends Classification> col, Class<PROPERTY> type) {
        ArrayList<Number> list = new ArrayList<Number>();
        for (Classification classification : col) {
            Number value = DfTypeUtil.toNumber(classification.code(), type);
            list.add(value);
        }
        return list;
    }

    private <PROPERTY> List<PROPERTY> convertToList(Collection<PROPERTY> col) {
        if (col == null) {
            return null;
        }
        if (col instanceof List) {
            return this.filterRemoveNullOrEmptyValueFromList((List)col);
        }
        return this.filterRemoveNullOrEmptyValueFromList(new ArrayList<PROPERTY>(col));
    }

    private <PROPERTY_TYPE> List<PROPERTY_TYPE> filterRemoveNullOrEmptyValueFromList(List<PROPERTY_TYPE> ls) {
        if (ls == null) {
            return null;
        }
        ArrayList<PROPERTY_TYPE> newList = new ArrayList<PROPERTY_TYPE>();
        for (PROPERTY_TYPE element : ls) {
            if (element == null || element instanceof String && ((String)element).length() == 0) continue;
            newList.add(element);
        }
        return newList;
    }

    protected String hSC(String columnName, String value, Integer size, String modeCode) {
        ParameterUtil.ShortCharHandlingMode mode = ParameterUtil.ShortCharHandlingMode.codeOf(modeCode);
        if (mode == null) {
            String msg = "The mode was not found by the code: ";
            msg = msg + " columnName=" + columnName + " modeCode=" + modeCode;
            throw new IllegalStateException(msg);
        }
        return ParameterUtil.handleShortChar(columnName, value, size, mode);
    }

    protected void xdoMatchForMySQL(List<ColumnInfo> textColumnList, String conditionValue, WayOfMySQL.FullTextSearchModifier modifier) {
        if (conditionValue == null || conditionValue.length() == 0) {
            return;
        }
        String clause = ((SqlClauseMySql)this.xgetSqlClause()).buildMatchCondition(textColumnList, conditionValue, modifier, this.getTableDbName(), this.xgetAliasName());
        this.registerWhereClause(clause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xdoMatchByLikeSearch(List<ColumnInfo> textColumnList, String conditionValue) {
        if (conditionValue == null || conditionValue.length() == 0) {
            return;
        }
        this.assertObjectNotNull("textColumnList", textColumnList);
        if (textColumnList.isEmpty()) {
            String msg = "The argument 'textColumnList' should not be empty list.";
            throw new IllegalArgumentException(msg);
        }
        conditionValue = this.xescapeFullTextSearchValue(conditionValue);
        int index = 0;
        this.xgetSqlClause().makeOrScopeQueryEffective();
        try {
            for (ColumnInfo columnInfo : textColumnList) {
                if (columnInfo == null) continue;
                String tableOfColumn = columnInfo.getDBMeta().getTableDbName();
                if (!tableOfColumn.equalsIgnoreCase(this.getTableDbName())) {
                    String msg = "The table of the text column should be '" + this.getTableDbName() + "'";
                    msg = msg + " but the table is '" + tableOfColumn + "': column=" + columnInfo;
                    throw new IllegalArgumentException(msg);
                }
                if (!columnInfo.isPropertyTypeString()) {
                    String msg = "The text column should be String type:";
                    msg = msg + " column=" + columnInfo;
                    throw new IllegalArgumentException(msg);
                }
                this.invokeQueryLikeSearch(columnInfo.getColumnDbName(), conditionValue, this.xcreateMatchLikeSearch());
                ++index;
            }
        }
        finally {
            this.xgetSqlClause().closeOrScopeQuery();
        }
    }

    protected String xescapeFullTextSearchValue(String conditionValue) {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected String xescapeOracleFullTextSearchValue(String conditionValue) {
        return ((SqlClauseOracle)this.xgetSqlClause()).escapeFullTextSearchValue(conditionValue);
    }

    protected LikeSearchOption xcreateMatchLikeSearch() {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected LikeSearchOption xcreatePostgreSQLMatchLikeSearch() {
        return new PostgreSQLMatchLikeSearch();
    }

    protected ExtensionOperand xgetPostgreSQLMatchOperand() {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected LikeSearchOption xcreateOracleMatchLikeSearch() {
        return new OracleMatchLikeSearch();
    }

    protected void registerParameterOption(ParameterOption option) {
        if (option == null) {
            return;
        }
        if (this._parameterOptionMap == null) {
            this._parameterOptionMap = this.newHashMap();
        }
        String parameterKey = "option" + this._parameterOptionMap.size();
        this._parameterOptionMap.put(parameterKey, option);
        String parameterMapPath = this.xgetLocationBase() + "optionParameterMap";
        option.acceptParameterKey(parameterKey, parameterMapPath);
    }

    public Map<String, ParameterOption> getOptionParameterMap() {
        return this._parameterOptionMap;
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return new ArrayList();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT element) {
        ArrayList<ELEMENT> arrayList = new ArrayList<ELEMENT>();
        arrayList.add(element);
        return arrayList;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> collection) {
        return new ArrayList<ELEMENT>(collection);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertColumnName(String columnName) {
        if (columnName == null) {
            String msg = "The columnName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.trim().length() == 0) {
            String msg = "The columnName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.indexOf(",") >= 0) {
            String msg = "The columnName should not contain comma ',': " + columnName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertAliasName(String aliasName) {
        if (aliasName == null) {
            String msg = "The aliasName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.trim().length() == 0) {
            String msg = "The aliasName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.indexOf(",") >= 0) {
            String msg = "The aliasName should not contain comma ',': " + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public String toString() {
        String titleName = DfTypeUtil.toClassTitle(this);
        return titleName + ":{aliasName=" + this._aliasName + ", nestLevel=" + this._nestLevel + ", subQueryLevel=" + this._subQueryLevel + ", foreignPropertyName=" + this._foreignPropertyName + ", relationPath=" + this._relationPath + ", onClauseInline=" + this._onClause + "}";
    }

    public class OracleMatchLikeSearch
    extends LikeSearchOption {
        private static final long serialVersionUID = 1L;

        public QueryClauseArranger getWhereClauseArranger() {
            return ((SqlClauseOracle)AbstractConditionQuery.this.xgetSqlClause()).createFullTextSearchClauseArranger();
        }
    }

    public class PostgreSQLMatchLikeSearch
    extends LikeSearchOption {
        private static final long serialVersionUID = 1L;

        public ExtensionOperand getExtensionOperand() {
            return AbstractConditionQuery.this.xgetPostgreSQLMatchOperand();
        }
    }

    private static class PropertyNameCQContainer {
        protected String _flexibleName;
        protected ConditionQuery _cq;

        public PropertyNameCQContainer(String flexibleName, ConditionQuery cq) {
            this._flexibleName = flexibleName;
            this._cq = cq;
        }

        public String getFlexibleName() {
            return this._flexibleName;
        }

        public ConditionQuery getConditionQuery() {
            return this._cq;
        }
    }

    protected class GeneralColumnRealNameProvider
    implements ColumnRealNameProvider {
        protected GeneralColumnRealNameProvider() {
        }

        public ColumnRealName provide(String columnDbName) {
            return AbstractConditionQuery.this.toColumnRealName(columnDbName);
        }
    }

    public static interface NssCall {
        public ConditionQuery qf();
    }
}

