/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.core.execution;

import java.util.Map;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.bhv.core.execution.AbstractFixedArgExecution;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnBasicParameterHandler;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;
import org.seasar.robot.dbflute.twowaysql.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCBExecution
extends AbstractFixedArgExecution {
    protected final TnResultSetHandler _resultSetHandler;

    public SelectCBExecution(DataSource dataSource, StatementFactory statementFactory, Map<String, Class<?>> argNameTypeMap, TnResultSetHandler resultSetHandler) {
        super(dataSource, statementFactory, argNameTypeMap);
        this.assertObjectNotNull("resultSetHandler", resultSetHandler);
        this._resultSetHandler = resultSetHandler;
    }

    @Override
    protected Node getRootNode(Object[] args) {
        return this.analyzeTwoWaySql(this.extractTwoWaySql(args));
    }

    protected String extractTwoWaySql(Object[] args) {
        this.assertArgsValid(args);
        Object firstElement = args[0];
        this.assertObjectNotNull("args[0]", firstElement);
        this.assertFirstElementConditionBean(firstElement);
        ConditionBean cb = (ConditionBean)firstElement;
        return cb.getSqlClause().getClause();
    }

    protected void assertArgsValid(Object[] args) {
        if (args == null) {
            String msg = "The argument 'args' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (args.length == 0) {
            String msg = "The argument 'args' should not be empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertFirstElementConditionBean(Object firstElement) {
        if (!(firstElement instanceof ConditionBean)) {
            String msg = "The first element of 'args' should be condition-bean: " + firstElement.getClass();
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    protected TnBasicParameterHandler newBasicParameterHandler(String executedSql) {
        return new TnBasicSelectHandler(this._dataSource, executedSql, this._resultSetHandler, this._statementFactory);
    }

    @Override
    protected boolean isBlockNullParameter() {
        return true;
    }
}

