/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute;

import java.util.HashMap;
import java.util.Map;
import org.seasar.robot.dbflute.dbway.DBWay;
import org.seasar.robot.dbflute.dbway.WayOfDB2;
import org.seasar.robot.dbflute.dbway.WayOfDerby;
import org.seasar.robot.dbflute.dbway.WayOfFirebird;
import org.seasar.robot.dbflute.dbway.WayOfH2;
import org.seasar.robot.dbflute.dbway.WayOfMSAccess;
import org.seasar.robot.dbflute.dbway.WayOfMySQL;
import org.seasar.robot.dbflute.dbway.WayOfOracle;
import org.seasar.robot.dbflute.dbway.WayOfPostgreSQL;
import org.seasar.robot.dbflute.dbway.WayOfSQLServer;
import org.seasar.robot.dbflute.dbway.WayOfSQLite;
import org.seasar.robot.dbflute.dbway.WayOfSybase;
import org.seasar.robot.dbflute.dbway.WayOfUnknown;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DBDef {
    MySQL("mysql", null, new WayOfMySQL()),
    PostgreSQL("postgresql", "postgre", new WayOfPostgreSQL()),
    Oracle("oracle", null, new WayOfOracle()),
    DB2("db2", null, new WayOfDB2()),
    SQLServer("sqlserver", "mssql", new WayOfSQLServer()),
    H2("h2", null, new WayOfH2()),
    Derby("derby", null, new WayOfDerby()),
    SQLite("sqlite", null, new WayOfSQLite()),
    MSAccess("msaccess", null, new WayOfMSAccess()),
    FireBird("firebird", null, new WayOfFirebird()),
    Sybase("sybase", null, new WayOfSybase()),
    Unknown("unknown", null, new WayOfUnknown());

    private static final Map<String, DBDef> _codeValueMap;
    private static final Map<String, DBDef> _codeAliasValueMap;
    private String _code;
    private String _codeAlias;
    private DBWay _dbway;

    public static DBDef codeOf(String code) {
        if (code == null) {
            return null;
        }
        String lowerCaseCode = code.toLowerCase();
        DBDef def = _codeValueMap.get(lowerCaseCode);
        if (def == null) {
            def = _codeAliasValueMap.get(lowerCaseCode);
        }
        return def;
    }

    private DBDef(String code, String codeAlias, DBWay dbway) {
        this._code = code;
        this._codeAlias = codeAlias;
        this._dbway = dbway;
    }

    public String code() {
        return this._code;
    }

    private String codeAlias() {
        return this._codeAlias;
    }

    public DBWay dbway() {
        return this._dbway;
    }

    static {
        _codeValueMap = new HashMap<String, DBDef>();
        for (DBDef value : DBDef.values()) {
            _codeValueMap.put(value.code().toLowerCase(), value);
        }
        _codeAliasValueMap = new HashMap<String, DBDef>();
        for (DBDef value : DBDef.values()) {
            if (value.codeAlias() == null) continue;
            _codeAliasValueMap.put(value.codeAlias().toLowerCase(), value);
        }
    }
}

