/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.CharCharAssociativeContainer;
import com.carrotsearch.hppc.CharCharMap;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.CharCharCursor;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharCharProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharCharOpenHashMap
implements CharCharMap,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public char[] keys;
    public char[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public CharCharOpenHashMap() {
        this(16);
    }

    public CharCharOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CharCharOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public CharCharOpenHashMap(CharCharAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public char put(char key, char value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                char oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return '\u0000';
    }

    @Override
    public final int putAll(CharCharAssociativeContainer container) {
        int count = this.assigned;
        for (CharCharCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends CharCharCursor> iterable) {
        int count = this.assigned;
        for (CharCharCursor charCharCursor : iterable) {
            this.put(charCharCursor.key, charCharCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(char key, char value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final char putOrAdd(char key, char putValue, char additionValue) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int n = slot;
                char c = (char)(this.values[n] + additionValue);
                this.values[n] = c;
                return c;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        char v = this.values[slot] = putValue;
        return v;
    }

    private void expandAndRehash() {
        char[] oldKeys = this.keys;
        char[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            char key = oldKeys[i];
            char value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new char[capacity];
        this.values = new char[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public char remove(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                char v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(CharContainer container) {
        int before = this.assigned;
        for (CharCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(CharPredicate predicate) {
        int before = this.assigned;
        char[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public char get(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    public char lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public char lset(char key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        char previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (CharCharCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            CharCharMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof CharCharMap && (other = (CharCharMap)obj).size() == this.size()) {
                for (CharCharCursor c : this) {
                    char v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<CharCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharCharProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        char[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public CharContainer values() {
        return new ValuesContainer();
    }

    public CharCharOpenHashMap clone() {
        try {
            CharCharOpenHashMap cloned = (CharCharOpenHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (char[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharCharCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharCharOpenHashMap from(char[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharCharOpenHashMap map = new CharCharOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharCharOpenHashMap from(CharCharAssociativeContainer container) {
        return new CharCharOpenHashMap(container);
    }

    public static CharCharOpenHashMap newInstance() {
        return new CharCharOpenHashMap();
    }

    public static CharCharOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new CharCharOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            int max = CharCharOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharCharOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharCharOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return CharCharOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CharCharOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            boolean[] allocated = CharCharOpenHashMap.this.allocated;
            char[] values = CharCharOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            boolean[] allocated = CharCharOpenHashMap.this.allocated;
            char[] values = CharCharOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            boolean[] allocated = CharCharOpenHashMap.this.allocated;
            char[] values = CharCharOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(char e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            int max = CharCharOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharCharOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharCharOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharCharOpenHashMap owner;

        public KeysContainer() {
            this.owner = CharCharOpenHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return CharCharOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<CharCharCursor> {
        private final CharCharCursor cursor = new CharCharCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharCharCursor fetch() {
            int i;
            int max = CharCharOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharCharOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharCharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = CharCharOpenHashMap.this.keys[i];
            this.cursor.value = CharCharOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

