/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.SuggestTitleTokenizer;
import jp.sf.fess.solr.plugin.suggest.SuggestConverterCreator;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestTitleTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(SuggestTitleTokenizerFactory.class);
    private static final String MODE = "mode";
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String BUFFER_SIZE = "bufferSize";
    private static final String WORD_SEPARATOR = "wordSeparator";
    private UserDictionary userDictionary;
    private JapaneseTokenizer.Mode mode;
    private boolean discardPunctuation;
    private int bufferSize;
    private String wordSeparator;
    private List<SuggestConverter> preConverterList;
    private List<SuggestConverter> converterList;

    public SuggestTitleTokenizer create(Reader input) {
        return new SuggestTitleTokenizer(input, this.bufferSize, this.userDictionary, this.discardPunctuation, this.mode, this.preConverterList, this.converterList, this.wordSeparator);
    }

    public void inform(ResourceLoader loader) {
        try {
            this.mode = this.getMode(this.args);
            String userDictionaryPath = (String)this.args.get(USER_DICT_PATH);
            if (userDictionaryPath != null) {
                InputStream stream = loader.openResource(userDictionaryPath);
                String encoding = (String)this.args.get(USER_DICT_ENCODING);
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                InputStreamReader reader = new InputStreamReader(stream, decoder);
                this.userDictionary = new UserDictionary((Reader)reader);
            } else {
                this.userDictionary = null;
            }
            this.discardPunctuation = true;
            this.bufferSize = this.getInt(BUFFER_SIZE, 256);
            this.wordSeparator = (String)this.args.get(WORD_SEPARATOR);
            if (this.wordSeparator == null) {
                this.wordSeparator = "_SP_";
            }
            this.preConverterList = SuggestConverterCreator.create((String)this.args.get("preConverters"));
            this.converterList = SuggestConverterCreator.create((String)this.args.get("converters"));
        }
        catch (Exception e) {
            logger.warn("Initialization failed.", (Throwable)e);
        }
    }

    private JapaneseTokenizer.Mode getMode(Map<String, String> args) {
        String modeArg = args.get(MODE);
        if (modeArg != null) {
            return JapaneseTokenizer.Mode.valueOf((String)modeArg.toUpperCase(Locale.ROOT));
        }
        return JapaneseTokenizer.Mode.NORMAL;
    }
}

