/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.fst;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingSuggester;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.suggest.LookupFactory;

public class AnalyzingLookupFactory
extends LookupFactory {
    public static final String EXACT_MATCH_FIRST = "exactMatchFirst";
    public static final String PRESERVE_SEP = "preserveSep";
    public static final String MAX_SURFACE_FORMS = "maxSurfaceFormsPerAnalyzedForm";
    public static final String MAX_EXPANSIONS = "maxGraphExpansions";
    public static final String QUERY_ANALYZER = "suggestAnalyzerFieldType";
    private static final String FILENAME = "wfsta.bin";

    @Override
    public Lookup create(NamedList params, SolrCore core) {
        Object fieldTypeName = params.get(QUERY_ANALYZER);
        if (fieldTypeName == null) {
            throw new IllegalArgumentException("Error in configuration: suggestAnalyzerFieldType parameter is mandatory");
        }
        FieldType ft = core.getSchema().getFieldTypeByName(fieldTypeName.toString());
        Analyzer indexAnalyzer = ft.getAnalyzer();
        Analyzer queryAnalyzer = ft.getQueryAnalyzer();
        boolean exactMatchFirst = params.get(EXACT_MATCH_FIRST) != null ? Boolean.valueOf(params.get(EXACT_MATCH_FIRST).toString()) : true;
        boolean preserveSep = params.get(PRESERVE_SEP) != null ? Boolean.valueOf(params.get(PRESERVE_SEP).toString()) : true;
        int flags = 0;
        if (exactMatchFirst) {
            flags |= 1;
        }
        if (preserveSep) {
            flags |= 2;
        }
        int maxSurfaceFormsPerAnalyzedForm = params.get(MAX_SURFACE_FORMS) != null ? Integer.parseInt(params.get(MAX_SURFACE_FORMS).toString()) : 256;
        int maxGraphExpansions = params.get(MAX_EXPANSIONS) != null ? Integer.parseInt(params.get(MAX_EXPANSIONS).toString()) : -1;
        return new AnalyzingSuggester(indexAnalyzer, queryAnalyzer, flags, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions);
    }

    @Override
    public String storeFileName() {
        return FILENAME;
    }
}

