/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.net.URL;
import java.util.Map;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;

public abstract class SolrCacheBase {
    protected CacheRegenerator regenerator;
    private SolrCache.State state;
    private String name;
    protected AutoWarmCountRef autowarm;

    protected static String calcHitRatio(long lookups, long hits) {
        if (lookups == 0L) {
            return "0.00";
        }
        if (lookups == hits) {
            return "1.00";
        }
        int hundredths = (int)(hits * 100L / lookups);
        if (hundredths < 10) {
            return "0.0" + hundredths;
        }
        return "0." + hundredths;
    }

    public String getVersion() {
        return "1.0";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    public URL[] getDocs() {
        return null;
    }

    public void init(Map<String, String> args, CacheRegenerator regenerator) {
        this.regenerator = regenerator;
        this.state = SolrCache.State.CREATED;
        this.name = args.get("name");
        this.autowarm = new AutoWarmCountRef(args.get("autowarmCount"));
    }

    protected String getAutowarmDescription() {
        return "autowarmCount=" + this.autowarm + ", regenerator=" + this.regenerator;
    }

    protected boolean isAutowarmingOn() {
        return this.autowarm.isAutoWarmingOn();
    }

    public void setState(SolrCache.State state) {
        this.state = state;
    }

    public SolrCache.State getState() {
        return this.state;
    }

    public String name() {
        return this.name;
    }

    public static class AutoWarmCountRef {
        private final int autoWarmCount;
        private final int autoWarmPercentage;
        private final boolean autoWarmByPercentage;
        private final boolean doAutoWarming;
        private final String strVal;

        public AutoWarmCountRef(String configValue) {
            try {
                String input = null == configValue ? "0" : configValue.trim();
                String string = this.strVal = "-1".equals(input) ? "100%" : input;
                if (this.strVal.indexOf("%") == this.strVal.length() - 1) {
                    this.autoWarmCount = 0;
                    this.autoWarmPercentage = Integer.parseInt(this.strVal.substring(0, this.strVal.length() - 1));
                    this.autoWarmByPercentage = true;
                    this.doAutoWarming = 0 < this.autoWarmPercentage;
                } else {
                    this.autoWarmCount = Integer.parseInt(this.strVal);
                    this.autoWarmPercentage = 0;
                    this.autoWarmByPercentage = false;
                    this.doAutoWarming = 0 < this.autoWarmCount;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can't parse autoWarm value: " + configValue, e);
            }
        }

        public String toString() {
            return this.strVal;
        }

        public boolean isAutoWarmingOn() {
            return this.doAutoWarming;
        }

        public int getWarmCount(int previousCacheSize) {
            return this.autoWarmByPercentage ? previousCacheSize * this.autoWarmPercentage / 100 : Math.min(previousCacheSize, this.autoWarmCount);
        }
    }
}

