/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.AttributeSource;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.JsonPreAnalyzedParser;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreAnalyzedField
extends FieldType {
    private static final Logger LOG = LoggerFactory.getLogger(PreAnalyzedField.class);
    public static final String PARSER_IMPL = "parserImpl";
    private static final String DEFAULT_IMPL = JsonPreAnalyzedParser.class.getName();
    private PreAnalyzedParser parser;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String implName = args.get(PARSER_IMPL);
        if (implName == null) {
            this.parser = new JsonPreAnalyzedParser();
        } else {
            try {
                Class<?> implClazz = Class.forName(implName);
                if (!PreAnalyzedParser.class.isAssignableFrom(implClazz)) {
                    throw new Exception("must implement " + PreAnalyzedParser.class.getName());
                }
                Constructor<?> c = implClazz.getConstructor(new Class[0]);
                this.parser = (PreAnalyzedParser)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Can't use the configured PreAnalyzedParser class '" + implName + "' (" + e.getMessage() + "), using default " + DEFAULT_IMPL);
                this.parser = new JsonPreAnalyzedParser();
            }
        }
    }

    @Override
    public Analyzer getAnalyzer() {
        return new SolrAnalyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new PreAnalyzedTokenizer(reader, PreAnalyzedField.this.parser));
            }
        };
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.getAnalyzer();
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        IndexableField f = null;
        try {
            f = this.fromString(field, String.valueOf(value), boost);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return f;
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    public String toFormattedString(Field f) throws IOException {
        return this.parser.toFormattedString(f);
    }

    public IndexableField fromString(SchemaField field, String val, float boost) throws Exception {
        if (val == null || val.trim().length() == 0) {
            return null;
        }
        PreAnalyzedTokenizer parse = new PreAnalyzedTokenizer(new StringReader(val), this.parser);
        parse.reset();
        Field f = (Field)super.createField(field, val, boost);
        if (parse.getStringValue() != null) {
            f.setStringValue(parse.getStringValue());
        } else if (parse.getBinaryValue() != null) {
            f.setBytesValue(parse.getBinaryValue());
        } else {
            f.fieldType().setStored(false);
        }
        if (parse.hasTokenStream()) {
            f.fieldType().setIndexed(true);
            f.fieldType().setTokenized(true);
            f.setTokenStream((TokenStream)parse);
        }
        return f;
    }

    private static class PreAnalyzedTokenizer
    extends Tokenizer {
        private final List<AttributeSource.State> cachedStates = new LinkedList<AttributeSource.State>();
        private Iterator<AttributeSource.State> it = null;
        private String stringValue = null;
        private byte[] binaryValue = null;
        private PreAnalyzedParser parser;
        private Reader lastReader;

        public PreAnalyzedTokenizer(Reader reader, PreAnalyzedParser parser) {
            super(reader);
            this.parser = parser;
        }

        public boolean hasTokenStream() {
            return !this.cachedStates.isEmpty();
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public byte[] getBinaryValue() {
            return this.binaryValue;
        }

        public final boolean incrementToken() {
            if (this.it == null) {
                this.it = this.cachedStates.iterator();
            }
            if (!this.it.hasNext()) {
                return false;
            }
            AttributeSource.State state = this.it.next();
            this.restoreState(state.clone());
            return true;
        }

        public final void reset() throws IOException {
            if (this.input != this.lastReader) {
                this.lastReader = this.input;
                this.cachedStates.clear();
                this.stringValue = null;
                this.binaryValue = null;
                ParseResult res = this.parser.parse(this.input, (AttributeSource)this);
                if (res != null) {
                    this.stringValue = res.str;
                    this.binaryValue = res.bin;
                    if (res.states != null) {
                        this.cachedStates.addAll(res.states);
                    }
                }
            }
            this.it = this.cachedStates.iterator();
        }

        public void close() throws IOException {
            super.close();
            this.lastReader = null;
        }
    }

    public static interface PreAnalyzedParser {
        public ParseResult parse(Reader var1, AttributeSource var2) throws IOException;

        public String toFormattedString(Field var1) throws IOException;
    }

    public static class ParseResult {
        public String str;
        public byte[] bin;
        public List<AttributeSource.State> states = new LinkedList<AttributeSource.State>();
    }
}

