/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import org.apache.solr.rest.CopyFieldCollectionResource;
import org.apache.solr.rest.DefaultSchemaResource;
import org.apache.solr.rest.DynamicFieldCollectionResource;
import org.apache.solr.rest.DynamicFieldResource;
import org.apache.solr.rest.FieldCollectionResource;
import org.apache.solr.rest.FieldResource;
import org.apache.solr.rest.FieldTypeCollectionResource;
import org.apache.solr.rest.FieldTypeResource;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRestApi
extends Application {
    public static final Logger log = LoggerFactory.getLogger(SchemaRestApi.class);
    public static final String FIELDS = "fields";
    public static final String FIELDS_PATH = "/fields";
    public static final String DYNAMIC_FIELDS = "dynamicfields";
    public static final String DYNAMIC_FIELDS_PATH = "/dynamicfields";
    public static final String FIELDTYPES = "fieldtypes";
    public static final String FIELDTYPES_PATH = "/fieldtypes";
    public static final String NAME_VARIABLE = "name";
    public static final String NAME_SEGMENT = "/{name}";
    public static final String COPY_FIELDS = "copyfields";
    public static final String COPY_FIELDS_PATH = "/copyfields";
    private Router router = new Router(this.getContext());

    public void stop() throws Exception {
        if (this.router != null) {
            this.router.stop();
        }
    }

    public synchronized Restlet createInboundRoot() {
        log.info("createInboundRoot started");
        this.router.attachDefault(DefaultSchemaResource.class);
        this.router.attach(FIELDS_PATH, FieldCollectionResource.class);
        this.router.attach("/fields/", FieldCollectionResource.class);
        this.router.attach("/fields/{name}", FieldResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH, DynamicFieldCollectionResource.class);
        this.router.attach("/dynamicfields/", DynamicFieldCollectionResource.class);
        this.router.attach("/dynamicfields/{name}", DynamicFieldResource.class);
        this.router.attach(FIELDTYPES_PATH, FieldTypeCollectionResource.class);
        this.router.attach("/fieldtypes/", FieldTypeCollectionResource.class);
        this.router.attach("/fieldtypes/{name}", FieldTypeResource.class);
        this.router.attach(COPY_FIELDS_PATH, CopyFieldCollectionResource.class);
        this.router.attach("/copyfields/", CopyFieldCollectionResource.class);
        log.info("createInboundRoot complete");
        return this.router;
    }
}

