/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.chronos.core.task.impl.TaskMethodMetaData;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskMethodManager {
    private static final String NO_GROUP = "noGroup";
    private final Class<?> clazz;
    private final String prefixMethodName;
    private final HashMap<String, HashMap<String, Method>> methodMap = CollectionsUtil.newHashMap();
    private final HashMap<String, ArrayList<Method>> methodList = CollectionsUtil.newHashMap();
    private final ArrayList<String> groupList = CollectionsUtil.newArrayList();
    private final ArrayList<Method> methodAllList = CollectionsUtil.newArrayList();

    public TaskMethodManager(Class<?> clazz, String prefixMethodName) {
        this.clazz = clazz;
        this.prefixMethodName = prefixMethodName;
        this.initialize();
    }

    public Map<String, Method> getMethodMapByNoGroup() {
        return this.methodMap.get(NO_GROUP);
    }

    public Map<String, Method> getMethodMap(String groupName) {
        return this.methodMap.get(groupName);
    }

    public List<Method> getMethodList(String groupName) {
        return this.methodList.get(groupName);
    }

    public List<String> getGroupList() {
        return this.groupList;
    }

    public boolean existGroup(String groupName) {
        return this.methodMap.get(groupName) != null;
    }

    public List<Method> getAllMethodList() {
        return this.methodAllList;
    }

    private void initialize() {
        Method[] methods;
        for (Method method : methods = this.clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith(this.prefixMethodName)) continue;
            TaskMethodMetaData md = new TaskMethodMetaData(method);
            String groupName = md.getGroupName();
            if (md == null) {
                groupName = NO_GROUP;
            }
            HashMap<String, Method> jobMethodMap = this.methodMap.get(groupName);
            ArrayList<Method> jobMethodList = this.methodList.get(groupName);
            if (null == jobMethodMap) {
                jobMethodMap = new HashMap();
                jobMethodList = new ArrayList();
                this.methodMap.put(groupName, jobMethodMap);
                this.methodList.put(groupName, jobMethodList);
                this.groupList.add(groupName);
            }
            jobMethodMap.put(methodName, method);
            jobMethodList.add(method);
            this.methodAllList.add(method);
        }
    }
}

