/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.annotation.task.Task;
import org.seasar.chronos.core.task.TaskAnnotationReader;
import org.seasar.chronos.core.task.TaskTriggerFinder;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskAnnotationReaderImpl
implements TaskAnnotationReader {
    private static final String METHOD_NAME_GET_TRIGGER = "getTrigger";
    private Class<?> taskClass;
    private TaskTriggerFinder taskTriggerFinder;

    @Override
    public void setup(Class<?> taskClass) {
        this.taskClass = taskClass;
    }

    @Override
    public boolean hasTaskAnnotation() {
        Task task = this.taskClass.getAnnotation(Task.class);
        return task != null;
    }

    @Override
    public boolean hasTriggerAnnotation() {
        Annotation[] annotaions;
        for (Annotation annotaion : annotaions = this.taskClass.getAnnotations()) {
            Class<? extends Annotation> annotaionClass = annotaion.annotationType();
            String annotationName = annotaionClass.getSimpleName();
            if (!annotationName.endsWith("Trigger")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTriggerProperty() {
        try {
            Method method = ReflectionUtil.getMethod(this.taskClass, (String)METHOD_NAME_GET_TRIGGER, (Class[])new Class[0]);
            return method != null;
        }
        catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
            return false;
        }
    }

    @Override
    public Task getTaskAnnotation() {
        Task task = this.taskClass.getAnnotation(Task.class);
        return task;
    }

    @Override
    public TaskTrigger getTriggerAnnotationClass(TaskAnnotationReader.TriggerAnnotationHandler triggerAnnotationHandler) {
        Annotation[] annotations = this.taskClass.getAnnotations();
        TaskTrigger taskTrigger = this.taskTriggerFinder.find(annotations, triggerAnnotationHandler);
        return taskTrigger;
    }

    public void setTaskTriggerFinder(TaskTriggerFinder taskTriggerFinder) {
        this.taskTriggerFinder = taskTriggerFinder;
    }
}

