/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.handler.impl.property.read;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.task.TaskAnnotationReader;
import org.seasar.chronos.core.task.TaskPropertyWriter;
import org.seasar.chronos.core.task.handler.impl.AbstractTaskPropertyHandler;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

public class TaskIsStartTaskPropertyReadHandlerImpl
extends AbstractTaskPropertyHandler {
    private static Logger log = Logger.getLogger(TaskIsStartTaskPropertyReadHandlerImpl.class);
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    private TaskAnnotationReader taskAnnotationReader;
    private TaskPropertyWriter taskPropertyWriter;

    public Object execute(MethodInvocation methodInvocation) throws Throwable {
        boolean start = (Boolean)methodInvocation.proceed();
        TaskTrigger taskTrigger = this.getTaskPropertyReader(methodInvocation).getTrigger(null);
        if (taskTrigger == null) {
            this.taskAnnotationReader.setup(this.getTaskPropertyReader(methodInvocation).getTaskClass());
            taskTrigger = this.taskAnnotationReader.getTriggerAnnotationClass(new TaskAnnotationReader.TriggerAnnotationHandler(){

                @Override
                public TaskTrigger process(Annotation annotation, Class<?> triggerAnnotationClass) {
                    if (triggerAnnotationClass != null) {
                        try {
                            TaskTrigger taskTrigger = (TaskTrigger)ReflectionUtil.newInstance(triggerAnnotationClass);
                            this.build(taskTrigger, annotation, triggerAnnotationClass);
                            return taskTrigger;
                        }
                        catch (Exception e) {
                            log.warn((Object)"Failed to build taskTrigger.", (Throwable)e);
                        }
                    }
                    return null;
                }

                private void build(TaskTrigger taskTrigger, Annotation annotaion, Class<?> triggerAnnotationClass) {
                    Method[] mis;
                    BeanDesc beanDesc = BeanDescFactory.getBeanDesc(triggerAnnotationClass);
                    for (Method m : mis = annotaion.annotationType().getMethods()) {
                        String methodName = m.getName();
                        if (!beanDesc.hasPropertyDesc(methodName)) continue;
                        PropertyDesc pd = beanDesc.getPropertyDesc(methodName);
                        Object value = ReflectionUtil.invoke((Method)m, (Object)annotaion, (Object[])new Object[0]);
                        this.convertProperty(taskTrigger, m, pd, value);
                    }
                }

                private void convertProperty(TaskTrigger taskTrigger, Method m, PropertyDesc pd, Object value) {
                    if (m.getReturnType().equals(pd.getPropertyType())) {
                        pd.setValue((Object)taskTrigger, value);
                    } else if (pd.getPropertyType().equals(Date.class) && m.getReturnType().equals(String.class) && !StringUtil.isEmpty((String)((String)value))) {
                        SimpleDateFormat sdf = new SimpleDateFormat(TaskIsStartTaskPropertyReadHandlerImpl.YYYY_MM_DD_HH_MM_SS);
                        Date date = null;
                        try {
                            date = sdf.parse((String)value);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        pd.setValue((Object)taskTrigger, (Object)date);
                    }
                }
            });
            this.taskPropertyWriter.setup(this.getTaskPropertyReader(methodInvocation).getTask(), this.getTaskPropertyReader(methodInvocation).getBeanDesc());
            this.taskPropertyWriter.setTrigger(taskTrigger);
        }
        if (taskTrigger != null) {
            start = start || taskTrigger.isStartTask();
        }
        return start;
    }

    public void setTaskAnnotationReader(TaskAnnotationReader taskAnnotationReader) {
        this.taskAnnotationReader = taskAnnotationReader;
    }

    public void setTaskPropertyWriter(TaskPropertyWriter taskPropertyWriter) {
        this.taskPropertyWriter = taskPropertyWriter;
    }
}

