/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.handler.impl.property;

import java.util.Map;
import org.seasar.framework.util.tiger.CollectionsUtil;

public final class PropertyCache {
    private static Map<Object, PropertyCache> propertyCacheInstanceMap = CollectionsUtil.newConcurrentHashMap();
    private final Map<String, Object> propertyCache = CollectionsUtil.newConcurrentHashMap();
    private final Object selfKey;

    public Object getSelfKey() {
        return this.selfKey;
    }

    private PropertyCache(Object selfKey) {
        this.selfKey = selfKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertyCache getInstance(Object key) {
        PropertyCache propertyCacheInstance = propertyCacheInstanceMap.get(key);
        if (propertyCacheInstance != null) return propertyCacheInstance;
        Class<PropertyCache> clazz = PropertyCache.class;
        synchronized (PropertyCache.class) {
            propertyCacheInstance = propertyCacheInstanceMap.get(key);
            if (propertyCacheInstance != null) return propertyCacheInstance;
            propertyCacheInstance = new PropertyCache(key);
            propertyCacheInstanceMap.put(key, propertyCacheInstance);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return propertyCacheInstance;
        }
    }

    public Object get(String key) {
        return this.propertyCache.get(key);
    }

    public void put(String key, Object value) {
        this.propertyCache.put(key, value);
    }

    public boolean remove(String key) {
        return this.propertyCache.remove(key) != null;
    }

    public void clear() {
        this.propertyCache.clear();
    }
}

