/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.handler.impl;

import org.seasar.chronos.core.SchedulerConfiguration;
import org.seasar.chronos.core.TaskScheduleEntry;
import org.seasar.chronos.core.handler.impl.AbstractScheduleExecuteHandler;
import org.seasar.chronos.core.impl.TaskStateType;
import org.seasar.chronos.core.schedule.TaskScheduleEntryManager;
import org.seasar.chronos.core.task.handler.impl.property.PropertyCache;

public class ScheduleTaskStateCleanHandler
extends AbstractScheduleExecuteHandler {
    private SchedulerConfiguration schedulerConfiguration;

    public void handleRequest() throws InterruptedException {
        TaskScheduleEntry taskScheduleEntry = (TaskScheduleEntry)this.taskScheduleEntryManager.forEach(TaskStateType.UNSCHEDULED, new TaskScheduleEntryManager.TaskScheduleEntryHanlder(){

            public Object processTaskScheduleEntry(TaskScheduleEntry scheduleEntry) {
                long now = System.currentTimeMillis();
                if (scheduleEntry.getUnScheduledDate() != null && now > ScheduleTaskStateCleanHandler.this.schedulerConfiguration.getTaskStateCleanupTime() + scheduleEntry.getUnScheduledDate().getTime()) {
                    return scheduleEntry;
                }
                return null;
            }
        });
        if (taskScheduleEntry != null) {
            taskScheduleEntry.getTaskExecutorService().destroy();
            this.taskScheduleEntryManager.removeTaskScheduleEntry(taskScheduleEntry);
            PropertyCache propertyCache = PropertyCache.getInstance(taskScheduleEntry.getTask());
            propertyCache.clear();
        }
    }

    public void setSchedulerConfiguration(SchedulerConfiguration schedulerConfiguration) {
        this.schedulerConfiguration = schedulerConfiguration;
    }
}

