/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.exception.ForCommentIllegalParameterBeanSpecificationException;
import org.seasar.dbflute.twowaysql.exception.ForCommentParameterNotListException;
import org.seasar.dbflute.twowaysql.node.LoopAbstractNode;
import org.seasar.dbflute.twowaysql.node.LoopAcceptable;
import org.seasar.dbflute.twowaysql.node.LoopFirstNode;
import org.seasar.dbflute.twowaysql.node.LoopInfo;
import org.seasar.dbflute.twowaysql.node.LoopLastNode;
import org.seasar.dbflute.twowaysql.node.LoopNextNode;
import org.seasar.dbflute.twowaysql.node.NodeUtil;
import org.seasar.dbflute.twowaysql.node.ScopeNode;
import org.seasar.dbflute.twowaysql.node.SqlConnectorAdjustable;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

public class ForNode
extends ScopeNode
implements SqlConnectorAdjustable,
LoopAcceptable {
    public static final String PREFIX = "FOR ";
    public static final String CURRENT_VARIABLE = "#current";
    protected final String _expression;
    protected final List<String> _nameList;
    protected final String _specifiedSql;

    public ForNode(String expression, String specifiedSql) {
        this._expression = expression;
        this._nameList = Srl.splitList(expression, ".");
        this._specifiedSql = specifiedSql;
    }

    @Override
    public void accept(CommandContext ctx) {
        this.doAccept(ctx, null);
    }

    @Override
    public void accept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        if (firstName.equals(CURRENT_VARIABLE)) {
            Object parameter = loopInfo.getCurrentParameter();
            Class<?> parameterType = loopInfo.getCurrentParameterType();
            this.doAccept(ctx, parameter, parameterType, loopInfo, true);
        } else {
            this.doAccept(ctx, loopInfo);
        }
    }

    public void doAccept(CommandContext ctx, LoopInfo parentLoop) {
        String firstName = this._nameList.get(0);
        this.assertFirstNameAsNormal(ctx, firstName);
        Object value = ctx.getArg(firstName);
        Class<?> clazz = ctx.getArgType(firstName);
        this.doAccept(ctx, value, clazz, parentLoop, false);
    }

    public void doAccept(CommandContext ctx, Object firstValue, Class<?> firstType, LoopInfo parentLoop, boolean inheritLoop) {
        Object targetValue;
        if (firstValue == null) {
            return;
        }
        ValueAndType valueAndType = new ValueAndType();
        valueAndType.setFirstValue(firstValue);
        valueAndType.setFirstType(firstType);
        this.setupValueAndType(valueAndType);
        if (inheritLoop) {
            valueAndType.inheritLikeSearchOptionIfNeeds(parentLoop);
        }
        if ((targetValue = valueAndType.getTargetValue()) == null) {
            return;
        }
        this.assertParameterList(targetValue);
        List parameterList = (List)targetValue;
        int loopSize = parameterList.size();
        LoopInfo loopInfo = new LoopInfo();
        loopInfo.setParentLoop(parentLoop);
        loopInfo.setExpression(this._expression);
        loopInfo.setSpecifiedSql(this._specifiedSql);
        loopInfo.setParameterList(parameterList);
        loopInfo.setLoopSize(loopSize);
        loopInfo.setLikeSearchOption(valueAndType.getLikeSearchOption());
        for (int loopIndex = 0; loopIndex < loopSize; ++loopIndex) {
            loopInfo.setLoopIndex(loopIndex);
            this.processAcceptingChildren(ctx, loopInfo);
        }
        if (loopSize > 0) {
            ctx.setEnabled(true);
        }
    }

    protected void assertFirstNameAsNormal(CommandContext ctx, String firstName) {
        if (NodeUtil.isCurrentVariableOutOfScope(firstName, false)) {
            this.throwLoopCurrentVariableOutOfForCommentException();
        }
        if (NodeUtil.isWrongParameterBeanName(firstName, ctx)) {
            this.throwForCommentIllegalParameterBeanSpecificationException();
        }
    }

    protected void throwLoopCurrentVariableOutOfForCommentException() {
        NodeUtil.throwLoopCurrentVariableOutOfForCommentException(this._expression, this._specifiedSql);
    }

    protected void throwForCommentIllegalParameterBeanSpecificationException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The FOR comment had the illegal parameter-bean specification!");
        br.addItem("Advice");
        br.addElement("Please confirm your FOR comment.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    /*FOR pmb,memberId*/");
        br.addElement("    /*FOR p mb,memberId*/");
        br.addElement("    /*FOR pmb:memberId*/");
        br.addElement("    /*FOR pmb,memberId*/");
        br.addElement("  (o):");
        br.addElement("    /*FOR pmb.memberId*/");
        br.addItem("FOR Comment Expression");
        br.addElement(this._expression);
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new ForCommentIllegalParameterBeanSpecificationException(msg);
    }

    protected void setupValueAndType(ValueAndType valueAndType) {
        ValueAndTypeSetupper.CommentType type = ValueAndTypeSetupper.CommentType.FORCOMMENT;
        ValueAndTypeSetupper setuper = new ValueAndTypeSetupper(this._nameList, this._expression, this._specifiedSql, type);
        setuper.setupValueAndType(valueAndType);
    }

    protected void assertParameterList(Object targetValue) {
        if (!List.class.isInstance(targetValue)) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The parameter for FOR coment was not list.");
            br.addItem("FOR Comment Expression");
            br.addElement(this._expression);
            br.addItem("Parameter");
            br.addElement(targetValue.getClass());
            br.addElement(targetValue);
            br.addItem("Specified SQL");
            br.addElement(this._specifiedSql);
            String msg = br.buildExceptionMessage();
            throw new ForCommentParameterNotListException(msg);
        }
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._expression + "}";
    }

    public String getExpression() {
        return this._expression;
    }

    public static interface LoopVariableNodeFactory {
        public LoopAbstractNode create(String var1, String var2);
    }

    public static enum LoopVariableType {
        FIRST("first", new LoopVariableNodeFactory(){

            @Override
            public LoopAbstractNode create(String expression, String specifiedSql) {
                return new LoopFirstNode(expression, specifiedSql);
            }
        }),
        NEXT("next", new LoopVariableNodeFactory(){

            @Override
            public LoopAbstractNode create(String expression, String specifiedSql) {
                return new LoopNextNode(expression, specifiedSql);
            }
        }),
        LAST("last", new LoopVariableNodeFactory(){

            @Override
            public LoopAbstractNode create(String expression, String specifiedSql) {
                return new LoopLastNode(expression, specifiedSql);
            }
        });

        private static final Map<String, LoopVariableType> _codeValueMap;
        private String _code;
        private LoopVariableNodeFactory _factory;

        private LoopVariableType(String code, LoopVariableNodeFactory factory) {
            this._code = code;
            this._factory = factory;
        }

        public String code() {
            return this._code;
        }

        public static LoopVariableType codeOf(Object code) {
            if (code == null) {
                return null;
            }
            if (code instanceof LoopVariableType) {
                return (LoopVariableType)((Object)code);
            }
            return _codeValueMap.get(code.toString().toLowerCase());
        }

        public LoopAbstractNode createNode(String expression, String specifiedSql) {
            return this._factory.create(expression, specifiedSql);
        }

        static {
            _codeValueMap = new HashMap<String, LoopVariableType>();
            for (LoopVariableType value : LoopVariableType.values()) {
                _codeValueMap.put(value.code().toLowerCase(), value);
            }
        }
    }
}

