/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.basic;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.dbflute.util.DfTypeUtil;

public class IntegerType
extends TnAbstractValueType {
    public IntegerType() {
        super(4);
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return DfTypeUtil.toInteger(rs.getObject(index));
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return DfTypeUtil.toInteger(rs.getObject(columnName));
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return DfTypeUtil.toInteger(cs.getObject(index));
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return DfTypeUtil.toInteger(cs.getObject(parameterName));
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setInt(index, DfTypeUtil.toPrimitiveInt(value));
        }
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setInt(parameterName, DfTypeUtil.toPrimitiveInt(value));
        }
    }
}

