/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.mapstring;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.helper.mapstring.MapListString;
import org.seasar.dbflute.resource.DBFluteSystem;

public class MapListFile {
    private static final String UTF8_ENCODING = "UTF-8";
    protected final String _fileEncoding;
    protected final String _lineCommentMark;
    protected boolean _skipLineSeparator;

    public MapListFile() {
        this._fileEncoding = UTF8_ENCODING;
        this._lineCommentMark = "#";
    }

    public Map<String, Object> readMap(InputStream ins) {
        String mapString = this.readString(ins);
        if (mapString.trim().length() == 0) {
            return this.newLinkedHashMap();
        }
        MapListString mapListString = this.createMapListString();
        return mapListString.generateMap(mapString);
    }

    public Map<String, String> readMapAsStringValue(InputStream ins) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Map<String, Object> map = this.readMap(ins);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            resultMap.put(entry.getKey(), (String)entry.getValue());
        }
        return resultMap;
    }

    public Map<String, List<String>> readMapAsStringListValue(InputStream ins) {
        LinkedHashMap<String, List<String>> resultMap = this.newLinkedHashMap();
        Map<String, Object> map = this.readMap(ins);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            resultMap.put(entry.getKey(), (List)entry.getValue());
        }
        return resultMap;
    }

    public Map<String, Map<String, String>> readMapAsStringMapValue(InputStream ins) {
        LinkedHashMap<String, Map<String, String>> resultMap = this.newLinkedHashMap();
        Map<String, Object> map = this.readMap(ins);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            resultMap.put(entry.getKey(), (Map)entry.getValue());
        }
        return resultMap;
    }

    public void writeMap(OutputStream ous, Map<String, ? extends Object> map) {
        MapListString mapListString = this.createMapListString();
        String mapString = mapListString.buildMapString(map);
        this.writeString(ous, mapString);
    }

    public List<Object> readList(InputStream ins) {
        String listString = this.readString(ins);
        if (listString.trim().length() == 0) {
            return new ArrayList<Object>();
        }
        MapListString mapListString = this.createMapListString();
        return mapListString.generateList(listString);
    }

    public void writeList(OutputStream ous, List<Object> list) {
        MapListString mapListString = this.createMapListString();
        String listString = mapListString.buildListString(list);
        this.writeString(ous, listString);
    }

    public String readString(InputStream ins) {
        String encoding = this.getFileEncoding();
        String lineComment = this.getLineCommentMark();
        StringBuilder sb = new StringBuilder();
        boolean addLn = !this._skipLineSeparator;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            ir = new InputStreamReader(ins, encoding);
            br = new BufferedReader(ir);
            int loopIndex = -1;
            int validlineCount = -1;
            boolean previousLineComment = false;
            while (true) {
                ++loopIndex;
                String lineString = br.readLine();
                if (lineString == null) {
                    if (previousLineComment && addLn) {
                        sb.append(this.ln());
                    }
                    break;
                }
                if (loopIndex == 0) {
                    lineString = this.removeInitialUnicodeBomIfNeeds(encoding, lineString);
                }
                if (lineString.trim().startsWith(lineComment)) {
                    previousLineComment = true;
                    continue;
                }
                previousLineComment = false;
                if (++validlineCount > 0 && addLn) {
                    sb.append(this.ln());
                }
                sb.append(lineString);
            }
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        return sb.toString();
    }

    public void writeString(OutputStream ous, String mapListString) {
        String encoding = this.getFileEncoding();
        OutputStreamWriter ow = null;
        BufferedWriter bw = null;
        try {
            ow = new OutputStreamWriter(ous, encoding);
            bw = new BufferedWriter(ow);
            bw.write(this.removeInitialUnicodeBomIfNeeds(encoding, mapListString));
            bw.flush();
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public MapListFile skipLineSeparator() {
        this._skipLineSeparator = true;
        return this;
    }

    protected MapListString createMapListString() {
        return new MapListString();
    }

    protected String removeInitialUnicodeBomIfNeeds(String encoding, String value) {
        if (UTF8_ENCODING.equalsIgnoreCase(encoding) && value.length() > 0 && value.charAt(0) == '\ufeff') {
            value = value.substring(1);
        }
        return value;
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected String getFileEncoding() {
        return this._fileEncoding;
    }

    protected String getLineCommentMark() {
        return this._lineCommentMark;
    }
}

