/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.ManualOrderBean;
import org.seasar.dbflute.cbean.SimpleMapPmb;
import org.seasar.dbflute.cbean.chelper.HpDerivingSubQueryInfo;
import org.seasar.dbflute.cbean.chelper.HpFixedConditionQueryResolver;
import org.seasar.dbflute.cbean.chelper.HpInvalidQueryInfo;
import org.seasar.dbflute.cbean.chelper.HpQDRParameter;
import org.seasar.dbflute.cbean.chelper.HpSSQOption;
import org.seasar.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.ckey.ConditionKeyInScope;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.coption.DerivedReferrerOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.coption.ParameterOption;
import org.seasar.dbflute.cbean.coption.RangeOfOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.seasar.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.seasar.dbflute.cbean.sqlclause.clause.ClauseLazyReflector;
import org.seasar.dbflute.cbean.sqlclause.join.FixedConditionResolver;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByElement;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.cbean.sqlclause.query.QueryUsedAliasInfo;
import org.seasar.dbflute.cbean.sqlclause.subquery.ExistsReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.InScopeRelation;
import org.seasar.dbflute.cbean.sqlclause.subquery.QueryDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.ScalarCondition;
import org.seasar.dbflute.cbean.sqlclause.subquery.SpecifyDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.cbean.sqlclause.union.UnionClauseProvider;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.dbway.ExtensionOperand;
import org.seasar.dbflute.dbway.WayOfMySQL;
import org.seasar.dbflute.exception.ConditionInvokingFailureException;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.exception.OrScopeQueryAndPartUnsupportedOperationException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ParameterUtil;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

public abstract class AbstractConditionQuery
implements ConditionQuery {
    protected static final ConditionKey CK_EQ = ConditionKey.CK_EQUAL;
    protected static final ConditionKey CK_NES = ConditionKey.CK_NOT_EQUAL_STANDARD;
    protected static final ConditionKey CK_NET = ConditionKey.CK_NOT_EQUAL_TRADITION;
    protected static final ConditionKey CK_GT = ConditionKey.CK_GREATER_THAN;
    protected static final ConditionKey CK_LT = ConditionKey.CK_LESS_THAN;
    protected static final ConditionKey CK_GE = ConditionKey.CK_GREATER_EQUAL;
    protected static final ConditionKey CK_LE = ConditionKey.CK_LESS_EQUAL;
    protected static final ConditionKey CK_INS = ConditionKey.CK_IN_SCOPE;
    protected static final ConditionKey CK_NINS = ConditionKey.CK_NOT_IN_SCOPE;
    protected static final ConditionKey CK_LS = ConditionKey.CK_LIKE_SEARCH;
    protected static final ConditionKey CK_NLS = ConditionKey.CK_NOT_LIKE_SEARCH;
    protected static final ConditionKey CK_ISN = ConditionKey.CK_IS_NULL;
    protected static final ConditionKey CK_ISNOE = ConditionKey.CK_IS_NULL_OR_EMPTY;
    protected static final ConditionKey CK_ISNN = ConditionKey.CK_IS_NOT_NULL;
    protected static final Object DOBJ = new Object();
    protected static final String CQ_PROPERTY = "conditionQuery";
    protected final SqlClause _sqlClause;
    protected final String _aliasName;
    protected final int _nestLevel;
    protected int _subQueryLevel;
    protected ConditionBean _baseCB;
    protected String _foreignPropertyName;
    protected String _relationPath;
    protected final ConditionQuery _referrerQuery;
    protected boolean _inline;
    protected boolean _onClause;
    protected Map<String, ParameterOption> _parameterOptionMap;
    protected SimpleMapPmb<ConditionQuery> _unionQueryMap;
    protected SimpleMapPmb<ConditionQuery> _unionAllQueryMap;

    public AbstractConditionQuery(ConditionQuery referrerQuery, SqlClause sqlClause, String aliasName, int nestLevel) {
        this._referrerQuery = referrerQuery;
        this._sqlClause = sqlClause;
        this._aliasName = aliasName;
        this._nestLevel = nestLevel;
    }

    public void xsetBaseCB(ConditionBean baseCB) {
        this._baseCB = baseCB;
    }

    protected abstract DBMetaProvider xgetDBMetaProvider();

    protected DBMeta findDBMeta(String tableFlexibleName) {
        return this.xgetDBMetaProvider().provideDBMetaChecked(tableFlexibleName);
    }

    protected DBMeta xgetLocalDBMeta() {
        return this.findDBMeta(this.getTableDbName());
    }

    @Override
    public ConditionBean xgetBaseCB() {
        return this._baseCB;
    }

    @Override
    public ConditionQuery xgetBaseQuery() {
        ConditionQuery referrerQuery;
        ConditionQuery currentQuery = this;
        while ((referrerQuery = currentQuery.xgetReferrerQuery()) != null) {
            currentQuery = referrerQuery;
        }
        return currentQuery;
    }

    @Override
    public ConditionQuery xgetReferrerQuery() {
        return this._referrerQuery;
    }

    @Override
    public SqlClause xgetSqlClause() {
        return this._sqlClause;
    }

    @Override
    public String xgetAliasName() {
        return this._aliasName;
    }

    @Override
    public int xgetNestLevel() {
        return this._nestLevel;
    }

    @Override
    public int xgetNextNestLevel() {
        return this._nestLevel + 1;
    }

    @Override
    public boolean isBaseQuery() {
        return this.xgetReferrerQuery() == null;
    }

    @Override
    public ColumnRealName toColumnRealName(String columnDbName) {
        return ColumnRealName.create(this.xgetAliasName(), this.toColumnSqlName(columnDbName));
    }

    @Override
    public ColumnRealName toColumnRealName(ColumnInfo columnInfo) {
        return ColumnRealName.create(this.xgetAliasName(), columnInfo.getColumnSqlName());
    }

    @Override
    public ColumnSqlName toColumnSqlName(String columnDbName) {
        return this.xgetLocalDBMeta().findColumnInfo(columnDbName).getColumnSqlName();
    }

    @Override
    public String xgetForeignPropertyName() {
        return this._foreignPropertyName;
    }

    public void xsetForeignPropertyName(String foreignPropertyName) {
        this._foreignPropertyName = foreignPropertyName;
    }

    @Override
    public String xgetRelationPath() {
        return this._relationPath;
    }

    public void xsetRelationPath(String relationPath) {
        this._relationPath = relationPath;
    }

    public void xsetOnClause(boolean onClause) {
        this._onClause = onClause;
    }

    @Override
    public String xgetLocationBase() {
        StringBuilder sb = new StringBuilder();
        ConditionQuery query = this;
        while (true) {
            if (query.isBaseQuery()) break;
            String foreignPropertyName = query.xgetForeignPropertyName();
            if (foreignPropertyName == null) {
                String msg = "The foreignPropertyName of the query should not be null:";
                msg = msg + " query=" + query;
                throw new IllegalStateException(msg);
            }
            sb.insert(0, CQ_PROPERTY + this.initCap(foreignPropertyName) + ".");
            query = query.xgetReferrerQuery();
        }
        sb.insert(0, "conditionQuery.");
        return sb.toString();
    }

    protected String xgetLocation(String propertyName) {
        return this.xgetLocationBase() + propertyName;
    }

    public void doNss(NssCall callback) {
        String foreignPropertyName = callback.qf().xgetForeignPropertyName();
        String foreignTableAliasName = callback.qf().xgetAliasName();
        String localRelationPath = this.xgetRelationPath();
        String foreignRelationPath = callback.qf().xgetRelationPath();
        this.xgetSqlClause().registerSelectedRelation(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, localRelationPath, foreignRelationPath);
    }

    protected void registerOuterJoin(ConditionQuery foreignCQ, Map<String, String> joinOnResourceMap, String foreignPropertyName) {
        DBMeta dbmeta = this.xgetLocalDBMeta();
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        String fixedCondition = foreignInfo.getFixedCondition();
        boolean fixedInline = foreignInfo.isFixedInline();
        this.doRegisterOuterJoin(foreignCQ, joinOnResourceMap, foreignPropertyName, fixedCondition, fixedInline);
    }

    protected void doRegisterOuterJoin(ConditionQuery foreignCQ, Map<String, String> joinOnResourceMap, String foreignPropertyName, String fixedCondition, boolean fixedInline) {
        LinkedHashMap<ColumnRealName, ColumnRealName> joinOnMap = this.newLinkedHashMap();
        for (Map.Entry<String, String> entry : joinOnResourceMap.entrySet()) {
            String local = entry.getKey();
            String foreign = entry.getValue();
            joinOnMap.put(this.toColumnRealName(local), foreignCQ.toColumnRealName(foreign));
        }
        String foreignAlias = foreignCQ.xgetAliasName();
        String foreignTable = foreignCQ.getTableDbName();
        String localAlias = this.xgetAliasName();
        String localTable = this.getTableDbName();
        ForeignInfo foreignInfo = this.xgetLocalDBMeta().findForeignInfo(foreignPropertyName);
        FixedConditionResolver resolver = this.createForeignFixedConditionResolver(foreignCQ);
        if (fixedInline) {
            this.xgetSqlClause().registerOuterJoinFixedInline(foreignAlias, foreignTable, localAlias, localTable, joinOnMap, foreignInfo, fixedCondition, resolver);
        } else {
            this.xgetSqlClause().registerOuterJoin(foreignAlias, foreignTable, localAlias, localTable, joinOnMap, foreignInfo, fixedCondition, resolver);
        }
    }

    protected FixedConditionResolver createForeignFixedConditionResolver(ConditionQuery foreignCQ) {
        return new HpFixedConditionQueryResolver(this, foreignCQ, this.xgetDBMetaProvider());
    }

    public SimpleMapPmb<ConditionQuery> getInternalUnionQueryMap() {
        if (this._unionQueryMap == null) {
            this._unionQueryMap = this.xcreateUnionMapPmb();
        }
        return this._unionQueryMap;
    }

    public void xsetUnionQuery(ConditionQuery unionQuery) {
        this.xsetupUnion(unionQuery, false, this.getInternalUnionQueryMap());
    }

    public SimpleMapPmb<ConditionQuery> getInternalUnionAllQueryMap() {
        if (this._unionAllQueryMap == null) {
            this._unionAllQueryMap = this.xcreateUnionMapPmb();
        }
        return this._unionAllQueryMap;
    }

    protected SimpleMapPmb<ConditionQuery> xcreateUnionMapPmb() {
        return new SimpleMapPmb<ConditionQuery>();
    }

    public void xsetUnionAllQuery(ConditionQuery unionAllQuery) {
        this.xsetupUnion(unionAllQuery, true, this.getInternalUnionAllQueryMap());
    }

    protected void xsetupUnion(final ConditionQuery unionQuery, boolean unionAll, SimpleMapPmb<ConditionQuery> unionQueryMap) {
        if (unionQuery == null) {
            String msg = "The argument 'unionQuery' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        final AbstractConditionQuery selfCQ = this;
        this.xgetSqlClause().registerClauseLazyReflector(new ClauseLazyReflector(){

            @Override
            public void reflect() {
                AbstractConditionQuery.this.reflectRelationOnUnionQuery(selfCQ, unionQuery);
            }
        });
        String key = (unionAll ? "unionAllQuery" : "unionQuery") + unionQueryMap.size();
        unionQueryMap.addParameter(key, unionQuery);
        String propName = "internalUnion" + (unionAll ? "All" : "") + "QueryMap." + key;
        this.registerUnionQuery(unionQuery, unionAll, propName);
    }

    protected abstract void reflectRelationOnUnionQuery(ConditionQuery var1, ConditionQuery var2);

    public boolean hasUnionQueryOrUnionAllQuery() {
        return this._unionQueryMap != null && !this._unionQueryMap.isEmpty() || this._unionAllQueryMap != null && !this._unionAllQueryMap.isEmpty();
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQueryChecked(key, value, cvalue, columnDbName)) {
            return;
        }
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName);
    }

    protected void regQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        if (!this.isValidQueryChecked(key, value, cvalue, columnDbName)) {
            return;
        }
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, option);
    }

    protected boolean isValidQueryChecked(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        return this.xdoIsValidQuery(key, value, cvalue, columnDbName, true);
    }

    protected boolean isValidQueryNoCheck(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        return this.xdoIsValidQuery(key, value, cvalue, columnDbName, false);
    }

    protected boolean xdoIsValidQuery(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, boolean checked) {
        ColumnRealName callerName = this.toColumnRealName(columnDbName);
        if (key.isValidRegistration(this.xcreateQueryModeProvider(), cvalue, value, callerName)) {
            return true;
        }
        if (checked) {
            this.handleInvalidQuery(key, value, columnDbName);
        }
        return false;
    }

    protected void handleInvalidQuery(ConditionKey key, Object value, String columnDbName) {
        HpInvalidQueryInfo invalidQueryInfo = this.xcreateInvalidQueryInfo(key, value, columnDbName);
        this.xdoHandleInvalidQuery(columnDbName, invalidQueryInfo);
    }

    protected void handleInvalidQueryList(List<ConditionKey> keyList, List<? extends Object> valueList, String columnDbName) {
        if (keyList.size() != valueList.size()) {
            String msg = "The argument 'keyList' should have the same size as 'valueList'";
            throw new IllegalArgumentException(msg);
        }
        HpInvalidQueryInfo[] invalidQueryInfoAry = new HpInvalidQueryInfo[keyList.size()];
        int index = 0;
        for (ConditionKey key : keyList) {
            Object value = valueList.get(index);
            invalidQueryInfoAry[index] = this.xcreateInvalidQueryInfo(key, value, columnDbName);
            ++index;
        }
        this.xdoHandleInvalidQuery(columnDbName, invalidQueryInfoAry);
    }

    protected void xdoHandleInvalidQuery(String columnDbName, HpInvalidQueryInfo ... invalidQueryInfoAry) {
        if (this.xgetSqlClause().isInvalidQueryChecked()) {
            this.throwInvalidQueryRegisteredException(invalidQueryInfoAry);
        } else {
            for (HpInvalidQueryInfo invalidQueryInfo : invalidQueryInfoAry) {
                this.xgetSqlClause().saveInvalidQuery(invalidQueryInfo);
            }
        }
    }

    protected HpInvalidQueryInfo xcreateInvalidQueryInfo(ConditionKey key, Object value, String columnDbName) {
        String locationBase = this.xgetLocationBase();
        ColumnInfo targetColumn = this.xgetLocalDBMeta().findColumnInfo(columnDbName);
        HpInvalidQueryInfo invalidQueryInfo = new HpInvalidQueryInfo(locationBase, targetColumn, key, value);
        if (this._inline) {
            invalidQueryInfo.inlineView();
        } else if (this._onClause) {
            invalidQueryInfo.onClause();
        }
        return invalidQueryInfo;
    }

    protected ConditionValue.QueryModeProvider xcreateQueryModeProvider() {
        return new ConditionValue.QueryModeProvider(){

            @Override
            public boolean isOrScopeQuery() {
                return AbstractConditionQuery.this.xgetSqlClause().isOrScopeQueryEffective();
            }

            @Override
            public boolean isInline() {
                return AbstractConditionQuery.this._inline;
            }

            @Override
            public boolean isOnClause() {
                return AbstractConditionQuery.this._onClause;
            }
        };
    }

    protected void throwInvalidQueryRegisteredException(HpInvalidQueryInfo ... invalidQueryInfoAry) {
        this.createCBExThrower().throwInvalidQueryRegisteredException(invalidQueryInfoAry);
    }

    protected void regLSQ(ConditionKey key, String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        this.registerLikeSearchQuery(key, value, cvalue, columnDbName, option);
    }

    protected void registerLikeSearchQuery(ConditionKey key, String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        if (option == null) {
            this.throwLikeSearchOptionNotFoundException(columnDbName, value);
            return;
        }
        if (!this.isValidQueryChecked(key, value, cvalue, columnDbName)) {
            return;
        }
        if (this.xsuppressEscape()) {
            option.notEscape();
        }
        this.xgetSqlClause().adjustLikeSearchDBWay(option);
        if (value == null || !option.isSplit()) {
            if (option.canOptimizeCompoundColumnLikePrefix()) {
                this.doRegisterLikeSearchQueryCompoundOptimized(value, cvalue, columnDbName, option);
            } else {
                this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, option);
            }
            return;
        }
        this.doRegisterLikeSearchQuerySplitBy(key, value, cvalue, columnDbName, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegisterLikeSearchQueryCompoundOptimized(String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        if (!option.isLikePrefix()) {
            String msg = "This optimization is only for LikePrefix: " + option;
            throw new IllegalStateException(msg);
        }
        List<HpSpecifiedColumn> compoundColumnList = option.getCompoundColumnList();
        List<Integer> sizeList = option.getCompoundColumnSizeList();
        String currentValue = value;
        int currentLength = value.length();
        String currentColumn = columnDbName;
        boolean needsAndPart = this.isOrScopeQueryDirectlyUnder();
        if (needsAndPart) {
            this.xgetSqlClause().beginOrScopeQueryAndPart();
        }
        try {
            boolean shortLengthBreak = false;
            Iterator<HpSpecifiedColumn> compoundColumnIterator = compoundColumnList.iterator();
            for (Integer columnSize : sizeList) {
                if (currentLength >= columnSize) {
                    String equalValue = currentValue.substring(0, columnSize);
                    this.invokeQueryEqual(currentColumn, equalValue);
                    currentValue = currentValue.substring(columnSize);
                    currentLength = currentValue.length();
                    if (compoundColumnIterator.hasNext()) {
                        HpSpecifiedColumn specifiedColumn = compoundColumnIterator.next();
                        currentColumn = specifiedColumn.getColumnDbName();
                        continue;
                    }
                    currentColumn = null;
                    break;
                }
                shortLengthBreak = true;
                break;
            }
            if (currentValue.length() > 0 && currentColumn != null) {
                LikeSearchOption copyOption = option.createDeepCopy();
                copyOption.clearCompoundColumn();
                if (!shortLengthBreak) {
                    while (compoundColumnIterator.hasNext()) {
                        copyOption.addCompoundColumn(compoundColumnIterator.next());
                    }
                }
                this.invokeQueryLikeSearch(currentColumn, currentValue, copyOption);
            }
        }
        finally {
            if (needsAndPart) {
                this.xgetSqlClause().endOrScopeQueryAndPart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegisterLikeSearchQuerySplitBy(ConditionKey key, String value, ConditionValue cvalue, String columnDbName, LikeSearchOption option) {
        boolean needsNewOrScope;
        this.assertObjectNotNull("option(LikeSearchOption)", option);
        String[] strArray = option.generateSplitValueArray(value);
        if (strArray.length == 0) {
            this.handleInvalidQuery(key, value, columnDbName);
            return;
        }
        if (!option.isAsOrSplit()) {
            boolean needsAndPart = this.isOrScopeQueryDirectlyUnder();
            if (needsAndPart) {
                this.xgetSqlClause().beginOrScopeQueryAndPart();
            }
            try {
                for (int i = 0; i < strArray.length; ++i) {
                    String currentValue = strArray[i];
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName, option);
                }
            }
            finally {
                if (needsAndPart) {
                    this.xgetSqlClause().endOrScopeQueryAndPart();
                }
            }
        }
        if (this.isOrScopeQueryAndPartEffective()) {
            String msg = "The AsOrSplit in and-part is unsupported: " + this.getTableDbName();
            throw new OrScopeQueryAndPartUnsupportedOperationException(msg);
        }
        boolean bl = needsNewOrScope = !this.isOrScopeQueryEffective();
        if (needsNewOrScope) {
            this.xgetSqlClause().makeOrScopeQueryEffective();
        }
        try {
            for (int i = 0; i < strArray.length; ++i) {
                String currentValue = strArray[i];
                if (i == 0) {
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName, option);
                    continue;
                }
                this.invokeQueryLikeSearch(columnDbName, currentValue, option);
            }
        }
        finally {
            if (needsNewOrScope) {
                this.xgetSqlClause().closeOrScopeQuery();
            }
        }
    }

    protected void throwLikeSearchOptionNotFoundException(String columnDbName, String value) {
        DBMeta dbmeta = this.xgetDBMetaProvider().provideDBMeta(this.getTableDbName());
        this.createCBExThrower().throwLikeSearchOptionNotFoundException(columnDbName, value, dbmeta);
    }

    protected boolean xsuppressEscape() {
        return false;
    }

    protected void invokeQueryLikeSearch(String columnFlexibleName, Object value, LikeSearchOption option) {
        this.invokeQuery(columnFlexibleName, "likeSearch", value, option);
    }

    protected boolean isOrScopeQueryDirectlyUnder() {
        boolean orScopeQuery = this.isOrScopeQueryEffective();
        boolean orScopeQueryAndPart = this.isOrScopeQueryAndPartEffective();
        return orScopeQuery && !orScopeQueryAndPart;
    }

    protected boolean isOrScopeQueryEffective() {
        return this.xgetSqlClause().isOrScopeQueryEffective();
    }

    protected boolean isOrScopeQueryAndPartEffective() {
        return this.xgetSqlClause().isOrScopeQueryAndPartEffective();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regFTQ(Date fromDate, Date toDate, ConditionValue cvalue, String columnDbName, FromToOption option) {
        boolean needsAndPart;
        this.assertObjectNotNull("option(FromToOption)", option);
        Date filteredFromDate = option.filterFromDate(fromDate);
        ConditionKey fromKey = option.getFromDateConditionKey();
        boolean fromValidQuery = this.isValidQueryNoCheck(fromKey, filteredFromDate, cvalue, columnDbName);
        Date filteredToDate = option.filterToDate(toDate);
        ConditionKey toKey = option.getToDateConditionKey();
        boolean toValidQuery = this.isValidQueryNoCheck(toKey, filteredToDate, cvalue, columnDbName);
        boolean bl = needsAndPart = this.isOrScopeQueryDirectlyUnder() && fromValidQuery && toValidQuery;
        if (needsAndPart) {
            this.xgetSqlClause().beginOrScopeQueryAndPart();
        }
        try {
            if (fromValidQuery) {
                this.setupConditionValueAndRegisterWhereClause(fromKey, filteredFromDate, cvalue, columnDbName);
            }
            if (toValidQuery) {
                this.setupConditionValueAndRegisterWhereClause(toKey, filteredToDate, cvalue, columnDbName);
            } else if (!fromValidQuery) {
                List<ConditionKey> keyList = this.newArrayList(fromKey, toKey);
                List<Date> valueList = this.newArrayList(fromDate, toDate);
                this.handleInvalidQueryList(keyList, valueList, columnDbName);
            }
        }
        finally {
            if (needsAndPart) {
                this.xgetSqlClause().endOrScopeQueryAndPart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regROO(Number minNumber, Number maxNumber, ConditionValue cvalue, String columnDbName, RangeOfOption option) {
        boolean needsAndPart;
        this.assertObjectNotNull("option(RangeOfOption)", option);
        if (option.hasCalculationRange()) {
            ConditionBean dreamCruiseCB = this._baseCB.xcreateDreamCruiseCB();
            option.xinitCalculationRange(this._baseCB, dreamCruiseCB);
        }
        ConditionKey minKey = option.getMinNumberConditionKey();
        boolean minValidQuery = this.isValidQueryNoCheck(minKey, minNumber, cvalue, columnDbName);
        ConditionKey maxKey = option.getMaxNumberConditionKey();
        boolean maxValidQuery = this.isValidQueryNoCheck(maxKey, maxNumber, cvalue, columnDbName);
        boolean bl = needsAndPart = this.isOrScopeQueryDirectlyUnder() && minValidQuery && maxValidQuery;
        if (needsAndPart) {
            this.xgetSqlClause().beginOrScopeQueryAndPart();
        }
        try {
            if (minValidQuery) {
                this.setupConditionValueAndRegisterWhereClause(minKey, minNumber, cvalue, columnDbName, option);
            }
            if (maxValidQuery) {
                this.setupConditionValueAndRegisterWhereClause(maxKey, maxNumber, cvalue, columnDbName, option);
            } else if (!minValidQuery) {
                List<ConditionKey> keyList = this.newArrayList(minKey, maxKey);
                List<Number> valueList = this.newArrayList(minNumber, maxNumber);
                this.handleInvalidQueryList(keyList, valueList, columnDbName);
            }
        }
        finally {
            if (needsAndPart) {
                this.xgetSqlClause().endOrScopeQueryAndPart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regINS(ConditionKey key, List<?> value, ConditionValue cvalue, String columnDbName) {
        if (!this.isValidQueryChecked(key, value, cvalue, columnDbName)) {
            return;
        }
        int inScopeLimit = this.xgetSqlClause().getInScopeLimit();
        if (inScopeLimit > 0 && value.size() > inScopeLimit) {
            boolean needsAndPart;
            boolean orScopeQuery = this.xgetSqlClause().isOrScopeQueryEffective();
            boolean orScopeQueryAndPart = this.xgetSqlClause().isOrScopeQueryAndPartEffective();
            boolean bl = needsAndPart = orScopeQuery && !orScopeQueryAndPart;
            if (AbstractConditionQuery.isConditionKeyInScope(key)) {
                this.xgetSqlClause().makeOrScopeQueryEffective();
            } else if (needsAndPart) {
                this.xgetSqlClause().beginOrScopeQueryAndPart();
            }
            try {
                List<?> objectList = value;
                List<List<?>> valueList = DfCollectionUtil.splitByLimit(objectList, inScopeLimit);
                for (int i = 0; i < valueList.size(); ++i) {
                    List<?> currentValue = valueList.get(i);
                    if (i == 0) {
                        this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, columnDbName);
                        continue;
                    }
                    this.invokeQuery(columnDbName, key.getConditionKey(), currentValue);
                }
            }
            finally {
                if (AbstractConditionQuery.isConditionKeyInScope(key)) {
                    this.xgetSqlClause().closeOrScopeQuery();
                } else if (needsAndPart) {
                    this.xgetSqlClause().endOrScopeQueryAndPart();
                }
            }
        } else {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName);
        }
    }

    static boolean isConditionKeyInScope(ConditionKey key) {
        return ConditionKeyInScope.class.isAssignableFrom(key.getClass());
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        this.doRegIQ(key, value, cvalue, columnDbName, null);
    }

    protected void regIQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        this.doRegIQ(key, value, cvalue, columnDbName, option);
    }

    protected void doRegIQ(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        if (!this.isValidQueryChecked(key, value, cvalue, columnDbName)) {
            return;
        }
        DBMeta dbmeta = this.xgetDBMetaProvider().provideDBMetaChecked(this.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        String location = this.xgetLocation(uncapPropName);
        key.setupConditionValue(this.xcreateQueryModeProvider(), cvalue, value, location, option);
        ColumnSqlName columnSqlName = columnInfo.getColumnSqlName();
        ColumnFunctionCipher cipher = this.xgetSqlClause().findColumnFunctionCipher(columnInfo);
        if (this.isBaseQuery()) {
            this.xgetSqlClause().registerBaseTableInlineWhereClause(columnSqlName, key, cvalue, cipher, option);
        } else {
            String aliasName = this.xgetAliasName();
            this.xgetSqlClause().registerOuterJoinInlineWhereClause(aliasName, columnSqlName, key, cvalue, cipher, option, this._onClause);
        }
    }

    protected void registerExistsReferrer(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName) {
        this.registerExistsReferrer(subQuery, columnDbName, relatedColumnDbName, propertyName, referrerPropertyName, false);
    }

    protected void registerNotExistsReferrer(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName) {
        this.registerExistsReferrer(subQuery, columnDbName, relatedColumnDbName, propertyName, referrerPropertyName, true);
    }

    protected void registerExistsReferrer(final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName, boolean notExists) {
        this.assertSubQueryNotNull("ExistsReferrer", relatedColumnDbName, subQuery);
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            @Override
            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        GearedCipherManager cipherManager = this.xgetSqlClause().getGearedCipherManager();
        ExistsReferrer existsReferrer = new ExistsReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager);
        String correlatedFixedCondition = this.xbuildReferrerCorrelatedFixedCondition(subQuery, referrerPropertyName);
        String existsOption = notExists ? "not" : null;
        String clause = existsReferrer.buildExistsReferrer(columnDbName, relatedColumnDbName, correlatedFixedCondition, existsOption);
        boolean noWayInner = notExists;
        this.registerWhereClause(clause, noWayInner);
    }

    protected String xbuildReferrerCorrelatedFixedCondition(ConditionQuery subQuery, String referrerPropertyName) {
        if (referrerPropertyName == null) {
            return null;
        }
        DBMeta localDBMeta = this.xgetLocalDBMeta();
        if (!localDBMeta.hasReferrer(referrerPropertyName)) {
            return null;
        }
        ReferrerInfo referrerInfo = localDBMeta.findReferrerInfo(referrerPropertyName);
        return this.xdoBuildReferrerCorrelatedFixedCondition(subQuery, referrerInfo);
    }

    protected String xdoBuildReferrerCorrelatedFixedCondition(ConditionQuery subQuery, ReferrerInfo referrerInfo) {
        RelationInfo reverseRelation = referrerInfo.getReverseRelation();
        if (reverseRelation == null) {
            return null;
        }
        if (!(reverseRelation instanceof ForeignInfo)) {
            String msg = "The reverse relation (referrer's reverse) should be foreign info: " + referrerInfo;
            throw new IllegalStateException(msg);
        }
        ForeignInfo foreignInfo = (ForeignInfo)reverseRelation;
        String fixedCondition = foreignInfo.getFixedCondition();
        if (fixedCondition == null || fixedCondition.trim().length() == 0) {
            return null;
        }
        FixedConditionResolver resolver = this.createReferrerFixedConditionResolver(subQuery);
        return resolver.resolveVariable(fixedCondition, false);
    }

    protected FixedConditionResolver createReferrerFixedConditionResolver(ConditionQuery referrerCQ) {
        return new HpFixedConditionQueryResolver(referrerCQ, this, this.xgetDBMetaProvider());
    }

    protected void registerInScopeRelation(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String relationPropertyName) {
        this.registerInScopeRelation(subQuery, columnDbName, relatedColumnDbName, propertyName, relationPropertyName, null);
    }

    protected void registerNotInScopeRelation(ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String relationPropertyName) {
        this.registerInScopeRelation(subQuery, columnDbName, relatedColumnDbName, propertyName, relationPropertyName, "not");
    }

    protected void registerInScopeRelation(final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String relationPropertyName, String inScopeOption) {
        this.assertSubQueryNotNull("InScopeRelation", columnDbName, subQuery);
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            @Override
            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        GearedCipherManager cipherManager = this.xgetSqlClause().getGearedCipherManager();
        boolean suppressLocalAliasName = this.isInScopeRelationSuppressLocalAliasName();
        InScopeRelation inScopeRelation = new InScopeRelation(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, suppressLocalAliasName);
        String correlatedFixedCondition = this.xbuildForeignCorrelatedFixedCondition(subQuery, relationPropertyName);
        String clause = inScopeRelation.buildInScopeRelation(columnDbName, relatedColumnDbName, correlatedFixedCondition, inScopeOption);
        this.registerWhereClause(clause);
    }

    protected boolean isInScopeRelationSuppressLocalAliasName() {
        return false;
    }

    protected String xbuildForeignCorrelatedFixedCondition(ConditionQuery subQuery, String relationPropertyName) {
        if (relationPropertyName == null) {
            return null;
        }
        DBMeta localDBMeta = this.xgetLocalDBMeta();
        RelationInfo relationInfo = localDBMeta.findRelationInfo(relationPropertyName);
        if (!relationInfo.isReferrer()) {
            return null;
        }
        if (!(relationInfo instanceof ReferrerInfo)) {
            return null;
        }
        ReferrerInfo referrerInfo = (ReferrerInfo)relationInfo;
        return this.xdoBuildReferrerCorrelatedFixedCondition(subQuery, referrerInfo);
    }

    protected void registerSpecifyDerivedReferrer(String function, ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName, String aliasName, DerivedReferrerOption option) {
        this.doRegisterSpecifyDerivedReferrer(function, subQuery, columnDbName, relatedColumnDbName, propertyName, referrerPropertyName, aliasName, option != null ? option : new DerivedReferrerOption());
    }

    protected void doRegisterSpecifyDerivedReferrer(String function, final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName, String aliasName, DerivedReferrerOption option) {
        this.assertFunctionNotNull("SpecifyDerivedReferrer", columnDbName, function);
        this.assertSubQueryNotNull("SpecifyDerivedReferrer", columnDbName, subQuery);
        option.xacceptBaseCB(this._baseCB);
        if (this.isDerivedReferrerSelectAllPossible(subQuery, option)) {
            this.createCBExThrower().throwSpecifyDerivedReferrerSelectAllPossibleException(function, subQuery, aliasName);
        }
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            @Override
            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        GearedCipherManager cipherManager = this.xgetSqlClause().getGearedCipherManager();
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        SpecifyDerivedReferrer derivedReferrer = option.createSpecifyDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity, aliasName);
        this.xregisterParameterOption(option);
        String correlatedFixedCondition = this.xbuildReferrerCorrelatedFixedCondition(subQuery, referrerPropertyName);
        String clause = derivedReferrer.buildDerivedReferrer(function, columnDbName, relatedColumnDbName, correlatedFixedCondition, option);
        HpDerivingSubQueryInfo subQueryInfo = new HpDerivingSubQueryInfo(aliasName, clause, derivedReferrer);
        this.xgetSqlClause().specifyDerivingSubQuery(subQueryInfo);
    }

    protected boolean isDerivedReferrerSelectAllPossible(ConditionQuery subQuery, DerivedReferrerOption option) {
        return option.isSuppressCorrelation() && subQuery.xgetBaseCB().hasSelectAllPossible();
    }

    protected void registerSpecifyMyselfDerived(String function, ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName, String aliasName, DerivedReferrerOption option) {
        this.doRegisterSpecifyDerivedReferrer(function, subQuery, columnDbName, relatedColumnDbName, propertyName, referrerPropertyName, aliasName, this.resolveMyselfDerivedReferrerOption(option));
    }

    protected DerivedReferrerOption resolveMyselfDerivedReferrerOption(DerivedReferrerOption option) {
        DerivedReferrerOption resolvedOption = option != null ? option : new DerivedReferrerOption();
        resolvedOption.suppressCorrelation();
        return resolvedOption;
    }

    protected void registerQueryDerivedReferrer(String function, ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName, String operand, Object value, String parameterPropertyName, DerivedReferrerOption option) {
        this.doRegisterQueryDerivedReferrer(function, subQuery, columnDbName, relatedColumnDbName, propertyName, referrerPropertyName, operand, value, parameterPropertyName, option != null ? option : new DerivedReferrerOption());
    }

    protected void doRegisterQueryDerivedReferrer(String function, final ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName, String operand, Object value, String parameterPropertyName, DerivedReferrerOption option) {
        this.assertFunctionNotNull("QueryDerivedReferrer", columnDbName, function);
        this.assertSubQueryNotNull("QueryDerivedReferrer", columnDbName, subQuery);
        option.xacceptBaseCB(this._baseCB);
        if (this.isDerivedReferrerSelectAllPossible(subQuery, option)) {
            this.createCBExThrower().throwQueryDerivedReferrerSelectAllPossibleException(function, subQuery);
        }
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            @Override
            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        GearedCipherManager cipherManager = this.xgetSqlClause().getGearedCipherManager();
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        String parameterPath = this.xgetLocation(parameterPropertyName);
        QueryDerivedReferrer derivedReferrer = option.createQueryDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity, operand, value, parameterPath);
        this.xregisterParameterOption(option);
        String correlatedFixedCondition = this.xbuildReferrerCorrelatedFixedCondition(subQuery, referrerPropertyName);
        String clause = derivedReferrer.buildDerivedReferrer(function, columnDbName, relatedColumnDbName, correlatedFixedCondition, option);
        boolean noWayInner = HpQDRParameter.isOperandIsNull(operand) || option.mayNullRevived();
        this.registerWhereClause(clause, noWayInner);
    }

    protected void registerQueryMyselfDerived(String function, ConditionQuery subQuery, String columnDbName, String relatedColumnDbName, String propertyName, String referrerPropertyName, String operand, Object value, String parameterPropertyName, DerivedReferrerOption option) {
        this.doRegisterQueryDerivedReferrer(function, subQuery, columnDbName, relatedColumnDbName, propertyName, referrerPropertyName, operand, value, parameterPropertyName, this.resolveMyselfDerivedReferrerOption(option));
    }

    protected <CB extends ConditionBean> void registerScalarCondition(final String function, final ConditionQuery subQuery, String propertyName, String operand, final HpSSQOption<CB> option) {
        this.assertSubQueryNotNull("ScalarCondition", propertyName, subQuery);
        SubQueryPath subQueryPath = new SubQueryPath(this.xgetLocation(propertyName));
        GeneralColumnRealNameProvider localRealNameProvider = new GeneralColumnRealNameProvider();
        int subQueryLevel = subQuery.xgetSqlClause().getSubQueryLevel();
        SqlClause subQueryClause = subQuery.xgetSqlClause();
        String subQueryIdentity = propertyName + "[" + subQueryLevel + "]";
        ColumnSqlNameProvider subQuerySqlNameProvider = new ColumnSqlNameProvider(){

            @Override
            public ColumnSqlName provide(String columnDbName) {
                return subQuery.toColumnSqlName(columnDbName);
            }
        };
        DBMeta subQueryDBMeta = this.findDBMeta(subQuery.getTableDbName());
        GearedCipherManager cipherManager = this.xgetSqlClause().getGearedCipherManager();
        String mainSubQueryIdentity = propertyName + "[" + subQueryLevel + ":subquerymain]";
        ScalarCondition.PartitionByProvider partitionByProvider = new ScalarCondition.PartitionByProvider(){

            @Override
            public SqlClause provideSqlClause() {
                return option.preparePartitionBySqlClause();
            }
        };
        final ScalarCondition scalarCondition = new ScalarCondition(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity, operand, partitionByProvider);
        QueryClause clause = new QueryClause(){

            @Override
            public String toString() {
                return scalarCondition.buildScalarCondition(function);
            }
        };
        QueryUsedAliasInfo usedAliasInfo = new QueryUsedAliasInfo(this.xgetAliasName(), null);
        this.registerWhereClause(clause, usedAliasInfo);
    }

    protected void registerMyselfExists(ConditionQuery subQuery, String subQueryPropertyName) {
        String relatedColumnDbName;
        subQuery.xgetSqlClause().getSpecifiedColumnInfoAsOne();
        String specifiedDbName = subQuery.xgetSqlClause().getSpecifiedColumnDbNameAsOne();
        if (specifiedDbName != null) {
            relatedColumnDbName = specifiedDbName;
        } else {
            UniqueInfo primaryUniqueInfo = this.findDBMeta(subQuery.getTableDbName()).getPrimaryUniqueInfo();
            ColumnInfo primaryColumnInfo = primaryUniqueInfo.getFirstColumn();
            relatedColumnDbName = primaryColumnInfo.getColumnDbName();
        }
        this.registerExistsReferrer(subQuery, relatedColumnDbName, relatedColumnDbName, subQueryPropertyName, null);
    }

    protected void registerMyselfInScope(ConditionQuery subQuery, String subQueryPropertyName) {
        String relatedColumnDbName;
        String specifiedDbName = subQuery.xgetSqlClause().getSpecifiedColumnDbNameAsOne();
        if (specifiedDbName != null) {
            relatedColumnDbName = specifiedDbName;
        } else {
            UniqueInfo primaryUniqueInfo = this.findDBMeta(subQuery.getTableDbName()).getPrimaryUniqueInfo();
            ColumnInfo primaryColumnInfo = primaryUniqueInfo.getFirstColumn();
            relatedColumnDbName = primaryColumnInfo.getColumnDbName();
        }
        this.registerInScopeRelation(subQuery, relatedColumnDbName, relatedColumnDbName, subQueryPropertyName, null);
    }

    protected void assertSubQueryNotNull(String title, String columnDbName, ConditionQuery subQuery) {
        if (subQuery == null) {
            String msg = "The condition-query for the sub-query should not be null:";
            msg = msg + " " + title + "(" + columnDbName + ")";
            throw new IllegalStateException(msg);
        }
    }

    protected void assertFunctionNotNull(String title, String columnDbName, String function) {
        if (function == null) {
            String msg = "The function for the sub-query should not be null:";
            msg = msg + " " + title + "(" + columnDbName + ")";
            throw new IllegalStateException(msg);
        }
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        ConditionOption embeddedOption = this.createEmbeddedOption(key, value, cvalue, columnDbName);
        this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, columnDbName, embeddedOption);
    }

    protected ConditionOption createEmbeddedOption(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName) {
        return null;
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String columnDbName, ConditionOption option) {
        DBMeta dbmeta = this.xgetLocalDBMeta();
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        String propertyName = columnInfo.getPropertyName();
        String uncapPropName = this.initUncap(propertyName);
        String location = this.xgetLocation(uncapPropName);
        key.setupConditionValue(this.xcreateQueryModeProvider(), cvalue, value, location, option);
        ColumnRealName columnRealName = this.toColumnRealName(columnDbName);
        ColumnFunctionCipher cipher = this.xgetSqlClause().findColumnFunctionCipher(columnInfo);
        String usedAliasName = this.xgetAliasName();
        this.xgetSqlClause().registerWhereClause(columnRealName, key, cvalue, cipher, option, usedAliasName);
    }

    protected void registerWhereClause(String whereClause) {
        this.registerWhereClause(whereClause, false);
    }

    protected void registerWhereClause(String whereClause, boolean noWayInner) {
        String usedAliasName = this.xgetAliasName();
        this.xgetSqlClause().registerWhereClause(whereClause, usedAliasName, noWayInner);
    }

    protected void registerWhereClause(QueryClause whereClause, QueryUsedAliasInfo ... usedAliasInfos) {
        this.xgetSqlClause().registerWhereClause(whereClause, usedAliasInfos);
    }

    protected void registerInlineWhereClause(String whereClause) {
        if (this.isBaseQuery()) {
            this.xgetSqlClause().registerBaseTableInlineWhereClause(whereClause);
        } else {
            this.xgetSqlClause().registerOuterJoinInlineWhereClause(this.xgetAliasName(), whereClause, this._onClause);
        }
    }

    protected void registerUnionQuery(final ConditionQuery unionQuery, boolean unionAll, final String unionQueryPropertyName) {
        this.xgetSqlClause().registerUnionQuery(new UnionClauseProvider(){

            @Override
            public String provide() {
                return AbstractConditionQuery.this.xgetUnionQuerySql(unionQuery, unionQueryPropertyName);
            }
        }, unionAll);
    }

    protected String xgetUnionQuerySql(ConditionQuery unionQuery, String unionQueryPropertyName) {
        String unionQueryClause;
        String fromClause = unionQuery.xgetSqlClause().getFromClause();
        String whereClause = unionQuery.xgetSqlClause().getWhereClause();
        if (whereClause.trim().length() <= 0) {
            unionQueryClause = fromClause + " " + this.xgetSqlClause().getUnionWhereClauseMark();
        } else {
            int whereIndex = whereClause.indexOf("where ");
            if (whereIndex < 0) {
                String msg = "The whereClause should have 'where' string: " + whereClause;
                throw new IllegalStateException(msg);
            }
            int clauseIndex = whereIndex + "where ".length();
            String front = whereClause.substring(0, clauseIndex);
            String mark = this.xgetSqlClause().getUnionWhereFirstConditionMark();
            String rear = whereClause.substring(clauseIndex);
            String markedClause = front + mark + rear;
            unionQueryClause = fromClause + " " + markedClause;
        }
        String oldStr = "/*pmb.conditionQuery.";
        String newStr = "/*pmb.conditionQuery." + unionQueryPropertyName + ".";
        return this.replaceString(unionQueryClause, "/*pmb.conditionQuery.", newStr);
    }

    public void innerJoin() {
        if (this.isBaseQuery()) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The method 'innerJoin()' should be called for a relation query.");
            br.addItem("Advice");
            br.addElement("Please confirm your program.");
            br.addElement("For example:");
            br.addElement("  (x) - cb.query().innerJoin();");
            br.addElement("  (o) - cb.query().queryMemberStatus().innerJoin();");
            br.addItem("Base Table");
            br.addElement(this.getTableDbName());
            String msg = br.buildExceptionMessage();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this.xgetSqlClause().changeToInnerJoin(this.xgetAliasName());
    }

    protected void registerOrderBy(String columnDbName, boolean ascOrDesc) {
        DBMeta dbmeta = this.xgetLocalDBMeta();
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnDbName);
        ColumnRealName columnRealName = this.toColumnRealName(columnInfo);
        this.xgetSqlClause().registerOrderBy(columnRealName.toString(), ascOrDesc, columnInfo);
    }

    protected void regOBA(String columnDbName) {
        this.assertOrderByPurpose(columnDbName);
        this.registerOrderBy(columnDbName, true);
    }

    protected void regOBD(String columnDbName) {
        this.assertOrderByPurpose(columnDbName);
        this.registerOrderBy(columnDbName, false);
    }

    protected void assertOrderByPurpose(String columnDbName) {
        if (this.xgetSqlClause().getPurpose().isNoOrderBy()) {
            this.throwOrderByIllegalPurposeException(columnDbName);
        }
    }

    protected void throwOrderByIllegalPurposeException(String columnDbName) {
        this.createCBExThrower().throwOrderByIllegalPurposeException(this.xgetSqlClause().getPurpose(), this.getTableDbName(), columnDbName);
    }

    public void withNullsFirst() {
        this.xgetSqlClause().addNullsFirstToPreviousOrderBy();
    }

    public void withNullsLast() {
        this.xgetSqlClause().addNullsLastToPreviousOrderBy();
    }

    public void withManualOrder(List<? extends Object> orderValueList) {
        this.assertObjectNotNull("withManualOrder(orderValueList)", orderValueList);
        ManualOrderBean manualOrderBean = new ManualOrderBean();
        manualOrderBean.acceptOrderValueList(orderValueList);
        this.withManualOrder(manualOrderBean);
    }

    public void withManualOrder(ManualOrderBean manualOrderBean) {
        this.assertObjectNotNull("withManualOrder(manualOrderBean)", manualOrderBean);
        manualOrderBean.bind(new ManualOrderBean.FreeParameterManualOrderThemeListHandler(){

            @Override
            public String register(String themeKey, Object orderValue) {
                return AbstractConditionQuery.this.xregisterManualOrderParameterToThemeList(themeKey, orderValue);
            }
        });
        if (manualOrderBean.hasCalculationOrder()) {
            ConditionBean dreamCruiseCB = this._baseCB.xcreateDreamCruiseCB();
            dreamCruiseCB.overTheWaves(this.xcreateManualOrderSpecifiedColumn(dreamCruiseCB));
            manualOrderBean.xinitCalculationOrder(this._baseCB, dreamCruiseCB);
        }
        manualOrderBean.validate();
        this.xgetSqlClause().addManualOrderToPreviousOrderByElement(manualOrderBean);
    }

    protected HpSpecifiedColumn xcreateManualOrderSpecifiedColumn(ConditionBean dreamCruiseCB) {
        OrderByElement orderByLastElement = this.xgetSqlClause().getOrderByLastElement();
        String aliasName = orderByLastElement.getAliasName();
        String columnName = orderByLastElement.getColumnName();
        ColumnInfo columnInfo = orderByLastElement.getColumnInfo();
        boolean derived = orderByLastElement.isDerivedOrderBy();
        return new HpSpecifiedColumn(aliasName, columnInfo, dreamCruiseCB, columnName, derived);
    }

    protected void registerSpecifiedDerivedOrderBy_Asc(String aliasName) {
        if (!this.xgetSqlClause().hasSpecifiedDerivingSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.xgetSqlClause().registerSpecifiedDerivedOrderBy(aliasName, true);
    }

    protected void registerSpecifiedDerivedOrderBy_Desc(String aliasName) {
        if (!this.xgetSqlClause().hasSpecifiedDerivingSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.xgetSqlClause().registerSpecifiedDerivedOrderBy(aliasName, false);
    }

    protected void throwSpecifiedDerivedOrderByAliasNameNotFoundException(String aliasName) {
        this.createCBExThrower().throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
    }

    protected String resolveJoinAliasName(String relationPath, int nestLevel) {
        return this.xgetSqlClause().resolveJoinAliasName(relationPath, nestLevel);
    }

    protected String resolveNextRelationPath(String localTableName, String foreignPropertyName) {
        int relationNo = this.xgetSqlClause().resolveRelationNo(localTableName, foreignPropertyName);
        String nextRelationPath = "_" + relationNo;
        if (this._relationPath != null) {
            nextRelationPath = this._relationPath + nextRelationPath;
        }
        return nextRelationPath;
    }

    @Override
    public ConditionValue invokeValue(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        DBMeta dbmeta = this.xgetLocalDBMeta();
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(columnFlexibleName));
        String methodName = "get" + columnCapPropName;
        Method method = this.xhelpGettingCQMethod(this, methodName, new Class[0]);
        if (method == null) {
            this.throwConditionInvokingGetMethodNotFoundException(columnFlexibleName, methodName);
            return null;
        }
        try {
            return (ConditionValue)this.xhelpInvokingCQMethod(this, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingGetReflectionFailureException(columnFlexibleName, methodName, e);
            return null;
        }
    }

    protected void throwConditionInvokingGetMethodNotFoundException(String columnFlexibleName, String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the method for getting the condition.");
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("methodName");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg);
    }

    protected void throwConditionInvokingGetReflectionFailureException(String columnFlexibleName, String methodName, DfReflectionUtil.ReflectionFailureException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to invoke the method for getting value.");
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("methodName");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg, e);
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object conditionValue) {
        this.doInvokeQuery(columnFlexibleName, conditionKeyName, conditionValue, null);
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption) {
        this.assertObjectNotNull("conditionOption", conditionOption);
        this.doInvokeQuery(columnFlexibleName, conditionKeyName, conditionValue, conditionOption);
    }

    protected void doInvokeQuery(String colName, String ckey, Object value, ConditionOption option) {
        Class[] parameterTypes;
        Method method;
        ColumnInfo columnInfo;
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", colName);
        this.assertStringNotNullAndNotTrimmedEmpty("conditionKeyName", ckey);
        if (value == null) {
            return;
        }
        PropertyNameCQContainer container = this.xhelpExtractingPropertyNameCQContainer(colName);
        String flexibleName = container.getFlexibleName();
        ConditionQuery cq = container.getConditionQuery();
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        try {
            columnInfo = dbmeta.findColumnInfo(flexibleName);
        }
        catch (RuntimeException e) {
            this.throwConditionInvokingColumnFindFailureException(colName, ckey, value, option, e);
            return;
        }
        String columnCapPropName = this.initCap(columnInfo.getPropertyName());
        boolean noArg = Srl.equalsIgnoreCase(ckey, "IsNull", "IsNotNull", "IsNullOrEmpty", "EmptyString");
        boolean rangeOf = Srl.equalsIgnoreCase(ckey, "RangeOf");
        boolean fromTo = Srl.equalsIgnoreCase(ckey, "FromTo", "DateFromTo");
        if (!noArg) {
            try {
                value = columnInfo.toPropretyType(value);
            }
            catch (RuntimeException e) {
                this.throwConditionInvokingValueConvertFailureException(colName, ckey, value, option, e);
            }
        }
        String methodName = "set" + columnCapPropName + "_" + this.initCap(ckey);
        ArrayList typeList = this.newArrayList();
        if (fromTo) {
            typeList.add(Date.class);
            typeList.add(Date.class);
        } else if (rangeOf) {
            Class<?> propertyType = columnInfo.getPropertyType();
            typeList.add(propertyType);
            typeList.add(propertyType);
        } else if (!noArg) {
            typeList.add(value.getClass());
        }
        if (option != null) {
            typeList.add(option.getClass());
        }
        if ((method = this.xhelpGettingCQMethod(cq, methodName, parameterTypes = typeList.toArray(new Class[0]))) == null) {
            this.throwConditionInvokingSetMethodNotFoundException(colName, ckey, value, option, methodName, parameterTypes);
        }
        try {
            ArrayList argList = this.newArrayList();
            if (fromTo || rangeOf) {
                if (!(value instanceof List)) {
                    this.throwConditionInvokingDateFromToValueInvalidException(colName, ckey, value, option, methodName, parameterTypes);
                }
                argList.addAll((List)value);
            } else if (!noArg) {
                argList.add(value);
            }
            if (option != null) {
                argList.add(option);
            }
            this.xhelpInvokingCQMethod(cq, method, argList.toArray());
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingSetReflectionFailureException(colName, ckey, value, option, methodName, parameterTypes, e);
        }
    }

    protected void throwConditionInvokingColumnFindFailureException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, RuntimeException cause) {
        String notice = "Failed to find the column in the table.";
        this.doThrowConditionInvokingFailureException("Failed to find the column in the table.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, null, null, cause);
    }

    protected void throwConditionInvokingValueConvertFailureException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, RuntimeException cause) {
        String notice = "Failed to convert the value to property type.";
        this.doThrowConditionInvokingFailureException("Failed to convert the value to property type.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, null, null, cause);
    }

    protected void throwConditionInvokingSetMethodNotFoundException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] parameterTypes) {
        String notice = "Not found the method for setting the condition.";
        this.doThrowConditionInvokingFailureException("Not found the method for setting the condition.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, methodName, parameterTypes, null);
    }

    protected void throwConditionInvokingDateFromToValueInvalidException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] parameterTypes) {
        String notice = "The conditionValue should be List that has 2 elements, fromDate and toDate.";
        this.doThrowConditionInvokingFailureException("The conditionValue should be List that has 2 elements, fromDate and toDate.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, methodName, parameterTypes, null);
    }

    protected void throwConditionInvokingSetReflectionFailureException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] parameterTypes, DfReflectionUtil.ReflectionFailureException cause) {
        String notice = "Failed to invoke the method for setting the condition.";
        this.doThrowConditionInvokingFailureException("Failed to invoke the method for setting the condition.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, methodName, parameterTypes, cause);
    }

    protected void doThrowConditionInvokingFailureException(String notice, String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] parameterTypes, RuntimeException cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("conditionKeyName");
        br.addElement(conditionKeyName);
        br.addItem("conditionValue");
        br.addElement(conditionValue);
        br.addItem("conditionOption");
        br.addElement(conditionOption);
        if (methodName != null) {
            StringBuilder sb = new StringBuilder();
            if (parameterTypes != null) {
                int index = 0;
                for (Class<?> parameterType : parameterTypes) {
                    if (index > 0) {
                        sb.append(", ");
                    }
                    sb.append(DfTypeUtil.toClassTitle(parameterType));
                    ++index;
                }
            }
            br.addItem("Method");
            br.addElement(methodName + "(" + sb.toString() + ")");
        }
        String msg = br.buildExceptionMessage();
        if (cause != null) {
            throw new ConditionInvokingFailureException(msg, cause);
        }
        throw new ConditionInvokingFailureException(msg);
    }

    @Override
    public void invokeQueryEqual(String columnFlexibleName, Object value) {
        this.invokeQuery(columnFlexibleName, CK_EQ.getConditionKey(), value);
    }

    @Override
    public void invokeOrderBy(String columnFlexibleName, boolean isAsc) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        PropertyNameCQContainer container = this.xhelpExtractingPropertyNameCQContainer(columnFlexibleName);
        String flexibleName = container.getFlexibleName();
        ConditionQuery cq = container.getConditionQuery();
        String ascDesc = isAsc ? "Asc" : "Desc";
        DBMeta dbmeta = this.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(flexibleName));
        String methodName = "addOrderBy_" + columnCapPropName + "_" + ascDesc;
        Method method = this.xhelpGettingCQMethod(cq, methodName, new Class[0]);
        if (method == null) {
            this.throwConditionInvokingOrderMethodNotFoundException(columnFlexibleName, isAsc, methodName);
        }
        this.xhelpInvokingCQMethod(cq, method, new Object[0]);
        try {
            this.xhelpInvokingCQMethod(cq, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingOrderReflectionFailureException(columnFlexibleName, isAsc, methodName, e);
        }
    }

    protected void throwConditionInvokingOrderMethodNotFoundException(String columnFlexibleName, boolean isAsc, String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the method for adding the order-by condition.");
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("isAsc");
        br.addElement(isAsc);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg);
    }

    protected void throwConditionInvokingOrderReflectionFailureException(String columnFlexibleName, boolean isAsc, String methodName, DfReflectionUtil.ReflectionFailureException cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to invoke the method for setting the order-by condition.");
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("isAsc");
        br.addElement(isAsc);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg, cause);
    }

    @Override
    public ConditionQuery invokeForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        List<String> splitList = Srl.splitList(foreignPropertyName, ".");
        ConditionQuery foreignCQ = this;
        for (String elementName : splitList) {
            foreignCQ = this.doInvokeForeignCQ(foreignCQ, elementName);
        }
        return foreignCQ;
    }

    protected ConditionQuery doInvokeForeignCQ(ConditionQuery cq, String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "query" + this.initCap(foreignPropertyName);
        Method method = this.xhelpGettingCQMethod(cq, methodName, new Class[0]);
        if (method == null) {
            this.throwConditionInvokingForeignQueryMethodNotFoundException(cq, foreignPropertyName, methodName);
            return null;
        }
        try {
            return (ConditionQuery)this.xhelpInvokingCQMethod(cq, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingForeignQueryReflectionFailureException(cq, foreignPropertyName, methodName, e);
            return null;
        }
    }

    protected void throwConditionInvokingForeignQueryMethodNotFoundException(ConditionQuery cq, String foreignPropertyName, String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the method for getting a foreign condition query.");
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem("foreignPropertyName");
        br.addElement(foreignPropertyName);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg);
    }

    protected void throwConditionInvokingForeignQueryReflectionFailureException(ConditionQuery cq, String foreignPropertyName, String methodName, DfReflectionUtil.ReflectionFailureException cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to invoke the method for setting a condition(query).");
        br.addItem("Table");
        br.addElement(this.getTableDbName());
        br.addItem("foreignPropertyName");
        br.addElement(foreignPropertyName);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg, cause);
    }

    @Override
    public boolean invokeHasForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        List<String> splitList = Srl.splitList(foreignPropertyName, ".");
        ConditionQuery foreignCQ = this;
        int splitLength = splitList.size();
        int index = 0;
        for (String elementName : splitList) {
            if (!this.doInvokeHasForeignCQ(foreignCQ, elementName)) {
                return false;
            }
            if (index + 1 < splitLength) {
                foreignCQ = foreignCQ.invokeForeignCQ(elementName);
            }
            ++index;
        }
        return true;
    }

    protected boolean doInvokeHasForeignCQ(ConditionQuery cq, String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "hasConditionQuery" + this.initCap(foreignPropertyName);
        Method method = this.xhelpGettingCQMethod(cq, methodName, new Class[0]);
        if (method == null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the method for determining a foreign condition query.");
            br.addItem("Table");
            br.addElement(cq.getTableDbName());
            br.addItem("foreignPropertyName");
            br.addElement(foreignPropertyName);
            br.addItem("methodName");
            br.addElement(methodName);
            br.addItem("ConditionQuery");
            br.addElement(DfTypeUtil.toClassTitle(cq));
            String msg = br.buildExceptionMessage();
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            return (Boolean)this.xhelpInvokingCQMethod(cq, method, new Object[0]);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for determining a condition(query):";
            msg = msg + " foreignPropertyName=" + foreignPropertyName;
            msg = msg + " methodName=" + methodName + " table=" + this.getTableDbName();
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    protected PropertyNameCQContainer xhelpExtractingPropertyNameCQContainer(String name) {
        String[] strings = name.split("\\.");
        int length = strings.length;
        String propertyName = null;
        ConditionQuery cq = this;
        int index = 0;
        for (String element : strings) {
            if (length == index + 1) {
                propertyName = element;
                break;
            }
            cq = cq.invokeForeignCQ(element);
            ++index;
        }
        return new PropertyNameCQContainer(propertyName, cq);
    }

    protected Method xhelpGettingCQMethod(ConditionQuery cq, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getAccessibleMethodFlexibly(cq.getClass(), methodName, argTypes);
    }

    protected Object xhelpInvokingCQMethod(ConditionQuery cq, Method method, Object[] args) {
        return DfReflectionUtil.invokeForcedly(method, cq, args);
    }

    protected ConditionValue nCV() {
        return this.newConditionValue();
    }

    protected ConditionValue newConditionValue() {
        return new ConditionValue();
    }

    protected String fRES(String value) {
        return this.filterRemoveEmptyString(value);
    }

    protected String filterRemoveEmptyString(String value) {
        if (this.isEmptyStringQueryAllowed()) {
            return value;
        }
        return value != null && !"".equals(value) ? value : null;
    }

    protected boolean isEmptyStringQueryAllowed() {
        return this.xgetSqlClause().isEmptyStringQueryAllowed();
    }

    protected Date fCTPD(Date date) {
        return this.filterConvertToPureDate(date);
    }

    protected Date filterConvertToPureDate(Date date) {
        return DfTypeUtil.toDate(date);
    }

    protected LikeSearchOption cLSOP() {
        return new LikeSearchOption().likePrefix();
    }

    protected <PROPERTY extends Number> PROPERTY cTNum(Object obj, Class<PROPERTY> type) {
        return (PROPERTY)DfTypeUtil.toNumber(obj, type);
    }

    protected <PROPERTY> List<PROPERTY> cTL(Collection<PROPERTY> col) {
        return this.xconvertToList(col);
    }

    protected List<String> cTStrL(Collection<? extends Classification> col) {
        if (col == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Classification classification : col) {
            if (classification == null) continue;
            list.add(classification.code());
        }
        return list;
    }

    protected <PROPERTY extends Number> List<PROPERTY> cTNumL(Collection<? extends Classification> col, Class<PROPERTY> type) {
        if (col == null) {
            return null;
        }
        ArrayList<Number> list = new ArrayList<Number>();
        for (Classification classification : col) {
            if (classification == null) continue;
            Number value = DfTypeUtil.toNumber(classification.code(), type);
            list.add(value);
        }
        return list;
    }

    protected <PROPERTY> List<PROPERTY> xconvertToList(Collection<PROPERTY> col) {
        if (col == null) {
            return null;
        }
        if (col instanceof List) {
            return this.xfilterRemoveNullOrEmptyValueFromList((List)col);
        }
        return this.xfilterRemoveNullOrEmptyValueFromList(new ArrayList<PROPERTY>(col));
    }

    protected <PROPERTY_TYPE> List<PROPERTY_TYPE> xfilterRemoveNullOrEmptyValueFromList(List<PROPERTY_TYPE> ls) {
        if (ls == null) {
            return null;
        }
        ArrayList<PROPERTY_TYPE> newList = new ArrayList<PROPERTY_TYPE>();
        for (PROPERTY_TYPE element : ls) {
            if (element == null || element instanceof String && ((String)element).length() == 0) continue;
            newList.add(element);
        }
        return newList;
    }

    protected String hSC(String columnName, String value, Integer size, String modeCode) {
        ParameterUtil.ShortCharHandlingMode mode = ParameterUtil.ShortCharHandlingMode.codeOf(modeCode);
        if (mode == null) {
            String msg = "The mode was not found by the code: ";
            msg = msg + " columnName=" + columnName + " modeCode=" + modeCode;
            throw new IllegalStateException(msg);
        }
        return ParameterUtil.handleShortChar(columnName, value, size, mode);
    }

    protected void xdoMatchForMySQL(List<ColumnInfo> textColumnList, String conditionValue, WayOfMySQL.FullTextSearchModifier modifier) {
        if (conditionValue == null || conditionValue.length() == 0) {
            return;
        }
        String clause = ((SqlClauseMySql)this.xgetSqlClause()).buildMatchCondition(textColumnList, conditionValue, modifier, this.getTableDbName(), this.xgetAliasName());
        this.registerWhereClause(clause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xdoMatchByLikeSearch(List<ColumnInfo> textColumnList, String conditionValue) {
        if (conditionValue == null || conditionValue.length() == 0) {
            return;
        }
        this.assertObjectNotNull("textColumnList", textColumnList);
        if (textColumnList.isEmpty()) {
            String msg = "The argument 'textColumnList' should not be empty list.";
            throw new IllegalArgumentException(msg);
        }
        conditionValue = this.xescapeFullTextSearchValue(conditionValue);
        this.xgetSqlClause().makeOrScopeQueryEffective();
        try {
            for (ColumnInfo columnInfo : textColumnList) {
                if (columnInfo == null) continue;
                String tableOfColumn = columnInfo.getDBMeta().getTableDbName();
                if (!tableOfColumn.equalsIgnoreCase(this.getTableDbName())) {
                    String msg = "The table of the text column should be '" + this.getTableDbName() + "'";
                    msg = msg + " but the table is '" + tableOfColumn + "': column=" + columnInfo;
                    throw new IllegalArgumentException(msg);
                }
                if (!columnInfo.isPropertyTypeString()) {
                    String msg = "The text column should be String type:";
                    msg = msg + " column=" + columnInfo;
                    throw new IllegalArgumentException(msg);
                }
                this.invokeQueryLikeSearch(columnInfo.getColumnDbName(), conditionValue, this.xcreateMatchLikeSearch());
            }
        }
        finally {
            this.xgetSqlClause().closeOrScopeQuery();
        }
    }

    protected String xescapeFullTextSearchValue(String conditionValue) {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected String xescapeOracleFullTextSearchValue(String conditionValue) {
        return ((SqlClauseOracle)this.xgetSqlClause()).escapeFullTextSearchValue(conditionValue);
    }

    protected LikeSearchOption xcreateMatchLikeSearch() {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected LikeSearchOption xcreatePostgreSQLMatchLikeSearch() {
        return new PostgreSQLMatchLikeSearch();
    }

    protected ExtensionOperand xgetPostgreSQLMatchOperand() {
        String msg = "You should override this method.";
        throw new UnsupportedOperationException(msg);
    }

    protected LikeSearchOption xcreateOracleMatchLikeSearch() {
        return new OracleMatchLikeSearch();
    }

    public Map<String, Object> getColQyCBMap() {
        return this.xgetSqlClause().getColumnQueryObjectMap();
    }

    protected String xregisterColumyQueryObjectToThemeList(String themeKey, Object addedValue) {
        return this.xgetSqlClause().registerColumnQueryObjectToThemeList(themeKey, addedValue);
    }

    public Map<String, Object> getMnuOdrPrmMap() {
        return this.xgetSqlClause().getManualOrderParameterMap();
    }

    protected String xregisterManualOrderParameterToThemeList(String themeKey, Object addedValue) {
        return this.xgetSqlClause().registerManualOrderParameterToThemeList(themeKey, addedValue);
    }

    public Map<String, Object> getFreePrmMap() {
        return this.xgetSqlClause().getFreeParameterMap();
    }

    public String xregisterFreeParameterToThemeList(String themeKey, Object addedValue) {
        return this.xgetSqlClause().registerFreeParameterToThemeList(themeKey, addedValue);
    }

    @Override
    public void xregisterParameterOption(ParameterOption option) {
        if (option == null) {
            return;
        }
        if (this._parameterOptionMap == null) {
            this._parameterOptionMap = this.newHashMap();
        }
        String parameterKey = "option" + this._parameterOptionMap.size();
        this._parameterOptionMap.put(parameterKey, option);
        String parameterMapPath = this.xgetLocationBase() + "optionParameterMap";
        option.acceptParameterKey(parameterKey, parameterMapPath);
    }

    public Map<String, ParameterOption> getOptionParameterMap() {
        return this._parameterOptionMap;
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return DfCollectionUtil.newHashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return DfCollectionUtil.newLinkedHashMap();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return DfCollectionUtil.newArrayList();
    }

    protected <ELEMENT> List<ELEMENT> newArrayList(ELEMENT ... elements) {
        return DfCollectionUtil.newArrayList(elements);
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> collection) {
        return DfCollectionUtil.newArrayList(collection);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertColumnName(String columnName) {
        if (columnName == null) {
            String msg = "The columnName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.trim().length() == 0) {
            String msg = "The columnName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.indexOf(",") >= 0) {
            String msg = "The columnName should not contain comma ',': " + columnName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertAliasName(String aliasName) {
        if (aliasName == null) {
            String msg = "The aliasName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.trim().length() == 0) {
            String msg = "The aliasName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.indexOf(",") >= 0) {
            String msg = "The aliasName should not contain comma ',': " + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public String toString() {
        String titleName = DfTypeUtil.toClassTitle(this);
        return titleName + ":{aliasName=" + this._aliasName + ", nestLevel=" + this._nestLevel + ", subQueryLevel=" + this._subQueryLevel + ", foreignPropertyName=" + this._foreignPropertyName + ", relationPath=" + this._relationPath + ", onClauseInline=" + this._onClause + "}";
    }

    public class OracleMatchLikeSearch
    extends LikeSearchOption {
        @Override
        public QueryClauseArranger getWhereClauseArranger() {
            return ((SqlClauseOracle)AbstractConditionQuery.this.xgetSqlClause()).createFullTextSearchClauseArranger();
        }
    }

    public class PostgreSQLMatchLikeSearch
    extends LikeSearchOption {
        @Override
        public ExtensionOperand getExtensionOperand() {
            return AbstractConditionQuery.this.xgetPostgreSQLMatchOperand();
        }
    }

    protected static class PropertyNameCQContainer {
        protected String _flexibleName;
        protected ConditionQuery _cq;

        public PropertyNameCQContainer(String flexibleName, ConditionQuery cq) {
            this._flexibleName = flexibleName;
            this._cq = cq;
        }

        public String getFlexibleName() {
            return this._flexibleName;
        }

        public ConditionQuery getConditionQuery() {
            return this._cq;
        }
    }

    protected class GeneralColumnRealNameProvider
    implements ColumnRealNameProvider {
        protected GeneralColumnRealNameProvider() {
        }

        @Override
        public ColumnRealName provide(String columnDbName) {
            return AbstractConditionQuery.this.toColumnRealName(columnDbName);
        }
    }

    public static interface NssCall {
        public ConditionQuery qf();
    }
}

