/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.execution;

import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.bhv.SqlStringFilter;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.execution.AbstractFixedArgExecution;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicParameterHandler;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;
import org.seasar.dbflute.twowaysql.node.Node;

public class SelectCBExecution
extends AbstractFixedArgExecution {
    protected final TnResultSetHandler _resultSetHandler;

    public SelectCBExecution(DataSource dataSource, StatementFactory statementFactory, Map<String, Class<?>> argNameTypeMap, TnResultSetHandler resultSetHandler) {
        super(dataSource, statementFactory, argNameTypeMap);
        this.assertObjectNotNull("resultSetHandler", resultSetHandler);
        this._resultSetHandler = resultSetHandler;
    }

    @Override
    protected Node getRootNode(Object[] args) {
        return this.analyzeTwoWaySql(this.extractTwoWaySql(args));
    }

    protected String extractTwoWaySql(Object[] args) {
        this.assertArgsValid(args);
        Object firstElement = args[0];
        this.assertObjectNotNull("args[0]", firstElement);
        this.assertFirstElementConditionBean(firstElement);
        ConditionBean cb = (ConditionBean)firstElement;
        return cb.getSqlClause().getClause();
    }

    protected void assertArgsValid(Object[] args) {
        if (args == null) {
            String msg = "The argument 'args' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (args.length == 0) {
            String msg = "The argument 'args' should not be empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertFirstElementConditionBean(Object firstElement) {
        if (!(firstElement instanceof ConditionBean)) {
            String msg = "The first element of 'args' should be condition-bean: " + firstElement.getClass();
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    protected TnBasicParameterHandler newBasicParameterHandler(String executedSql) {
        return new TnBasicSelectHandler(this._dataSource, executedSql, this._resultSetHandler, this._statementFactory);
    }

    @Override
    protected String filterExecutedSql(String executedSql) {
        return this.doFilterExecutedSqlByCallbackFilter(super.filterExecutedSql(executedSql));
    }

    protected String doFilterExecutedSqlByCallbackFilter(String executedSql) {
        SqlStringFilter sqlStringFilter = this.getSqlStringFilter();
        if (sqlStringFilter != null) {
            BehaviorCommand<?> meta = ResourceContext.behaviorCommand();
            String filteredSql = sqlStringFilter.filterSelectCB(meta, executedSql);
            return filteredSql != null ? filteredSql : executedSql;
        }
        return executedSql;
    }

    protected SqlStringFilter getSqlStringFilter() {
        if (!CallbackContext.isExistSqlStringFilterOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlStringFilter();
    }

    @Override
    protected boolean isBlockNullParameter() {
        return true;
    }
}

