/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;

public class PatternTokenizerFactory
extends TokenizerFactory {
    public static final String PATTERN = "pattern";
    public static final String GROUP = "group";
    protected Pattern pattern;
    protected int group;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.pattern = this.getPattern(PATTERN);
        this.group = -1;
        String g = args.get(GROUP);
        if (g != null) {
            this.group = Integer.parseInt(g);
        }
    }

    @Override
    public Tokenizer create(Reader in) {
        try {
            return new PatternTokenizer(in, this.pattern, this.group);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException thrown creating PatternTokenizer instance", ex);
        }
    }
}

