/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closeables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.InputSupplier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.OutputSupplier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public final class Files {
    public static BufferedReader newReader(File file, Charset charset) {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedWriter newWriter(File file, Charset charset) {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static InputSupplier newInputStreamSupplier(File file) {
        Preconditions.checkNotNull(file);
        return new Files$1(file);
    }

    public static OutputSupplier newOutputStreamSupplier(File file) {
        return Files.newOutputStreamSupplier(file, false);
    }

    public static OutputSupplier newOutputStreamSupplier(File file, boolean bl) {
        Preconditions.checkNotNull(file);
        return new Files$2(file, bl);
    }

    public static OutputSupplier newWriterSupplier(File file, Charset charset, boolean bl) {
        return CharStreams.newWriterSupplier(Files.newOutputStreamSupplier(file, bl), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) {
        Preconditions.checkArgument(file.length() <= Integer.MAX_VALUE);
        if (file.length() == 0L) {
            return ByteStreams.toByteArray(Files.newInputStreamSupplier(file));
        }
        byte[] byArray = new byte[(int)file.length()];
        boolean bl = true;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ByteStreams.readFully(fileInputStream, byArray);
            bl = false;
        }
        finally {
            Closeables.close(fileInputStream, bl);
        }
        return byArray;
    }

    public static String toString(File file, Charset charset) {
        return new String(Files.toByteArray(file), charset.name());
    }

    public static void write(byte[] byArray, File file) {
        ByteStreams.write(byArray, Files.newOutputStreamSupplier(file));
    }

    public static void copy(File file, OutputSupplier outputSupplier) {
        ByteStreams.copy(Files.newInputStreamSupplier(file), outputSupplier);
    }

    public static void write(CharSequence charSequence, File file, Charset charset) {
        Files.write(charSequence, file, charset, false);
    }

    private static void write(CharSequence charSequence, File file, Charset charset, boolean bl) {
        CharStreams.write(charSequence, Files.newWriterSupplier(file, charset, bl));
    }

    public static void createParentDirs(File file) {
        File file2 = file.getCanonicalFile().getParentFile();
        if (file2 == null) {
            return;
        }
        file2.mkdirs();
        if (!file2.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }

    @Deprecated
    public static void deleteDirectoryContents(File file) {
        Preconditions.checkArgument(file.isDirectory(), "Not a directory: %s", file);
        if (!file.getCanonicalPath().equals(file.getAbsolutePath())) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Error listing files for " + file);
        }
        for (File file2 : fileArray) {
            Files.deleteRecursively(file2);
        }
    }

    @Deprecated
    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            Files.deleteDirectoryContents(file);
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }
}

