/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class EventHandler {
    private final Object target;
    private final Method method;

    EventHandler(Object object, Method method) {
        Preconditions.checkNotNull(object, "EventHandler target cannot be null.");
        Preconditions.checkNotNull(method, "EventHandler method cannot be null.");
        this.target = object;
        this.method = method;
        method.setAccessible(true);
    }

    public void handleEvent(Object object) {
        try {
            this.method.invoke(this.target, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("Method rejected target/argument: " + object, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Method became inaccessible: " + object, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            throw invocationTargetException;
        }
    }

    public String toString() {
        return "[wrapper " + this.method + "]";
    }

    public int hashCode() {
        int n = 31;
        return (31 + this.method.hashCode()) * 31 + this.target.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventHandler eventHandler = (EventHandler)object;
        return this.method.equals(eventHandler.method) && this.target == eventHandler.target;
    }
}

