/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.Cache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multimaps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SetMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AnnotatedHandlerFinder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.DeadEvent;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$4;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$EventWithHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.HandlerFindingStrategy;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventBus {
    private final SetMultimap handlersByType = Multimaps.newSetMultimap(new ConcurrentHashMap(), new EventBus$1(this));
    private final Logger logger;
    private final HandlerFindingStrategy finder = new AnnotatedHandlerFinder();
    private final ThreadLocal eventsToDispatch = new EventBus$2(this);
    private final ThreadLocal isDispatching = new EventBus$3(this);
    private Cache flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new EventBus$4(this));

    public EventBus() {
        this("default");
    }

    public EventBus(String string) {
        this.logger = Logger.getLogger(EventBus.class.getName() + "." + string);
    }

    public void register(Object object) {
        this.handlersByType.putAll(this.finder.findAllHandlers(object));
    }

    public void post(Object object) {
        Set set = this.flattenHierarchy(object.getClass());
        boolean bl = false;
        for (Class clazz : set) {
            Set set2 = this.getHandlersForEventType(clazz);
            if (set2 == null || set2.isEmpty()) continue;
            bl = true;
            for (EventHandler eventHandler : set2) {
                this.enqueueEvent(object, eventHandler);
            }
        }
        if (!bl && !(object instanceof DeadEvent)) {
            this.post(new DeadEvent(this, object));
        }
        this.dispatchQueuedEvents();
    }

    protected void enqueueEvent(Object object, EventHandler eventHandler) {
        ((ConcurrentLinkedQueue)this.eventsToDispatch.get()).offer(new EventBus$EventWithHandler(object, eventHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchQueuedEvents() {
        if (((Boolean)this.isDispatching.get()).booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventBus$EventWithHandler eventBus$EventWithHandler;
            while ((eventBus$EventWithHandler = (EventBus$EventWithHandler)((ConcurrentLinkedQueue)this.eventsToDispatch.get()).poll()) != null) {
                this.dispatch(eventBus$EventWithHandler.event, eventBus$EventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.set(false);
        }
    }

    protected void dispatch(Object object, EventHandler eventHandler) {
        try {
            eventHandler.handleEvent(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logger.log(Level.SEVERE, "Could not dispatch event: " + object + " to handler " + eventHandler, invocationTargetException);
        }
    }

    Set getHandlersForEventType(Class clazz) {
        return this.handlersByType.get(clazz);
    }

    Set flattenHierarchy(Class clazz) {
        try {
            return (Set)this.flattenHierarchyCache.get(clazz);
        }
        catch (ExecutionException executionException) {
            throw Throwables.propagate(executionException.getCause());
        }
    }
}

