/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$1;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public final class Maps {
    static final Joiner.MapJoiner STANDARD_JOINER = Collections2.STANDARD_JOINER.withKeyValueSeparator("=");

    public static HashMap newHashMap() {
        return new HashMap();
    }

    public static HashMap newHashMapWithExpectedSize(int n) {
        return new HashMap(Maps.capacity(n));
    }

    static int capacity(int n) {
        if (n < 3) {
            Preconditions.checkArgument(n >= 0);
            return n + 1;
        }
        if (n < 0x40000000) {
            return n + n / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static TreeMap newTreeMap() {
        return new TreeMap();
    }

    public static EnumMap newEnumMap(Class clazz) {
        return new EnumMap((Class)Preconditions.checkNotNull(clazz));
    }

    public static IdentityHashMap newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static Map.Entry immutableEntry(@Nullable Object object, @Nullable Object object2) {
        return new ImmutableEntry(object, object2);
    }

    static Map.Entry unmodifiableEntry(Map.Entry entry) {
        Preconditions.checkNotNull(entry);
        return new Maps$1(entry);
    }

    static Object safeGet(Map map, Object object) {
        try {
            return map.get(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    static boolean safeContainsKey(Map map, Object object) {
        try {
            return map.containsKey(object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    static boolean containsEntryImpl(Collection collection, Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        return collection.contains(Maps.unmodifiableEntry((Map.Entry)object));
    }
}

