/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMapBasedMultiset$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMapBasedMultiset$MapBasedElementSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMapBasedMultiset$MapBasedMultisetIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMultiset;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Count;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMapBasedMultiset
extends AbstractMultiset
implements Serializable {
    private transient Map backingMap;
    private transient long size;

    protected AbstractMapBasedMultiset(Map map) {
        this.backingMap = (Map)Preconditions.checkNotNull(map);
        this.size = super.size();
    }

    public Set entrySet() {
        return super.entrySet();
    }

    Iterator entryIterator() {
        Iterator iterator = this.backingMap.entrySet().iterator();
        return new AbstractMapBasedMultiset$1(this, iterator);
    }

    public void clear() {
        for (Count count : this.backingMap.values()) {
            count.set(0);
        }
        this.backingMap.clear();
        this.size = 0L;
    }

    int distinctElements() {
        return this.backingMap.size();
    }

    public int size() {
        return Ints.saturatedCast(this.size);
    }

    public Iterator iterator() {
        return new AbstractMapBasedMultiset$MapBasedMultisetIterator(this);
    }

    public int count(@Nullable Object object) {
        try {
            Count count = (Count)this.backingMap.get(object);
            return count == null ? 0 : count.get();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    public int add(@Nullable Object object, int n) {
        int n2;
        if (n == 0) {
            return this.count(object);
        }
        Preconditions.checkArgument(n > 0, "occurrences cannot be negative: %s", n);
        Count count = (Count)this.backingMap.get(object);
        if (count == null) {
            n2 = 0;
            this.backingMap.put(object, new Count(n));
        } else {
            n2 = count.get();
            long l = (long)n2 + (long)n;
            Preconditions.checkArgument(l <= Integer.MAX_VALUE, "too many occurrences: %s", l);
            count.getAndAdd(n);
        }
        this.size += (long)n;
        return n2;
    }

    public int remove(@Nullable Object object, int n) {
        int n2;
        if (n == 0) {
            return this.count(object);
        }
        Preconditions.checkArgument(n > 0, "occurrences cannot be negative: %s", n);
        Count count = (Count)this.backingMap.get(object);
        if (count == null) {
            return 0;
        }
        int n3 = count.get();
        if (n3 > n) {
            n2 = n;
        } else {
            n2 = n3;
            this.backingMap.remove(object);
        }
        count.addAndGet(-n2);
        this.size -= (long)n2;
        return n3;
    }

    private int removeAllOccurrences(@Nullable Object object, Map map) {
        Count count = (Count)map.remove(object);
        if (count == null) {
            return 0;
        }
        int n = count.getAndSet(0);
        this.size -= (long)n;
        return n;
    }

    Set createElementSet() {
        return new AbstractMapBasedMultiset$MapBasedElementSet(this, this.backingMap);
    }

    static /* synthetic */ Map access$000(AbstractMapBasedMultiset abstractMapBasedMultiset) {
        return abstractMapBasedMultiset.backingMap;
    }

    static /* synthetic */ long access$122(AbstractMapBasedMultiset abstractMapBasedMultiset, long l) {
        return abstractMapBasedMultiset.size -= l;
    }

    static /* synthetic */ long access$110(AbstractMapBasedMultiset abstractMapBasedMultiset) {
        return abstractMapBasedMultiset.size--;
    }

    static /* synthetic */ int access$200(AbstractMapBasedMultiset abstractMapBasedMultiset, Object object, Map map) {
        return abstractMapBasedMultiset.removeAllOccurrences(object, map);
    }
}

