/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Equivalence;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Supplier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ticker;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.AbstractCache$StatsCounter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$NullListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$EntryFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$EntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$KeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$NullEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$Segment;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$Strength;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$Values;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalNotification;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class CustomConcurrentHashMap
extends AbstractMap
implements ConcurrentMap {
    private static final Logger logger = Logger.getLogger(CustomConcurrentHashMap.class.getName());
    final int segmentMask;
    final int segmentShift;
    final CustomConcurrentHashMap$Segment[] segments;
    final CacheLoader loader;
    final int concurrencyLevel;
    final Equivalence keyEquivalence;
    final Equivalence valueEquivalence;
    final CustomConcurrentHashMap$Strength keyStrength;
    final CustomConcurrentHashMap$Strength valueStrength;
    final int maximumSize;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final Queue removalNotificationQueue;
    final RemovalListener removalListener;
    final CustomConcurrentHashMap$EntryFactory entryFactory;
    final Ticker ticker;
    static final CustomConcurrentHashMap$ValueReference UNSET = new CustomConcurrentHashMap$1();
    static final Queue DISCARDING_QUEUE = new CustomConcurrentHashMap$2();
    Set keySet;
    Collection values;
    Set entrySet;

    CustomConcurrentHashMap(CacheBuilder cacheBuilder, Supplier supplier, CacheLoader cacheLoader) {
        int n;
        int n2;
        this.loader = (CacheLoader)Preconditions.checkNotNull(cacheLoader);
        this.concurrencyLevel = Math.min(cacheBuilder.getConcurrencyLevel(), 65536);
        this.keyStrength = cacheBuilder.getKeyStrength();
        this.valueStrength = cacheBuilder.getValueStrength();
        this.keyEquivalence = cacheBuilder.getKeyEquivalence();
        this.valueEquivalence = cacheBuilder.getValueEquivalence();
        this.maximumSize = cacheBuilder.maximumSize;
        this.expireAfterAccessNanos = cacheBuilder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = cacheBuilder.getExpireAfterWriteNanos();
        this.entryFactory = CustomConcurrentHashMap$EntryFactory.getFactory(this.keyStrength, this.expires(), this.evictsBySize());
        this.ticker = cacheBuilder.getTicker();
        this.removalListener = cacheBuilder.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == CacheBuilder$NullListener.INSTANCE ? CustomConcurrentHashMap.discardingQueue() : new ConcurrentLinkedQueue();
        int n3 = Math.min(cacheBuilder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize()) {
            n3 = Math.min(n3, this.maximumSize);
        }
        int n4 = 0;
        for (n2 = 1; !(n2 >= this.concurrencyLevel || this.evictsBySize() && n2 * 2 > this.maximumSize); n2 <<= 1) {
            ++n4;
        }
        this.segmentShift = 32 - n4;
        this.segmentMask = n2 - 1;
        this.segments = this.newSegmentArray(n2);
        int n5 = n3 / n2;
        if (n5 * n2 < n3) {
            ++n5;
        }
        for (n = 1; n < n5; n <<= 1) {
        }
        if (this.evictsBySize()) {
            int n6 = this.maximumSize / n2 + 1;
            int n7 = this.maximumSize % n2;
            for (int i = 0; i < this.segments.length; ++i) {
                if (i == n7) {
                    --n6;
                }
                this.segments[i] = this.createSegment(n, n6, (AbstractCache$StatsCounter)supplier.get());
            }
        } else {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = this.createSegment(n, -1, (AbstractCache$StatsCounter)supplier.get());
            }
        }
    }

    boolean evictsBySize() {
        return this.maximumSize != -1;
    }

    boolean expires() {
        return this.expiresAfterWrite() || this.expiresAfterAccess();
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    boolean usesKeyReferences() {
        return this.keyStrength != CustomConcurrentHashMap$Strength.STRONG;
    }

    boolean usesValueReferences() {
        return this.valueStrength != CustomConcurrentHashMap$Strength.STRONG;
    }

    static CustomConcurrentHashMap$ValueReference unset() {
        return UNSET;
    }

    static CustomConcurrentHashMap$ReferenceEntry nullEntry() {
        return CustomConcurrentHashMap$NullEntry.INSTANCE;
    }

    static Queue discardingQueue() {
        return DISCARDING_QUEUE;
    }

    static int rehash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    int hash(Object object) {
        int n = this.keyEquivalence.hash(object);
        return CustomConcurrentHashMap.rehash(n);
    }

    void reclaimValue(CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference) {
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ValueReference.getEntry();
        int n = customConcurrentHashMap$ReferenceEntry.getHash();
        this.segmentFor(n).reclaimValue(customConcurrentHashMap$ReferenceEntry.getKey(), n, customConcurrentHashMap$ValueReference);
    }

    void reclaimKey(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        int n = customConcurrentHashMap$ReferenceEntry.getHash();
        this.segmentFor(n).reclaimKey(customConcurrentHashMap$ReferenceEntry, n);
    }

    CustomConcurrentHashMap$Segment segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    CustomConcurrentHashMap$Segment createSegment(int n, int n2, AbstractCache$StatsCounter abstractCache$StatsCounter) {
        return new CustomConcurrentHashMap$Segment(this, n, n2, abstractCache$StatsCounter);
    }

    Object getLiveValue(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        if (customConcurrentHashMap$ReferenceEntry.getKey() == null) {
            return null;
        }
        Object object = customConcurrentHashMap$ReferenceEntry.getValueReference().get();
        if (object == null) {
            return null;
        }
        if (this.expires() && this.isExpired(customConcurrentHashMap$ReferenceEntry)) {
            return null;
        }
        return object;
    }

    boolean isExpired(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        return this.isExpired(customConcurrentHashMap$ReferenceEntry, this.ticker.read());
    }

    boolean isExpired(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, long l) {
        return l - customConcurrentHashMap$ReferenceEntry.getExpirationTime() > 0L;
    }

    @GuardedBy(value="Segment.this")
    static void connectExpirables(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2) {
        customConcurrentHashMap$ReferenceEntry.setNextExpirable(customConcurrentHashMap$ReferenceEntry2);
        customConcurrentHashMap$ReferenceEntry2.setPreviousExpirable(customConcurrentHashMap$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    static void nullifyExpirable(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = CustomConcurrentHashMap.nullEntry();
        customConcurrentHashMap$ReferenceEntry.setNextExpirable(customConcurrentHashMap$ReferenceEntry2);
        customConcurrentHashMap$ReferenceEntry.setPreviousExpirable(customConcurrentHashMap$ReferenceEntry2);
    }

    void processPendingNotifications() {
        RemovalNotification removalNotification;
        while ((removalNotification = (RemovalNotification)this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(removalNotification);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", exception);
            }
        }
    }

    @GuardedBy(value="Segment.this")
    static void connectEvictables(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2) {
        customConcurrentHashMap$ReferenceEntry.setNextEvictable(customConcurrentHashMap$ReferenceEntry2);
        customConcurrentHashMap$ReferenceEntry2.setPreviousEvictable(customConcurrentHashMap$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    static void nullifyEvictable(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = CustomConcurrentHashMap.nullEntry();
        customConcurrentHashMap$ReferenceEntry.setNextEvictable(customConcurrentHashMap$ReferenceEntry2);
        customConcurrentHashMap$ReferenceEntry.setPreviousEvictable(customConcurrentHashMap$ReferenceEntry2);
    }

    final CustomConcurrentHashMap$Segment[] newSegmentArray(int n) {
        return new CustomConcurrentHashMap$Segment[n];
    }

    public boolean isEmpty() {
        int n;
        long l = 0L;
        CustomConcurrentHashMap$Segment[] customConcurrentHashMap$SegmentArray = this.segments;
        for (n = 0; n < customConcurrentHashMap$SegmentArray.length; ++n) {
            if (customConcurrentHashMap$SegmentArray[n].count != 0) {
                return false;
            }
            l += (long)customConcurrentHashMap$SegmentArray[n].modCount;
        }
        if (l != 0L) {
            for (n = 0; n < customConcurrentHashMap$SegmentArray.length; ++n) {
                if (customConcurrentHashMap$SegmentArray[n].count != 0) {
                    return false;
                }
                l -= (long)customConcurrentHashMap$SegmentArray[n].modCount;
            }
            if (l != 0L) {
                return false;
            }
        }
        return true;
    }

    long longSize() {
        CustomConcurrentHashMap$Segment[] customConcurrentHashMap$SegmentArray = this.segments;
        long l = 0L;
        for (int i = 0; i < customConcurrentHashMap$SegmentArray.length; ++i) {
            l += (long)customConcurrentHashMap$SegmentArray[i].count;
        }
        return l;
    }

    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    public Object get(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).get(object, n);
    }

    Object getOrCompute(Object object) {
        int n = this.hash(Preconditions.checkNotNull(object));
        return this.segmentFor(n).getOrCompute(object, n, this.loader);
    }

    public boolean containsKey(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    public boolean containsValue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        CustomConcurrentHashMap$Segment[] customConcurrentHashMap$SegmentArray = this.segments;
        long l = -1L;
        for (int i = 0; i < 3; ++i) {
            long l2 = 0L;
            for (CustomConcurrentHashMap$Segment customConcurrentHashMap$Segment : customConcurrentHashMap$SegmentArray) {
                int n = customConcurrentHashMap$Segment.count;
                AtomicReferenceArray atomicReferenceArray = customConcurrentHashMap$Segment.table;
                for (int j = 0; j < atomicReferenceArray.length(); ++j) {
                    for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(j); customConcurrentHashMap$ReferenceEntry != null; customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry.getNext()) {
                        Object object2 = customConcurrentHashMap$Segment.getLiveValue(customConcurrentHashMap$ReferenceEntry);
                        if (object2 == null || !this.valueEquivalence.equivalent(object, object2)) continue;
                        return true;
                    }
                }
                l2 += (long)customConcurrentHashMap$Segment.modCount;
            }
            if (l2 == l) break;
            l = l2;
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).put(object, n, object2, false);
    }

    public Object putIfAbsent(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).put(object, n, object2, true);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n);
    }

    public boolean remove(@Nullable Object object, @Nullable Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n, object2);
    }

    public boolean replace(Object object, @Nullable Object object2, Object object3) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object3);
        if (object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2, object3);
    }

    public Object replace(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2);
    }

    public void clear() {
        for (CustomConcurrentHashMap$Segment customConcurrentHashMap$Segment : this.segments) {
            customConcurrentHashMap$Segment.clear();
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new CustomConcurrentHashMap$KeySet(this));
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new CustomConcurrentHashMap$Values(this));
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new CustomConcurrentHashMap$EntrySet(this));
    }
}

