/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.AbstractCache$StatsCounter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$ComputingValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$EvictionQueue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$ExpirationQueue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalCause;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalNotification;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class CustomConcurrentHashMap$Segment
extends ReentrantLock {
    final CustomConcurrentHashMap map;
    volatile int count;
    int modCount;
    int threshold;
    volatile AtomicReferenceArray table;
    final int maxSegmentSize;
    final ReferenceQueue keyReferenceQueue;
    final ReferenceQueue valueReferenceQueue;
    final Queue recencyQueue;
    final AtomicInteger readCount = new AtomicInteger();
    @GuardedBy(value="Segment.this")
    final Queue evictionQueue;
    @GuardedBy(value="Segment.this")
    final Queue expirationQueue;
    final AbstractCache$StatsCounter statsCounter;

    CustomConcurrentHashMap$Segment(CustomConcurrentHashMap customConcurrentHashMap, int n, int n2, AbstractCache$StatsCounter abstractCache$StatsCounter) {
        this.map = customConcurrentHashMap;
        this.maxSegmentSize = n2;
        this.statsCounter = abstractCache$StatsCounter;
        this.initTable(this.newEntryArray(n));
        this.keyReferenceQueue = customConcurrentHashMap.usesKeyReferences() ? new ReferenceQueue() : null;
        this.valueReferenceQueue = customConcurrentHashMap.usesValueReferences() ? new ReferenceQueue() : null;
        this.recencyQueue = customConcurrentHashMap.evictsBySize() || customConcurrentHashMap.expiresAfterAccess() ? new ConcurrentLinkedQueue() : CustomConcurrentHashMap.discardingQueue();
        this.evictionQueue = customConcurrentHashMap.evictsBySize() ? new CustomConcurrentHashMap$EvictionQueue() : CustomConcurrentHashMap.discardingQueue();
        this.expirationQueue = customConcurrentHashMap.expires() ? new CustomConcurrentHashMap$ExpirationQueue() : CustomConcurrentHashMap.discardingQueue();
    }

    AtomicReferenceArray newEntryArray(int n) {
        return new AtomicReferenceArray(n);
    }

    void initTable(AtomicReferenceArray atomicReferenceArray) {
        this.threshold = atomicReferenceArray.length() * 3 / 4;
        if (this.threshold == this.maxSegmentSize) {
            ++this.threshold;
        }
        this.table = atomicReferenceArray;
    }

    @GuardedBy(value="Segment.this")
    CustomConcurrentHashMap$ReferenceEntry newEntry(Object object, int n, @Nullable CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        return this.map.entryFactory.newEntry(this, object, n, customConcurrentHashMap$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    CustomConcurrentHashMap$ReferenceEntry copyEntry(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2) {
        CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry.getValueReference();
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = this.map.entryFactory.copyEntry(this, customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry2);
        customConcurrentHashMap$ReferenceEntry3.setValueReference(customConcurrentHashMap$ValueReference.copyFor(this.valueReferenceQueue, customConcurrentHashMap$ReferenceEntry3));
        return customConcurrentHashMap$ReferenceEntry3;
    }

    @GuardedBy(value="Segment.this")
    void setValue(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, Object object) {
        CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry.getValueReference();
        CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference2 = this.map.valueStrength.referenceValue(this, customConcurrentHashMap$ReferenceEntry, object);
        customConcurrentHashMap$ReferenceEntry.setValueReference(customConcurrentHashMap$ValueReference2);
        this.recordWrite(customConcurrentHashMap$ReferenceEntry);
        customConcurrentHashMap$ValueReference.notifyNewValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getOrCompute(Object object, int n, CacheLoader cacheLoader) {
        try {
            Object object2;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            Object object3;
            do {
                customConcurrentHashMap$ReferenceEntry = null;
                if (this.count != 0 && (customConcurrentHashMap$ReferenceEntry = this.getEntry(object, n)) != null && (object3 = this.getLiveValue(customConcurrentHashMap$ReferenceEntry)) != null) {
                    this.recordRead(customConcurrentHashMap$ReferenceEntry);
                    this.statsCounter.recordHit();
                    object2 = object3;
                    return object2;
                }
                if (customConcurrentHashMap$ReferenceEntry == null || !customConcurrentHashMap$ReferenceEntry.getValueReference().isComputingReference()) {
                    boolean bl = true;
                    object2 = null;
                    this.lock();
                    try {
                        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2;
                        this.preWriteCleanup();
                        int n2 = this.count - 1;
                        AtomicReferenceArray atomicReferenceArray = this.table;
                        int n3 = n & atomicReferenceArray.length() - 1;
                        for (customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry2 = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n3); customConcurrentHashMap$ReferenceEntry != null; customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry.getNext()) {
                            Object object4 = customConcurrentHashMap$ReferenceEntry.getKey();
                            if (customConcurrentHashMap$ReferenceEntry.getHash() != n || object4 == null || !this.map.keyEquivalence.equivalent(object, object4)) continue;
                            CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry.getValueReference();
                            if (customConcurrentHashMap$ValueReference.isComputingReference()) {
                                bl = false;
                                break;
                            }
                            Object object5 = customConcurrentHashMap$ReferenceEntry.getValueReference().get();
                            if (object5 == null) {
                                this.enqueueNotification(object4, n, object5, RemovalCause.COLLECTED);
                            } else if (this.map.expires() && this.map.isExpired(customConcurrentHashMap$ReferenceEntry)) {
                                this.enqueueNotification(object4, n, object5, RemovalCause.EXPIRED);
                            } else {
                                this.recordLockedRead(customConcurrentHashMap$ReferenceEntry);
                                this.statsCounter.recordHit();
                                Object object6 = object5;
                                return object6;
                            }
                            this.evictionQueue.remove(customConcurrentHashMap$ReferenceEntry);
                            this.expirationQueue.remove(customConcurrentHashMap$ReferenceEntry);
                            this.count = n2;
                            break;
                        }
                        if (bl) {
                            object2 = new CustomConcurrentHashMap$ComputingValueReference(cacheLoader);
                            if (customConcurrentHashMap$ReferenceEntry == null) {
                                customConcurrentHashMap$ReferenceEntry = this.newEntry(object, n, customConcurrentHashMap$ReferenceEntry2);
                                customConcurrentHashMap$ReferenceEntry.setValueReference((CustomConcurrentHashMap$ValueReference)object2);
                                atomicReferenceArray.set(n3, customConcurrentHashMap$ReferenceEntry);
                            } else {
                                customConcurrentHashMap$ReferenceEntry.setValueReference((CustomConcurrentHashMap$ValueReference)object2);
                            }
                        }
                    }
                    finally {
                        this.unlock();
                        this.postWriteCleanup();
                    }
                    if (bl) {
                        Object object7 = this.compute(object, n, customConcurrentHashMap$ReferenceEntry, (CustomConcurrentHashMap$ComputingValueReference)object2);
                        return object7;
                    }
                }
                Preconditions.checkState(!Thread.holdsLock(customConcurrentHashMap$ReferenceEntry), "Recursive computation");
            } while ((object3 = customConcurrentHashMap$ReferenceEntry.getValueReference().waitForValue()) == null);
            this.recordRead(customConcurrentHashMap$ReferenceEntry);
            this.statsCounter.recordConcurrentMiss();
            object2 = object3;
            return object2;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object compute(Object object, int n, CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, CustomConcurrentHashMap$ComputingValueReference customConcurrentHashMap$ComputingValueReference) {
        Object object2 = null;
        long l = System.nanoTime();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry;
            synchronized (customConcurrentHashMap$ReferenceEntry2) {
                object2 = customConcurrentHashMap$ComputingValueReference.compute(object, n);
            }
            long l2 = System.nanoTime();
            this.statsCounter.recordLoadSuccess(l2 - l);
            Object object3 = this.put(object, n, object2, true);
            if (object3 != null) {
                this.enqueueNotification(object, n, object2, RemovalCause.REPLACED);
            }
            Object object4 = object2;
            return object4;
        }
        finally {
            if (object2 == null) {
                long l3 = System.nanoTime();
                this.statsCounter.recordLoadException(l3 - l);
                this.clearValue(object, n, customConcurrentHashMap$ComputingValueReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryDrainReferenceQueues() {
        if (this.tryLock()) {
            try {
                this.drainReferenceQueues();
            }
            finally {
                this.unlock();
            }
        }
    }

    @GuardedBy(value="Segment.this")
    void drainReferenceQueues() {
        if (this.map.usesKeyReferences()) {
            this.drainKeyReferenceQueue();
        }
        if (this.map.usesValueReferences()) {
            this.drainValueReferenceQueue();
        }
    }

    @GuardedBy(value="Segment.this")
    void drainKeyReferenceQueue() {
        Reference reference;
        int n = 0;
        while ((reference = this.keyReferenceQueue.poll()) != null) {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)((Object)reference);
            this.map.reclaimKey(customConcurrentHashMap$ReferenceEntry);
            if (++n != 16) continue;
            break;
        }
    }

    @GuardedBy(value="Segment.this")
    void drainValueReferenceQueue() {
        Reference reference;
        int n = 0;
        while ((reference = this.valueReferenceQueue.poll()) != null) {
            CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = (CustomConcurrentHashMap$ValueReference)((Object)reference);
            this.map.reclaimValue(customConcurrentHashMap$ValueReference);
            if (++n != 16) continue;
            break;
        }
    }

    void clearReferenceQueues() {
        if (this.map.usesKeyReferences()) {
            this.clearKeyReferenceQueue();
        }
        if (this.map.usesValueReferences()) {
            this.clearValueReferenceQueue();
        }
    }

    void clearKeyReferenceQueue() {
        while (this.keyReferenceQueue.poll() != null) {
        }
    }

    void clearValueReferenceQueue() {
        while (this.valueReferenceQueue.poll() != null) {
        }
    }

    void recordRead(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        if (this.map.expiresAfterAccess()) {
            this.recordExpirationTime(customConcurrentHashMap$ReferenceEntry, this.map.expireAfterAccessNanos);
        }
        this.recencyQueue.add(customConcurrentHashMap$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    void recordLockedRead(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        this.evictionQueue.add(customConcurrentHashMap$ReferenceEntry);
        if (this.map.expiresAfterAccess()) {
            this.recordExpirationTime(customConcurrentHashMap$ReferenceEntry, this.map.expireAfterAccessNanos);
            this.expirationQueue.add(customConcurrentHashMap$ReferenceEntry);
        }
    }

    @GuardedBy(value="Segment.this")
    void recordWrite(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        this.drainRecencyQueue();
        this.evictionQueue.add(customConcurrentHashMap$ReferenceEntry);
        if (this.map.expires()) {
            long l = this.map.expiresAfterAccess() ? this.map.expireAfterAccessNanos : this.map.expireAfterWriteNanos;
            this.recordExpirationTime(customConcurrentHashMap$ReferenceEntry, l);
            this.expirationQueue.add(customConcurrentHashMap$ReferenceEntry);
        }
    }

    @GuardedBy(value="Segment.this")
    void drainRecencyQueue() {
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
        while ((customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)this.recencyQueue.poll()) != null) {
            if (this.evictionQueue.contains(customConcurrentHashMap$ReferenceEntry)) {
                this.evictionQueue.add(customConcurrentHashMap$ReferenceEntry);
            }
            if (!this.map.expiresAfterAccess() || !this.expirationQueue.contains(customConcurrentHashMap$ReferenceEntry)) continue;
            this.expirationQueue.add(customConcurrentHashMap$ReferenceEntry);
        }
    }

    void recordExpirationTime(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, long l) {
        customConcurrentHashMap$ReferenceEntry.setExpirationTime(this.map.ticker.read() + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryExpireEntries() {
        if (this.tryLock()) {
            try {
                this.expireEntries();
            }
            finally {
                this.unlock();
            }
        }
    }

    @GuardedBy(value="Segment.this")
    void expireEntries() {
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
        this.drainRecencyQueue();
        if (this.expirationQueue.isEmpty()) {
            return;
        }
        long l = this.map.ticker.read();
        while ((customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)this.expirationQueue.peek()) != null && this.map.isExpired(customConcurrentHashMap$ReferenceEntry, l)) {
            if (!this.removeEntry(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry.getHash(), RemovalCause.EXPIRED)) {
                throw new AssertionError();
            }
        }
    }

    void enqueueNotification(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, RemovalCause removalCause) {
        this.enqueueNotification(customConcurrentHashMap$ReferenceEntry.getKey(), customConcurrentHashMap$ReferenceEntry.getHash(), customConcurrentHashMap$ReferenceEntry.getValueReference().get(), removalCause);
    }

    void enqueueNotification(@Nullable Object object, int n, @Nullable Object object2, RemovalCause removalCause) {
        if (removalCause.wasEvicted()) {
            this.statsCounter.recordEviction();
        }
        if (this.map.removalNotificationQueue != CustomConcurrentHashMap.DISCARDING_QUEUE) {
            RemovalNotification removalNotification = new RemovalNotification(object, object2, removalCause);
            this.map.removalNotificationQueue.offer(removalNotification);
        }
    }

    @GuardedBy(value="Segment.this")
    boolean evictEntries() {
        if (this.map.evictsBySize() && this.count >= this.maxSegmentSize) {
            this.drainRecencyQueue();
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)this.evictionQueue.remove();
            if (!this.removeEntry(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry.getHash(), RemovalCause.SIZE)) {
                throw new AssertionError();
            }
            return true;
        }
        return false;
    }

    CustomConcurrentHashMap$ReferenceEntry getFirst(int n) {
        AtomicReferenceArray atomicReferenceArray = this.table;
        return (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n & atomicReferenceArray.length() - 1);
    }

    CustomConcurrentHashMap$ReferenceEntry getEntry(Object object, int n) {
        for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = this.getFirst(n); customConcurrentHashMap$ReferenceEntry != null; customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry.getNext()) {
            if (customConcurrentHashMap$ReferenceEntry.getHash() != n) continue;
            Object object2 = customConcurrentHashMap$ReferenceEntry.getKey();
            if (object2 == null) {
                this.tryDrainReferenceQueues();
                continue;
            }
            if (!this.map.keyEquivalence.equivalent(object, object2)) continue;
            return customConcurrentHashMap$ReferenceEntry;
        }
        return null;
    }

    CustomConcurrentHashMap$ReferenceEntry getLiveEntry(Object object, int n) {
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = this.getEntry(object, n);
        if (customConcurrentHashMap$ReferenceEntry == null) {
            return null;
        }
        if (this.map.expires() && this.map.isExpired(customConcurrentHashMap$ReferenceEntry)) {
            this.tryExpireEntries();
            return null;
        }
        return customConcurrentHashMap$ReferenceEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object get(Object object, int n) {
        try {
            if (this.count != 0) {
                CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = this.getLiveEntry(object, n);
                if (customConcurrentHashMap$ReferenceEntry == null) {
                    Object var4_5 = null;
                    return var4_5;
                }
                Object object2 = customConcurrentHashMap$ReferenceEntry.getValueReference().get();
                if (object2 != null) {
                    this.recordRead(customConcurrentHashMap$ReferenceEntry);
                } else {
                    this.tryDrainReferenceQueues();
                }
                Object object3 = object2;
                return object3;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsKey(Object object, int n) {
        try {
            if (this.count != 0) {
                CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = this.getLiveEntry(object, n);
                if (customConcurrentHashMap$ReferenceEntry == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = customConcurrentHashMap$ReferenceEntry.getValueReference().get() != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object put(Object object, int n, Object object2, boolean bl) {
        this.lock();
        try {
            Object object3;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2;
            this.preWriteCleanup();
            int n2 = this.count + 1;
            if (n2 > this.threshold) {
                this.expand();
                n2 = this.count + 1;
            }
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n3); customConcurrentHashMap$ReferenceEntry2 != null; customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry2.getNext()) {
                object3 = customConcurrentHashMap$ReferenceEntry2.getKey();
                if (customConcurrentHashMap$ReferenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry2.getValueReference();
                Object object4 = customConcurrentHashMap$ValueReference.get();
                if (object4 == null) {
                    ++this.modCount;
                    this.setValue(customConcurrentHashMap$ReferenceEntry2, object2);
                    if (!customConcurrentHashMap$ValueReference.isComputingReference()) {
                        this.enqueueNotification(object, n, object4, RemovalCause.COLLECTED);
                        n2 = this.count;
                    } else if (this.evictEntries()) {
                        n2 = this.count + 1;
                    }
                    this.count = n2;
                    Object var13_13 = null;
                    return var13_13;
                }
                if (bl) {
                    this.recordLockedRead(customConcurrentHashMap$ReferenceEntry2);
                    Object object5 = object4;
                    return object5;
                }
                ++this.modCount;
                this.enqueueNotification(object, n, object4, RemovalCause.REPLACED);
                this.setValue(customConcurrentHashMap$ReferenceEntry2, object2);
                Object object6 = object4;
                return object6;
            }
            ++this.modCount;
            customConcurrentHashMap$ReferenceEntry2 = this.newEntry(object, n, customConcurrentHashMap$ReferenceEntry);
            this.setValue(customConcurrentHashMap$ReferenceEntry2, object2);
            atomicReferenceArray.set(n3, customConcurrentHashMap$ReferenceEntry2);
            if (this.evictEntries()) {
                n2 = this.count + 1;
            }
            this.count = n2;
            object3 = null;
            return object3;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    @GuardedBy(value="Segment.this")
    void expand() {
        AtomicReferenceArray atomicReferenceArray = this.table;
        int n = atomicReferenceArray.length();
        if (n >= 0x40000000) {
            return;
        }
        int n2 = this.count;
        AtomicReferenceArray atomicReferenceArray2 = this.newEntryArray(n << 1);
        this.threshold = atomicReferenceArray2.length() * 3 / 4;
        int n3 = atomicReferenceArray2.length() - 1;
        for (int i = 0; i < n; ++i) {
            int n4;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(i);
            if (customConcurrentHashMap$ReferenceEntry2 == null) continue;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = customConcurrentHashMap$ReferenceEntry2.getNext();
            int n5 = customConcurrentHashMap$ReferenceEntry2.getHash() & n3;
            if (customConcurrentHashMap$ReferenceEntry3 == null) {
                atomicReferenceArray2.set(n5, customConcurrentHashMap$ReferenceEntry2);
                continue;
            }
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry4 = customConcurrentHashMap$ReferenceEntry2;
            int n6 = n5;
            for (customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry3; customConcurrentHashMap$ReferenceEntry != null; customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry.getNext()) {
                n4 = customConcurrentHashMap$ReferenceEntry.getHash() & n3;
                if (n4 == n6) continue;
                n6 = n4;
                customConcurrentHashMap$ReferenceEntry4 = customConcurrentHashMap$ReferenceEntry;
            }
            atomicReferenceArray2.set(n6, customConcurrentHashMap$ReferenceEntry4);
            for (customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry2; customConcurrentHashMap$ReferenceEntry != customConcurrentHashMap$ReferenceEntry4; customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry.getNext()) {
                if (this.isCollected(customConcurrentHashMap$ReferenceEntry)) {
                    this.removeCollectedEntry(customConcurrentHashMap$ReferenceEntry);
                    --n2;
                    continue;
                }
                n4 = customConcurrentHashMap$ReferenceEntry.getHash() & n3;
                CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry5 = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray2.get(n4);
                CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry6 = this.copyEntry(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry5);
                atomicReferenceArray2.set(n4, customConcurrentHashMap$ReferenceEntry6);
            }
        }
        this.table = atomicReferenceArray2;
        this.count = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replace(Object object, int n, Object object2, Object object3) {
        this.lock();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            this.preWriteCleanup();
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n2); customConcurrentHashMap$ReferenceEntry2 != null; customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry2.getNext()) {
                Object object4 = customConcurrentHashMap$ReferenceEntry2.getKey();
                if (customConcurrentHashMap$ReferenceEntry2.getHash() != n || object4 == null || !this.map.keyEquivalence.equivalent(object, object4)) continue;
                CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry2.getValueReference();
                Object object5 = customConcurrentHashMap$ValueReference.get();
                if (object5 == null) {
                    int n3;
                    if (this.isCollected(customConcurrentHashMap$ValueReference)) {
                        n3 = this.count - 1;
                        ++this.modCount;
                        this.enqueueNotification(object4, n, object5, RemovalCause.COLLECTED);
                        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry2);
                        n3 = this.count - 1;
                        atomicReferenceArray.set(n2, customConcurrentHashMap$ReferenceEntry3);
                        this.count = n3;
                    }
                    n3 = 0;
                    return n3 != 0;
                }
                if (this.map.valueEquivalence.equivalent(object2, object5)) {
                    ++this.modCount;
                    this.enqueueNotification(object, n, object5, RemovalCause.REPLACED);
                    this.setValue(customConcurrentHashMap$ReferenceEntry2, object3);
                    boolean bl = true;
                    return bl;
                }
                this.recordLockedRead(customConcurrentHashMap$ReferenceEntry2);
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object replace(Object object, int n, Object object2) {
        this.lock();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2;
            this.preWriteCleanup();
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n2); customConcurrentHashMap$ReferenceEntry2 != null; customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry2.getNext()) {
                Object object3 = customConcurrentHashMap$ReferenceEntry2.getKey();
                if (customConcurrentHashMap$ReferenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry2.getValueReference();
                Object object4 = customConcurrentHashMap$ValueReference.get();
                if (object4 == null) {
                    if (this.isCollected(customConcurrentHashMap$ValueReference)) {
                        int n3 = this.count - 1;
                        ++this.modCount;
                        this.enqueueNotification(object3, n, object4, RemovalCause.COLLECTED);
                        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry2);
                        n3 = this.count - 1;
                        atomicReferenceArray.set(n2, customConcurrentHashMap$ReferenceEntry3);
                        this.count = n3;
                    }
                    Object var11_12 = null;
                    return var11_12;
                }
                ++this.modCount;
                this.enqueueNotification(object, n, object4, RemovalCause.REPLACED);
                this.setValue(customConcurrentHashMap$ReferenceEntry2, object2);
                Object object5 = object4;
                return object5;
            }
            customConcurrentHashMap$ReferenceEntry2 = null;
            return customConcurrentHashMap$ReferenceEntry2;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object remove(Object object, int n) {
        this.lock();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2;
            this.preWriteCleanup();
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n3); customConcurrentHashMap$ReferenceEntry2 != null; customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry2.getNext()) {
                RemovalCause removalCause;
                Object object2 = customConcurrentHashMap$ReferenceEntry2.getKey();
                if (customConcurrentHashMap$ReferenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry2.getValueReference();
                Object object3 = customConcurrentHashMap$ValueReference.get();
                if (object3 != null) {
                    removalCause = RemovalCause.EXPLICIT;
                } else if (this.isCollected(customConcurrentHashMap$ValueReference)) {
                    removalCause = RemovalCause.COLLECTED;
                } else {
                    Object var12_12 = null;
                    return var12_12;
                }
                ++this.modCount;
                this.enqueueNotification(object2, n, object3, removalCause);
                CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry2);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, customConcurrentHashMap$ReferenceEntry3);
                this.count = n2;
                Object object4 = object3;
                return object4;
            }
            customConcurrentHashMap$ReferenceEntry2 = null;
            return customConcurrentHashMap$ReferenceEntry2;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Object object, int n, Object object2) {
        this.lock();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            this.preWriteCleanup();
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n3); customConcurrentHashMap$ReferenceEntry2 != null; customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry2.getNext()) {
                RemovalCause removalCause;
                Object object3 = customConcurrentHashMap$ReferenceEntry2.getKey();
                if (customConcurrentHashMap$ReferenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference = customConcurrentHashMap$ReferenceEntry2.getValueReference();
                Object object4 = customConcurrentHashMap$ValueReference.get();
                if (this.map.valueEquivalence.equivalent(object2, object4)) {
                    removalCause = RemovalCause.EXPLICIT;
                } else if (this.isCollected(customConcurrentHashMap$ValueReference)) {
                    removalCause = RemovalCause.COLLECTED;
                } else {
                    boolean bl = false;
                    return bl;
                }
                ++this.modCount;
                this.enqueueNotification(object3, n, object4, removalCause);
                CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry2);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, customConcurrentHashMap$ReferenceEntry3);
                this.count = n2;
                boolean bl = removalCause == RemovalCause.EXPLICIT;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        if (this.count != 0) {
            this.lock();
            try {
                int n;
                AtomicReferenceArray atomicReferenceArray = this.table;
                if (this.map.removalNotificationQueue != CustomConcurrentHashMap.DISCARDING_QUEUE) {
                    for (n = 0; n < atomicReferenceArray.length(); ++n) {
                        for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n); customConcurrentHashMap$ReferenceEntry != null; customConcurrentHashMap$ReferenceEntry = customConcurrentHashMap$ReferenceEntry.getNext()) {
                            if (customConcurrentHashMap$ReferenceEntry.getValueReference().isComputingReference()) continue;
                            this.enqueueNotification(customConcurrentHashMap$ReferenceEntry, RemovalCause.EXPLICIT);
                        }
                    }
                }
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    atomicReferenceArray.set(n, null);
                }
                this.clearReferenceQueues();
                this.evictionQueue.clear();
                this.expirationQueue.clear();
                this.readCount.set(0);
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }
    }

    @GuardedBy(value="Segment.this")
    CustomConcurrentHashMap$ReferenceEntry removeFromChain(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2) {
        this.evictionQueue.remove(customConcurrentHashMap$ReferenceEntry2);
        this.expirationQueue.remove(customConcurrentHashMap$ReferenceEntry2);
        int n = this.count;
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = customConcurrentHashMap$ReferenceEntry2.getNext();
        for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry4 = customConcurrentHashMap$ReferenceEntry; customConcurrentHashMap$ReferenceEntry4 != customConcurrentHashMap$ReferenceEntry2; customConcurrentHashMap$ReferenceEntry4 = customConcurrentHashMap$ReferenceEntry4.getNext()) {
            if (this.isCollected(customConcurrentHashMap$ReferenceEntry4)) {
                this.removeCollectedEntry(customConcurrentHashMap$ReferenceEntry4);
                --n;
                continue;
            }
            customConcurrentHashMap$ReferenceEntry3 = this.copyEntry(customConcurrentHashMap$ReferenceEntry4, customConcurrentHashMap$ReferenceEntry3);
        }
        this.count = n;
        return customConcurrentHashMap$ReferenceEntry3;
    }

    void removeCollectedEntry(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        this.enqueueNotification(customConcurrentHashMap$ReferenceEntry, RemovalCause.COLLECTED);
        this.evictionQueue.remove(customConcurrentHashMap$ReferenceEntry);
        this.expirationQueue.remove(customConcurrentHashMap$ReferenceEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimKey(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, int n) {
        this.lock();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2;
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = customConcurrentHashMap$ReferenceEntry2 = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n3); customConcurrentHashMap$ReferenceEntry3 != null; customConcurrentHashMap$ReferenceEntry3 = customConcurrentHashMap$ReferenceEntry3.getNext()) {
                if (customConcurrentHashMap$ReferenceEntry3 != customConcurrentHashMap$ReferenceEntry) continue;
                ++this.modCount;
                this.enqueueNotification(customConcurrentHashMap$ReferenceEntry3.getKey(), n, customConcurrentHashMap$ReferenceEntry3.getValueReference().get(), RemovalCause.COLLECTED);
                CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry4 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry2, customConcurrentHashMap$ReferenceEntry3);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, customConcurrentHashMap$ReferenceEntry4);
                this.count = n2;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimValue(Object object, int n, CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference) {
        this.lock();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n3); customConcurrentHashMap$ReferenceEntry2 != null; customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry2.getNext()) {
                Object object2 = customConcurrentHashMap$ReferenceEntry2.getKey();
                if (customConcurrentHashMap$ReferenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference2 = customConcurrentHashMap$ReferenceEntry2.getValueReference();
                if (customConcurrentHashMap$ValueReference2 == customConcurrentHashMap$ValueReference) {
                    ++this.modCount;
                    this.enqueueNotification(object, n, customConcurrentHashMap$ValueReference.get(), RemovalCause.COLLECTED);
                    CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry2);
                    n2 = this.count - 1;
                    atomicReferenceArray.set(n3, customConcurrentHashMap$ReferenceEntry3);
                    this.count = n2;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            if (!this.isHeldByCurrentThread()) {
                this.postWriteCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearValue(Object object, int n, CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference) {
        this.lock();
        try {
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n2); customConcurrentHashMap$ReferenceEntry2 != null; customConcurrentHashMap$ReferenceEntry2 = customConcurrentHashMap$ReferenceEntry2.getNext()) {
                Object object2 = customConcurrentHashMap$ReferenceEntry2.getKey();
                if (customConcurrentHashMap$ReferenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference2 = customConcurrentHashMap$ReferenceEntry2.getValueReference();
                if (customConcurrentHashMap$ValueReference2 == customConcurrentHashMap$ValueReference) {
                    CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry, customConcurrentHashMap$ReferenceEntry2);
                    atomicReferenceArray.set(n2, customConcurrentHashMap$ReferenceEntry3);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    @GuardedBy(value="Segment.this")
    boolean removeEntry(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry, int n, RemovalCause removalCause) {
        CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry2;
        int n2 = this.count - 1;
        AtomicReferenceArray atomicReferenceArray = this.table;
        int n3 = n & atomicReferenceArray.length() - 1;
        for (CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry3 = customConcurrentHashMap$ReferenceEntry2 = (CustomConcurrentHashMap$ReferenceEntry)atomicReferenceArray.get(n3); customConcurrentHashMap$ReferenceEntry3 != null; customConcurrentHashMap$ReferenceEntry3 = customConcurrentHashMap$ReferenceEntry3.getNext()) {
            if (customConcurrentHashMap$ReferenceEntry3 != customConcurrentHashMap$ReferenceEntry) continue;
            ++this.modCount;
            this.enqueueNotification(customConcurrentHashMap$ReferenceEntry3.getKey(), n, customConcurrentHashMap$ReferenceEntry3.getValueReference().get(), removalCause);
            CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry4 = this.removeFromChain(customConcurrentHashMap$ReferenceEntry2, customConcurrentHashMap$ReferenceEntry3);
            n2 = this.count - 1;
            atomicReferenceArray.set(n3, customConcurrentHashMap$ReferenceEntry4);
            this.count = n2;
            return true;
        }
        return false;
    }

    boolean isCollected(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        if (customConcurrentHashMap$ReferenceEntry.getKey() == null) {
            return true;
        }
        return this.isCollected(customConcurrentHashMap$ReferenceEntry.getValueReference());
    }

    boolean isCollected(CustomConcurrentHashMap$ValueReference customConcurrentHashMap$ValueReference) {
        if (customConcurrentHashMap$ValueReference.isComputingReference()) {
            return false;
        }
        return customConcurrentHashMap$ValueReference.get() == null;
    }

    Object getLiveValue(CustomConcurrentHashMap$ReferenceEntry customConcurrentHashMap$ReferenceEntry) {
        if (customConcurrentHashMap$ReferenceEntry.getKey() == null) {
            this.tryDrainReferenceQueues();
            return null;
        }
        Object object = customConcurrentHashMap$ReferenceEntry.getValueReference().get();
        if (object == null) {
            this.tryDrainReferenceQueues();
            return null;
        }
        if (this.map.expires() && this.map.isExpired(customConcurrentHashMap$ReferenceEntry)) {
            this.tryExpireEntries();
            return null;
        }
        return object;
    }

    void postReadCleanup() {
        if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
            this.cleanUp();
        }
    }

    @GuardedBy(value="Segment.this")
    void preWriteCleanup() {
        this.runLockedCleanup();
    }

    void postWriteCleanup() {
        this.runUnlockedCleanup();
    }

    void cleanUp() {
        this.runLockedCleanup();
        this.runUnlockedCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runLockedCleanup() {
        if (this.tryLock()) {
            try {
                this.drainReferenceQueues();
                this.expireEntries();
                this.readCount.set(0);
            }
            finally {
                this.unlock();
            }
        }
    }

    void runUnlockedCleanup() {
        if (!this.isHeldByCurrentThread()) {
            this.map.processPendingNotifications();
        }
    }
}

