/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.mail.MailConstants;
import org.mobylet.mail.builder.HtmlPart;
import org.mobylet.mail.config.MailMimeConfig;
import org.mobylet.mail.message.MessageBody;
import org.mobylet.mail.util.MailHeaderUtils;

public class PartUtils
implements MailConstants {
    public static final Pattern PATTERN_IMGTAG = Pattern.compile("<(img|IMG)[ ]+.+?>");
    public static final Pattern PATTERN_INLINEIMAGESRC = Pattern.compile("src[ ]*=[ ]*[\"]?[0-9a-zA-Z._/:\\\\-]+[\"]?");

    public static MimeBodyPart buildAttachPart(Carrier carrier, MessageBody.Attach attach) {
        String defMime;
        MimeBodyPart part = new MimeBodyPart();
        if (attach == null || StringUtils.isEmpty((String)attach.getRealPath()) || StringUtils.isEmpty((String)attach.getNickname()) || attach.getInputStream() == null) {
            return part;
        }
        String realPath = attach.getRealPath();
        String extension = null;
        if (realPath.indexOf(46) >= 0) {
            extension = realPath.substring(realPath.lastIndexOf(46) + 1);
        }
        String mimeType = "application/octet-stream";
        if (StringUtils.isNotEmpty(extension) && StringUtils.isNotEmpty((String)(defMime = ((MailMimeConfig)SingletonUtils.get(MailMimeConfig.class)).getMimeProperties().getProperty(extension)))) {
            mimeType = defMime;
        }
        ByteArrayDataSource byteSource = null;
        try {
            byteSource = new ByteArrayDataSource(attach.getInputStream(), "application/octet-stream");
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304b\u3089DataSource\u304c\u4f5c\u6210\u51fa\u6765\u307e\u305b\u3093", (Exception)e);
        }
        try {
            part.setDataHandler(new DataHandler((DataSource)byteSource));
            part.setHeader("Content-Transfer-Encoding", "base64");
            if (carrier == Carrier.AU) {
                part.addHeader("Content-Disposition", "attachment; filename=\"" + PartUtils.getRealFileName(attach) + "\"");
            }
            if (attach.isInline()) {
                part.setHeader("Content-ID", "<" + attach.getNickname() + ">");
            }
            if (StringUtils.isEmpty((String)attach.getRealPath())) {
                part.addHeader("Content-Type", mimeType + ";");
            } else {
                part.addHeader("Content-Type", mimeType + "; name=\"" + MailHeaderUtils.encodeHeaderString(carrier, PartUtils.getRealFileName(attach) + "\""));
            }
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u30d1\u30fc\u30c8\u3092\u4f5c\u6210\u4e2d\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
        }
        return part;
    }

    public static HtmlPart buildHtmlPart(Carrier carrier, String body) {
        ArrayList<MimeBodyPart> inlineParts = new ArrayList<MimeBodyPart>();
        StringBuffer buf = new StringBuffer("");
        ArrayList<MessageBody.Attach> inlines = new ArrayList<MessageBody.Attach>();
        Matcher imgTagMatcher = PATTERN_IMGTAG.matcher(body);
        int cidindex = 0;
        while (imgTagMatcher.find()) {
            String cid = cidindex + "@mobylet";
            String imgTagString = imgTagMatcher.group();
            Matcher srcAttMatcher = PATTERN_INLINEIMAGESRC.matcher(imgTagString);
            if (srcAttMatcher.find()) {
                String srcString = srcAttMatcher.group();
                String srcValue = srcString.substring(srcString.indexOf("=") + 1).trim();
                if (srcValue.startsWith("\"") && srcValue.endsWith("\"")) {
                    srcValue = srcValue.substring(1, srcValue.length() - 1);
                }
                if (srcValue.startsWith("'") && srcValue.endsWith("'")) {
                    srcValue = srcValue.substring(1, srcValue.length() - 1);
                }
                MessageBody.Attach inline = new MessageBody.Attach(srcValue, cid, ResourceUtils.getResourceFileOrInputStream((String)srcValue));
                inline.setInline(true);
                inlines.add(inline);
            }
            imgTagMatcher.appendReplacement(buf, "<img src=\"cid:" + cid + "\" />");
            ++cidindex;
        }
        imgTagMatcher.appendTail(buf);
        HtmlPart htmlPart = new HtmlPart(buf.toString());
        if (inlines.size() != 0) {
            for (MessageBody.Attach inline : inlines) {
                inlineParts.add(PartUtils.buildAttachPart(carrier, inline));
            }
        }
        htmlPart.setInlineParts(inlineParts);
        return htmlPart;
    }

    public static String getRealFileName(MessageBody.Attach attach) {
        if (attach != null && attach.getRealPath() != null) {
            String realPath = attach.getRealPath();
            int index = -1;
            index = realPath.lastIndexOf(File.separatorChar);
            if (index >= 0 || (index = realPath.lastIndexOf(47)) >= 0) {
                return realPath.substring(index + 1);
            }
            return realPath;
        }
        return "EMPTYNAME";
    }
}

