/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core.attribute;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class CommonAttributesDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.core.attribute.CommonAttributes";
    public final String prefix = "";
    public final String title = "Attributes shared and inherited by many clustering algorithms";
    public final String label = "";
    public final String description = "Extracted for consistency.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "Attributes shared and inherited by many clustering algorithms";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Extracted for consistency.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(CommonAttributesDescriptor.attributes.start);
        ownAttrs.add(CommonAttributesDescriptor.attributes.results);
        ownAttrs.add(CommonAttributesDescriptor.attributes.query);
        ownAttrs.add(CommonAttributesDescriptor.attributes.resultsTotal);
        ownAttrs.add(CommonAttributesDescriptor.attributes.documents);
        ownAttrs.add(CommonAttributesDescriptor.attributes.clusters);
        ownAttrs.add(CommonAttributesDescriptor.attributes.processingTimeTotal);
        ownAttrs.add(CommonAttributesDescriptor.attributes.processingTimeSource);
        ownAttrs.add(CommonAttributesDescriptor.attributes.processingTimeAlgorithm);
        ownAttrs.add(CommonAttributesDescriptor.attributes.processingResultTitle);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(CommonAttributesDescriptor.attributes.start);
        allAttrs.add(CommonAttributesDescriptor.attributes.results);
        allAttrs.add(CommonAttributesDescriptor.attributes.query);
        allAttrs.add(CommonAttributesDescriptor.attributes.resultsTotal);
        allAttrs.add(CommonAttributesDescriptor.attributes.documents);
        allAttrs.add(CommonAttributesDescriptor.attributes.clusters);
        allAttrs.add(CommonAttributesDescriptor.attributes.processingTimeTotal);
        allAttrs.add(CommonAttributesDescriptor.attributes.processingTimeSource);
        allAttrs.add(CommonAttributesDescriptor.attributes.processingTimeAlgorithm);
        allAttrs.add(CommonAttributesDescriptor.attributes.processingResultTitle);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder start(int value) {
            this.map.put("start", value);
            return this;
        }

        public AttributeBuilder results(int value) {
            this.map.put("results", value);
            return this;
        }

        public AttributeBuilder query(String value) {
            this.map.put("query", value);
            return this;
        }

        public Long resultsTotal() {
            return (Long)this.map.get("results-total");
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public List<Document> documents() {
            return (List)this.map.get("documents");
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public Long processingTimeTotal() {
            return (Long)this.map.get("processing-time-total");
        }

        public Long processingTimeSource() {
            return (Long)this.map.get("processing-time-source");
        }

        public Long processingTimeAlgorithm() {
            return (Long)this.map.get("processing-time-algorithm");
        }

        public String processingResultTitle() {
            return (String)this.map.get("processing-result.title");
        }
    }

    public static final class Attributes {
        public final AttributeInfo start = new AttributeInfo("start", "org.carrot2.core.attribute.CommonAttributes", "start", "Index of the first document/ search result to fetch. The index starts at zero.", "Start index", "Index of the first document/ search result to fetch", "The index starts at zero.", "Search query", AttributeLevel.ADVANCED, null);
        public final AttributeInfo results = new AttributeInfo("results", "org.carrot2.core.attribute.CommonAttributes", "results", "Maximum number of documents/ search results to fetch. The query hint can be used\nby clustering algorithms to avoid creating trivial clusters (combination of query words).", "Results", "Maximum number of documents/ search results to fetch", "The query hint can be used by clustering algorithms to avoid creating trivial clusters (combination of query words).", "Search query", AttributeLevel.BASIC, null);
        public final AttributeInfo query = new AttributeInfo("query", "org.carrot2.core.attribute.CommonAttributes", "query", "Query to perform.", "Query", "Query to perform", null, "Search query", AttributeLevel.BASIC, null);
        public final AttributeInfo resultsTotal = new AttributeInfo("results-total", "org.carrot2.core.attribute.CommonAttributes", "resultsTotal", "Estimated total number of matching documents.", "Total results", "Estimated total number of matching documents", null, "Search result information", null, null);
        public final AttributeInfo documents = new AttributeInfo("documents", "org.carrot2.core.attribute.CommonAttributes", "documents", "Documents returned by the search engine/ document retrieval system or\ndocuments passed as input to the clustering algorithm.", "Documents", "Documents returned by the search engine/ document retrieval system or documents passed as input to the clustering algorithm", null, "Documents", AttributeLevel.BASIC, null);
        public final AttributeInfo clusters = new AttributeInfo("clusters", "org.carrot2.core.attribute.CommonAttributes", "clusters", "Clusters created by the clustering algorithm.", "Clusters", "Clusters created by the clustering algorithm", null, "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo processingTimeTotal = new AttributeInfo("processing-time-total", "org.carrot2.core.attribute.CommonAttributes", "processingTimeTotal", "Total processing time in milliseconds. A sum of processing times of all components in the chain.\nTotal processing time may be greater than the sum of\n{@link org.carrot2.core.attribute.CommonAttributes#processingTimeTotal} and {@link org.carrot2.core.attribute.CommonAttributes#processingTimeAlgorithm}.", "Total processing time", "Total processing time in milliseconds", "A sum of processing times of all components in the chain. Total processing time may be greater than the sum of <code>org.carrot2.core.attribute.CommonAttributes.processingTimeTotal</code> and <code>org.carrot2.core.attribute.CommonAttributes.processingTimeAlgorithm</code>.", "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo processingTimeSource = new AttributeInfo("processing-time-source", "org.carrot2.core.attribute.CommonAttributes", "processingTimeSource", "Data source processing time in milliseconds. A sum of processing times of all\n{@link org.carrot2.core.IDocumentSource}s in the chain, including the\n{@link org.carrot2.core.IProcessingComponent#beforeProcessing()} and\n{@link org.carrot2.core.IProcessingComponent#afterProcessing()} hooks.", "Data source processing time", "Data source processing time in milliseconds", "A sum of processing times of all <code>org.carrot2.core.IDocumentSource</code>s in the chain, including the <code>org.carrot2.core.IProcessingComponent.beforeProcessing()</code> and <code>org.carrot2.core.IProcessingComponent.afterProcessing()</code> hooks.", "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo processingTimeAlgorithm = new AttributeInfo("processing-time-algorithm", "org.carrot2.core.attribute.CommonAttributes", "processingTimeAlgorithm", "Algorithm processing time in milliseconds. A sum of processing times of all\n{@link org.carrot2.core.IClusteringAlgorithm}s in the chain, including the\n{@link org.carrot2.core.IProcessingComponent#beforeProcessing()} and\n{@link org.carrot2.core.IProcessingComponent#afterProcessing()} hooks.", "Clustering algorithm processing time", "Algorithm processing time in milliseconds", "A sum of processing times of all <code>org.carrot2.core.IClusteringAlgorithm</code>s in the chain, including the <code>org.carrot2.core.IProcessingComponent.beforeProcessing()</code> and <code>org.carrot2.core.IProcessingComponent.afterProcessing()</code> hooks.", "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo processingResultTitle = new AttributeInfo("processing-result.title", "org.carrot2.core.attribute.CommonAttributes", "processingResultTitle", "Processing result title. A typical title for a processing result will be the query\nused to fetch documents from that source. For certain document sources the query\nmay not be needed (on-disk XML, feed of syndicated news); in such cases, the input\ncomponent should set its title properly for visual interfaces such as the\nworkbench.", "Title", "Processing result title", "A typical title for a processing result will be the query used to fetch documents from that source. For certain document sources the query may not be needed (on-disk XML, feed of syndicated news); in such cases, the input component should set its title properly for visual interfaces such as the workbench.", "Search result information", AttributeLevel.BASIC, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String START = "start";
        public static final String RESULTS = "results";
        public static final String QUERY = "query";
        public static final String RESULTS_TOTAL = "results-total";
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";
        public static final String PROCESSING_TIME_TOTAL = "processing-time-total";
        public static final String PROCESSING_TIME_SOURCE = "processing-time-source";
        public static final String PROCESSING_TIME_ALGORITHM = "processing-time-algorithm";
        public static final String PROCESSING_RESULT_TITLE = "processing-result.title";

        protected Keys() {
        }
    }
}

