/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.kmeans;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.text.preprocessing.LabelFormatterDescriptor;
import org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipelineDescriptor;
import org.carrot2.text.vsm.TermDocumentMatrixBuilderDescriptor;
import org.carrot2.text.vsm.TermDocumentMatrixReducerDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class BisectingKMeansClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm";
    public final String prefix = "BisectingKMeansClusteringAlgorithm";
    public final String title = "A very simple implementation of bisecting k-means clustering";
    public final String label = "";
    public final String description = "Unlike other algorithms in Carrot2, this one creates hard clusterings (one document belongs only to one cluster). On the other hand, the clusters are labeled only with individual words that may not always fully correspond to all documents in the cluster.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "BisectingKMeansClusteringAlgorithm";
    }

    public String getTitle() {
        return "A very simple implementation of bisecting k-means clustering";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Unlike other algorithms in Carrot2, this one creates hard clusterings (one document belongs only to one cluster). On the other hand, the clusters are labeled only with individual words that may not always fully correspond to all documents in the cluster.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.documents);
        ownAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusters);
        ownAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusterCount);
        ownAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.maxIterations);
        ownAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.useDimensionalityReduction);
        ownAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.partitionCount);
        ownAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.labelCount);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.documents);
        allAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusters);
        allAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.clusterCount);
        allAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.maxIterations);
        allAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.useDimensionalityReduction);
        allAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.partitionCount);
        allAttrs.add(BisectingKMeansClusteringAlgorithmDescriptor.attributes.labelCount);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder clusterCount(int value) {
            this.map.put("BisectingKMeansClusteringAlgorithm.clusterCount", value);
            return this;
        }

        public AttributeBuilder maxIterations(int value) {
            this.map.put("BisectingKMeansClusteringAlgorithm.maxIterations", value);
            return this;
        }

        public AttributeBuilder useDimensionalityReduction(boolean value) {
            this.map.put("BisectingKMeansClusteringAlgorithm.useDimensionalityReduction", value);
            return this;
        }

        public AttributeBuilder partitionCount(int value) {
            this.map.put("BisectingKMeansClusteringAlgorithm.partitionCount", value);
            return this;
        }

        public AttributeBuilder labelCount(int value) {
            this.map.put("BisectingKMeansClusteringAlgorithm.labelCount", value);
            return this;
        }

        public BasicPreprocessingPipelineDescriptor.AttributeBuilder preprocessingPipeline() {
            return BasicPreprocessingPipelineDescriptor.attributeBuilder(this.map);
        }

        public TermDocumentMatrixBuilderDescriptor.AttributeBuilder matrixBuilder() {
            return TermDocumentMatrixBuilderDescriptor.attributeBuilder(this.map);
        }

        public TermDocumentMatrixReducerDescriptor.AttributeBuilder matrixReducer() {
            return TermDocumentMatrixReducerDescriptor.attributeBuilder(this.map);
        }

        public LabelFormatterDescriptor.AttributeBuilder labelFormatter() {
            return LabelFormatterDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo documents;
        public final AttributeInfo clusters;
        public final AttributeInfo clusterCount;
        public final AttributeInfo maxIterations;
        public final AttributeInfo useDimensionalityReduction;
        public final AttributeInfo partitionCount;
        public final AttributeInfo labelCount;
        public final BasicPreprocessingPipelineDescriptor.Attributes preprocessingPipeline;
        public final TermDocumentMatrixBuilderDescriptor.Attributes matrixBuilder;
        public final TermDocumentMatrixReducerDescriptor.Attributes matrixReducer;
        public final LabelFormatterDescriptor.Attributes labelFormatter;

        private Attributes() {
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "documents", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "clusters", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.clusterCount = new AttributeInfo("BisectingKMeansClusteringAlgorithm.clusterCount", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "clusterCount", "The number of clusters to create. The algorithm will create at most the specified\nnumber of clusters.", "Cluster count", "The number of clusters to create", "The algorithm will create at most the specified number of clusters.", "Clusters", AttributeLevel.BASIC, null);
            this.maxIterations = new AttributeInfo("BisectingKMeansClusteringAlgorithm.maxIterations", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "maxIterations", "The maximum number of k-means iterations to perform.", "Maximum iterations", "The maximum number of k-means iterations to perform", null, "K-means", AttributeLevel.BASIC, null);
            this.useDimensionalityReduction = new AttributeInfo("BisectingKMeansClusteringAlgorithm.useDimensionalityReduction", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "useDimensionalityReduction", "Use dimensionality reduction. If <code>true</code>, k-means will be applied on the\ndimensionality-reduced term-document matrix with the number of dimensions being\nequal to the number of requested clusters. If <code>false</code>, the k-means will\nbe performed directly on the original term-document matrix.", "Use dimensionality reduction", "Use dimensionality reduction", "If <code>true</code>, k-means will be applied on the dimensionality-reduced term-document matrix with the number of dimensions being equal to the number of requested clusters. If <code>false</code>, the k-means will be performed directly on the original term-document matrix.", "K-means", AttributeLevel.BASIC, null);
            this.partitionCount = new AttributeInfo("BisectingKMeansClusteringAlgorithm.partitionCount", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "partitionCount", "Partition count. The number of partitions to create at each k-means clustering\niteration.", "Partition count", "Partition count", "The number of partitions to create at each k-means clustering iteration.", "K-means", AttributeLevel.BASIC, null);
            this.labelCount = new AttributeInfo("BisectingKMeansClusteringAlgorithm.labelCount", "org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm", "labelCount", "Label count. The minimum number of labels to return for each cluster.", "Label count", "Label count", "The minimum number of labels to return for each cluster.", "Clusters", AttributeLevel.BASIC, null);
            this.preprocessingPipeline = BasicPreprocessingPipelineDescriptor.attributes;
            this.matrixBuilder = TermDocumentMatrixBuilderDescriptor.attributes;
            this.matrixReducer = TermDocumentMatrixReducerDescriptor.attributes;
            this.labelFormatter = LabelFormatterDescriptor.attributes;
        }
    }

    public static class Keys {
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";
        public static final String CLUSTER_COUNT = "BisectingKMeansClusteringAlgorithm.clusterCount";
        public static final String MAX_ITERATIONS = "BisectingKMeansClusteringAlgorithm.maxIterations";
        public static final String USE_DIMENSIONALITY_REDUCTION = "BisectingKMeansClusteringAlgorithm.useDimensionalityReduction";
        public static final String PARTITION_COUNT = "BisectingKMeansClusteringAlgorithm.partitionCount";
        public static final String LABEL_COUNT = "BisectingKMeansClusteringAlgorithm.labelCount";

        protected Keys() {
        }
    }
}

