/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.mobylet.core.Mobylet;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.device.DeviceDisplay;
import org.mobylet.core.image.ImageCacheHelper;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.image.ImageReader;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.util.HttpUtils;
import org.mobylet.core.util.ImageUtils;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.OSUtils;
import org.mobylet.core.util.OutputStreamUtils;
import org.mobylet.core.util.PathUtils;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletImageCacheHelper
implements ImageCacheHelper {
    public static final String CONJUNCTION = "+";
    public static final String CONJUNCTION_BSIZE = "x";
    public static final String CONJUNCTION_DATE = "-";
    public static final String ESCAPE = "++";
    protected URI cacheBaseUri;
    protected boolean isInitializedUri = false;

    @Override
    public boolean existsCache(String key) {
        if (StringUtils.isEmpty(key)) {
            return false;
        }
        URI cacheBase = this.getCacheBase();
        if (cacheBase == null) {
            return false;
        }
        File cacheBaseDir = new File(cacheBase);
        File cacheFile = new File(cacheBaseDir.getAbsolutePath() + File.separator + key);
        return cacheFile.exists() && cacheFile.isFile() && cacheFile.canRead();
    }

    @Override
    public InputStream get(String key) {
        if (!this.existsCache(key)) {
            return null;
        }
        File cacheFile = this.getCacheFile(key);
        try {
            return new FileInputStream(cacheFile);
        }
        catch (FileNotFoundException e) {
            throw new MobyletRuntimeException("File NotFound path = " + cacheFile.getAbsolutePath(), e);
        }
    }

    @Override
    public URI getCacheBase() {
        if (this.isInitializedUri) {
            return this.cacheBaseUri;
        }
        ImageConfig config = SingletonUtils.get(ImageConfig.class);
        String cacheBaseDirPath = config.getCacheBaseDirPath();
        if (StringUtils.isNotEmpty(cacheBaseDirPath)) {
            File cacheBaseDir = new File(cacheBaseDirPath);
            if (cacheBaseDir.exists() && cacheBaseDir.isDirectory() && cacheBaseDir.canWrite()) {
                this.cacheBaseUri = cacheBaseDir.toURI();
            } else if (cacheBaseDir.mkdirs() && cacheBaseDir.canWrite()) {
                this.cacheBaseUri = cacheBaseDir.toURI();
            }
        }
        this.isInitializedUri = true;
        return this.getCacheBase();
    }

    @Override
    public String getCacheKey(String imgPath) {
        HttpServletRequest request = RequestUtils.get();
        Mobylet m = MobyletFactory.getInstance();
        DeviceDisplay display = m.getDisplay();
        boolean isNetworkPath = PathUtils.isNetworkPath(imgPath);
        if (display != null && StringUtils.isNotEmpty(imgPath)) {
            String cacheFilePath = null;
            if (isNetworkPath) {
                cacheFilePath = imgPath.replace(CONJUNCTION, ESCAPE).replace("://", CONJUNCTION + File.separator).replace("/", File.separator).replace(":", "_").replace("?", "%Q").replace("&", "%P").replace("=", "%L").replace(";", "%S");
            } else {
                cacheFilePath = imgPath.startsWith(File.separator) ? imgPath.substring(File.separator.length()) : imgPath;
                cacheFilePath = cacheFilePath.replace(CONJUNCTION, ESCAPE).replace("/", File.separator).replace(":", "_");
            }
            if (cacheFilePath.length() > 255) {
                StringBuffer buf = new StringBuffer();
                int length = 0;
                for (char c : cacheFilePath.toCharArray()) {
                    if (++length > 250 && c != File.separatorChar) {
                        buf.append(CONJUNCTION + File.separator);
                        buf.append(c);
                        length = 0;
                        continue;
                    }
                    if (c == File.separatorChar) {
                        buf.append(c);
                        length = 0;
                        continue;
                    }
                    buf.append(c);
                }
                cacheFilePath = buf.toString();
            }
            String w = request.getParameter("w");
            cacheFilePath = cacheFilePath + File.separator + (StringUtils.isNotEmpty(w) ? "w" + w + CONJUNCTION_BSIZE + display.getWidth() : "") + CONJUNCTION + (Object)((Object)ImageUtils.getScaleType());
            if (isNetworkPath) {
                HttpURLConnection connection = HttpUtils.getHttpUrlConnection(imgPath);
                try {
                    connection.setRequestMethod("HEAD");
                }
                catch (ProtocolException e) {
                    throw new MobyletRuntimeException("\u3053\u306e\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3067\u306fHEAD\u8981\u6c42\u304c\u884c\u3048\u307e\u305b\u3093 : " + connection.getClass().getName(), e);
                }
                finally {
                    connection.disconnect();
                }
                String uniqueVersionString = connection.getHeaderField("Last-Modified");
                if (StringUtils.isEmpty(uniqueVersionString)) {
                    uniqueVersionString = connection.getHeaderField("Content-Length");
                }
                if (StringUtils.isEmpty(uniqueVersionString)) {
                    uniqueVersionString = "1";
                }
                cacheFilePath = cacheFilePath + CONJUNCTION_DATE + PathUtils.getUniqueFilePath(uniqueVersionString);
            } else {
                ImageReader imageReader = SingletonUtils.get(ImageReader.class);
                File localFile = imageReader.getFile(imgPath);
                if (localFile != null && localFile.exists() && localFile.canRead()) {
                    cacheFilePath = cacheFilePath + CONJUNCTION_DATE + localFile.lastModified();
                }
            }
            if (cacheFilePath.length() > 256 && OSUtils.isWindows()) {
                return null;
            }
            return cacheFilePath;
        }
        return null;
    }

    @Override
    public void put(String key, InputStream imgStream) {
        block12: {
            if (StringUtils.isEmpty(key)) {
                return;
            }
            if (!this.enableCache()) {
                return;
            }
            Mobylet m = MobyletFactory.getInstance();
            DeviceDisplay display = m.getDisplay();
            if (display == null || !StringUtils.isNotEmpty(key)) break block12;
            File cacheFile = this.getCacheFile(key);
            if (cacheFile.exists()) {
                return;
            }
            File[] delFiles = cacheFile.getParentFile().listFiles(new GcCacheFileFilter(cacheFile.getAbsolutePath()));
            if (delFiles != null && delFiles.length > 0) {
                for (File delFile : delFiles) {
                    MobyletLogger logger;
                    boolean isSuccess = delFile.delete();
                    if (isSuccess || !delFile.exists() || (logger = SingletonUtils.get(MobyletLogger.class)) == null || !logger.isLoggable()) continue;
                    logger.log("[mobylet] \u53e4\u3044\u30ad\u30e3\u30c3\u30b7\u30e5\u753b\u50cf\u306e\u524a\u9664\u306b\u5931\u6557 = " + delFile.getAbsolutePath());
                }
            }
            try {
                FileOutputStream cacheOutStream;
                block14: {
                    block13: {
                        MobyletLogger logger;
                        boolean isSuccess = cacheFile.getParentFile().mkdirs();
                        if (!isSuccess && !cacheFile.getParentFile().exists() && (logger = SingletonUtils.get(MobyletLogger.class)) != null && logger.isLoggable()) {
                            logger.log("[mobylet] \u30ad\u30e3\u30c3\u30b7\u30e5\u753b\u50cf\u914d\u7f6e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u308c\u307e\u305b\u3093 = " + cacheFile.getParentFile().getAbsolutePath());
                        }
                        if (!cacheFile.createNewFile()) break block13;
                        cacheOutStream = null;
                        try {
                            cacheOutStream = new FileOutputStream(cacheFile);
                            cacheOutStream.write(InputStreamUtils.getAllBytes(imgStream));
                        }
                        catch (IOException e) {
                            try {
                                throw e;
                            }
                            catch (Throwable throwable) {
                                OutputStreamUtils.closeQuietly(cacheOutStream);
                                throw throwable;
                            }
                        }
                        break block14;
                    }
                    throw new MobyletRuntimeException("\u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557[false] path = " + cacheFile.getAbsolutePath(), null);
                }
                OutputStreamUtils.closeQuietly(cacheOutStream);
            }
            catch (IOException e) {
                throw new MobyletRuntimeException("\u30ad\u30e3\u30c3\u30b7\u30e5\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557 path = " + cacheFile.getAbsolutePath(), e);
            }
        }
    }

    @Override
    public boolean enableCache() {
        return this.getCacheBase() != null;
    }

    protected File getCacheFile(String key) {
        return new File(new File(this.getCacheBase()).getAbsolutePath() + File.separator + key);
    }

    public static class GcCacheFileFilter
    implements FilenameFilter {
        public String prefixPath = null;

        public GcCacheFileFilter(String path) {
            int until;
            int from;
            if (StringUtils.isNotEmpty(path) && (from = path.lastIndexOf(File.separator)) < (until = path.lastIndexOf(MobyletImageCacheHelper.CONJUNCTION_DATE)) && until > 0) {
                this.prefixPath = path.substring(from + 1, until + 1);
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            return StringUtils.isNotEmpty(this.prefixPath) && name.startsWith(this.prefixPath);
        }
    }
}

