/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.detector.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.mobylet.core.Carrier;
import org.mobylet.core.detector.CarrierDetector;
import org.mobylet.core.dialect.MobyletDialect;
import org.mobylet.core.http.MobyletContext;
import org.mobylet.core.selector.DialectSelector;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletCarrierDetector
implements CarrierDetector {
    protected Set<MobyletDialect> dialects;

    public MobyletCarrierDetector() {
        this.initialize();
    }

    @Override
    public Carrier getCarrier() {
        MobyletContext context = RequestUtils.getMobyletContext();
        Carrier carrier = context.get(Carrier.class);
        if (carrier == null) {
            context.set((Object)this.getCarrier(RequestUtils.get()));
            return this.getCarrier();
        }
        return carrier;
    }

    @Override
    public Carrier getCarrier(HttpServletRequest request) {
        String userAgent = RequestUtils.getUserAgent(request);
        if (StringUtils.isNotEmpty(userAgent)) {
            for (MobyletDialect dialect : this.dialects) {
                if (!dialect.getCarrierMatchRegex().matcher(userAgent).matches()) continue;
                return dialect.getCarrier();
            }
        }
        return Carrier.OTHER;
    }

    protected void initialize() {
        this.dialects = new LinkedHashSet<MobyletDialect>();
        DialectSelector dialectSelector = SingletonUtils.get(DialectSelector.class);
        this.dialects.add(dialectSelector.getDialect(Carrier.DOCOMO));
        this.dialects.add(dialectSelector.getDialect(Carrier.AU));
        this.dialects.add(dialectSelector.getDialect(Carrier.SOFTBANK));
    }
}

