/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.config;

import java.io.File;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.mobylet.core.Carrier;
import org.mobylet.core.Mobylet;
import org.mobylet.core.config.enums.JSession;
import org.mobylet.core.config.enums.SecureGateway;
import org.mobylet.core.config.enums.SessionKey;
import org.mobylet.core.initializer.MobyletInitializer;
import org.mobylet.core.type.ContentType;
import org.mobylet.core.util.StringUtils;

public class MobyletConfig {
    public static final String RES_DEVICE_DIR = "device/";
    public static final String RES_EMOJI_DIR = "emoji/";
    public static final String RES_IP_DIR = "ip/";
    protected String configDir;
    protected List<MobyletInitializer> initializers;
    protected List<Carrier> throughCarrierList;
    protected ContentType contentType;
    protected String deviceDir;
    protected String emojiDir;
    protected String ipDir;
    protected String emojiImagePath;
    protected Proxy httpProxy;
    protected JSession jSession;
    protected SecureGateway secureGateway;
    protected Integer sessionTimeout;
    protected SessionKey sessionKey;
    protected Class<? extends Mobylet> mobyletClass;
    protected Boolean useCSSExpand;
    protected Boolean cssExpandRemovedClass;

    public MobyletConfig(String configDir) {
        this.configDir = StringUtils.isEmpty(configDir) ? "." + File.separator : (configDir.endsWith(File.separator) || configDir.endsWith("/") ? configDir : configDir + File.separator);
        this.initializers = new ArrayList<MobyletInitializer>();
        this.throughCarrierList = new ArrayList<Carrier>();
    }

    public String getDeviceDir() {
        if (StringUtils.isEmpty(this.deviceDir)) {
            return RES_DEVICE_DIR;
        }
        return this.deviceDir;
    }

    public String getEmojiDir() {
        if (StringUtils.isEmpty(this.emojiDir)) {
            return RES_EMOJI_DIR;
        }
        return this.emojiDir;
    }

    public String getIpDir() {
        if (StringUtils.isEmpty(this.ipDir)) {
            return RES_IP_DIR;
        }
        return this.ipDir;
    }

    public String getEmojiImagePath() {
        return this.emojiImagePath;
    }

    public ContentType getContentType() {
        if (this.contentType == null) {
            return ContentType.HTML;
        }
        return this.contentType;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public JSession getJSession() {
        if (this.jSession == null) {
            return JSession.DEFAULT;
        }
        return this.jSession;
    }

    public SecureGateway getSecureGateway() {
        if (this.secureGateway == null) {
            return SecureGateway.NONE;
        }
        return this.secureGateway;
    }

    public Integer getSessionTimeout() {
        if (this.sessionTimeout == null) {
            return 30;
        }
        return this.sessionTimeout;
    }

    public SessionKey getSessionKey() {
        if (this.sessionKey == null) {
            return SessionKey.GUID;
        }
        return this.sessionKey;
    }

    public Class<? extends Mobylet> getMobyletClass() {
        return this.mobyletClass;
    }

    public void setDeviceDir(String deviceDir) {
        this.deviceDir = deviceDir;
    }

    public void setEmojiDir(String emojiDir) {
        this.emojiDir = emojiDir;
    }

    public void setIpDir(String ipDir) {
        this.ipDir = ipDir;
    }

    public void setEmojiImagePath(String emojiImagePath) {
        this.emojiImagePath = emojiImagePath;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void addInitializer(MobyletInitializer initializer) {
        this.initializers.add(initializer);
    }

    public boolean removeInitializer(MobyletInitializer initializer) {
        return this.initializers.remove(initializer);
    }

    public List<MobyletInitializer> getInitializers() {
        return this.initializers;
    }

    public void addThroughCarrier(Carrier carrier) {
        this.throughCarrierList.add(carrier);
    }

    public boolean removeThroughCarrier(Carrier carrier) {
        return this.throughCarrierList.remove((Object)carrier);
    }

    public List<Carrier> getThroughCarrierList() {
        return this.throughCarrierList;
    }

    public boolean containsThroughCarrier(Carrier carrier) {
        return this.throughCarrierList.contains((Object)carrier);
    }

    public Proxy getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(Proxy httpProxy) {
        this.httpProxy = httpProxy;
    }

    public void setJSession(JSession jSession) {
        this.jSession = jSession;
    }

    public void setSecureGateway(SecureGateway secureGateway) {
        this.secureGateway = secureGateway;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setSessionKey(SessionKey sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setMobyletClass(String className) {
        try {
            this.mobyletClass = Class.forName(className).asSubclass(Mobylet.class);
        }
        catch (Exception e) {
            this.mobyletClass = null;
        }
    }

    public boolean useCSSExpand() {
        if (this.useCSSExpand == null) {
            this.useCSSExpand = false;
        }
        return this.useCSSExpand;
    }

    public void setUseCSSExpand(boolean use) {
        this.useCSSExpand = use;
    }

    public boolean isCSSExpandRemovedClass() {
        if (this.cssExpandRemovedClass == null) {
            this.cssExpandRemovedClass = false;
        }
        return this.cssExpandRemovedClass;
    }

    public void setCSSExpandRemovedClass(boolean isCSSExpandRemovedClass) {
        this.cssExpandRemovedClass = isCSSExpandRemovedClass;
    }
}

